/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.JColorChooser;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.colorscheme.ColorHistory;
import thunderheadeng.gui.colorscheme.DoubleRGBChooser;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.util.ColorPool;

public class SimpleColorChooser
extends guiDialog {
    public static final int OPT_EXCLUDE_ALPHA = 1;
    private final JColorChooser d_chooser;
    private final int d_options;
    private static JColorChooser s_chooser;

    public SimpleColorChooser(Window window, String string, int n) {
        this(window, string, true, n);
    }

    public SimpleColorChooser(Window window, String string, boolean bl, int n) {
        super(window, string, 9);
        this.d_options = n;
        this.d_chooser = SimpleColorChooser.getChooser(bl);
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = this.d_chooser.getChooserPanels();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("RGB", abstractColorChooserPanelArray[3]);
        jTabbedPane.add(Intl.intl("Palette"), abstractColorChooserPanelArray[0]);
        jTabbedPane.add(Intl.intl("Sliders"), abstractColorChooserPanelArray[2]);
        this.getDialogPane().setLayout(new GridBagLayout());
        int n2 = 0;
        GridBagUtil.add(this.getDialogPane(), jTabbedPane, 0, ++n2, 2, 1, 0, 0, 11, 0);
        GridBagUtil.add(this.getDialogPane(), this.d_chooser.getPreviewPanel(), 0, ++n2, 1, 1, 0, 0, 0, 0, 0, 1.0, 1.0, 10);
    }

    private static boolean testOption(int n, int n2) {
        return (n & n2) == n2;
    }

    @Override
    public int doModal() {
        return super.doModal();
    }

    public Color getColor() {
        Color color = this.d_chooser.getColor();
        float[] fArray = new float[3];
        color.getRGBColorComponents(fArray);
        double d = 1.0;
        if (!SimpleColorChooser.testOption(this.d_options, 1)) {
            d = (double)color.getAlpha() / 255.0;
        }
        Color color2 = new Color(fArray[0], fArray[1], fArray[2], (float)d);
        return ColorPool.get(color2);
    }

    public void setColor(Color color) {
        this.d_chooser.setColor(color);
        float[] fArray = new float[4];
        color.getComponents(fArray);
    }

    private static JColorChooser getChooser(boolean bl) {
        if (!bl) {
            return SimpleColorChooser.createChooser();
        }
        if (s_chooser == null) {
            s_chooser = SimpleColorChooser.createChooser();
            s_chooser.getSelectionModel().addChangeListener(changeEvent -> {
                SimpleColorChooser simpleColorChooser = (SimpleColorChooser)SwingUtilities.getAncestorOfClass(SimpleColorChooser.class, s_chooser);
                Color color = simpleColorChooser != null ? simpleColorChooser.getColor() : s_chooser.getColor();
                ColorHistory.add(color);
            });
        }
        return s_chooser;
    }

    private static JColorChooser createChooser() {
        JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.addChooserPanel(new DoubleRGBChooser());
        return jColorChooser;
    }
}

