/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.theUtil;

public class ColorScheme
implements Cloneable {
    private String d_name;
    private Map<String, Color> d_colors;
    public static final String SEPARATOR = ".";

    public ColorScheme(String string) {
        this.d_name = string;
        this.d_colors = new LinkedHashMap<String, Color>();
    }

    public Object clone(String string) {
        try {
            ColorScheme colorScheme = (ColorScheme)super.clone();
            colorScheme.d_name = string;
            return colorScheme;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getName() {
        return this.d_name;
    }

    public String toString() {
        return "ColorScheme: " + this.getName() + " (" + this.d_colors.size() + " colors)";
    }

    public Color getColor(IPropertySet.Prop<Color> prop) {
        return this.d_colors.getOrDefault(prop.key.toString(), (Color)prop.defVal);
    }

    public void setColor(IPropertySet.Prop<Color> prop, Color color) {
        this.d_colors.put(prop.key.toString(), color);
    }

    public String[] getColorNames() {
        return theUtil.toArray(this.d_colors.keySet(), String.class);
    }

    public void load(Properties properties, String string) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(string.length());
            try {
                Color color = Color.decode((String)properties.get(string2));
                this.d_colors.put(string3, color);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void store(Properties properties, String string) {
        for (Map.Entry<String, Color> entry : this.d_colors.entrySet()) {
            String string2 = entry.getKey();
            Color color = entry.getValue();
            properties.setProperty(string + this.d_name + SEPARATOR + string2, this.encodeColor(color));
        }
    }

    private String encodeColor(Color color) {
        int n = (color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue();
        return "0x" + Integer.toHexString(n);
    }
}

