/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.colorscheme.SimpleColorChooser;

public class ColorChooser {
    private JFrame d_owner;
    private String d_title;
    private Color d_color;
    private SimpleColorChooser d_chooser;
    private final int d_options;

    public ColorChooser(Window window, String string) {
        this(window, string, 0);
    }

    public ColorChooser(Window window, String string, int n) {
        this(window, string, new JButton().getBackground(), n);
    }

    public ColorChooser(Window window, String string, Color color) {
        this(window, string, color, 0);
    }

    public ColorChooser(Window window, String string, Color color, int n) {
        this.d_color = color == null ? Color.GRAY : color;
        this.d_options = n;
    }

    public JButton createEditorButton() {
        ColorButton colorButton = new ColorButton();
        colorButton.setColor(this.d_color);
        return colorButton;
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color color) {
        this.d_color = color;
    }

    class ColorButton
    extends JButton
    implements Modifiable {
        private boolean d_modified = false;

        public ColorButton() {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ColorChooser.this.d_chooser == null) {
                        ColorChooser.this.d_chooser = new SimpleColorChooser((Window)ColorChooser.this.d_owner, ColorChooser.this.d_title, ColorChooser.this.d_options);
                    }
                    ColorChooser.this.d_chooser.setColor(ColorChooser.this.d_color);
                    if (ColorChooser.this.d_chooser.doModal() == 1) {
                        ColorButton.this.setColor(ColorChooser.this.d_chooser.getColor());
                    }
                }
            });
            this.setText("MMM");
        }

        public void setColor(Color color) {
            ColorChooser.this.d_color = color;
            this.d_modified = true;
            this.repaint();
        }

        public Color getColor() {
            return ColorChooser.this.d_color;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Rectangle rectangle = this.getVisibleRect();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            super.paintBorder(graphics);
            int n = 6;
            int n2 = 5;
            rectangle.width -= 2 * n + 1;
            rectangle.height -= 2 * n2 + 1;
            graphics.setColor(ColorChooser.this.d_color);
            graphics.fillRect(n, n2, rectangle.width, rectangle.height);
            graphics.setColor(Color.black);
            graphics.drawRect(n, n2, rectangle.width, rectangle.height);
        }

        @Override
        public boolean isModified() {
            return this.d_modified;
        }

        @Override
        public void setModified(boolean bl) {
            this.d_modified = bl;
        }
    }
}

