/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.colorscheme.SimpleColorChooser;
import thunderheadeng.util.ColorPool;

public class ColorButton
extends JButton
implements Modifiable {
    private Color d_color;
    private boolean d_modified = false;
    private final List d_observers;
    private final int d_options;

    public ColorButton() {
        this(0);
    }

    public ColorButton(int n) {
        super("MMM");
        this.d_options = n;
        this.d_color = this.getBackground();
        this.d_observers = new LinkedList();
        this.setPreferredSize(this.getPreferredSize());
        this.setText("");
        this.setBorder(BorderFactory.createEmptyBorder(5, 6, 5, 6));
        this.addActionListener(actionEvent -> this.editColor());
    }

    public void editColor() {
        SimpleColorChooser simpleColorChooser = new SimpleColorChooser((Window)Application.getApp().getActiveFrame(), Intl.intl("Color"), this.d_options);
        Color color = this.d_color == null ? Color.WHITE : this.d_color;
        simpleColorChooser.setColor(color);
        if (simpleColorChooser.doModal() == 1) {
            this.setColor(simpleColorChooser.getColor());
            this.yell();
            this.editingFinished(true);
        } else {
            this.editingFinished(false);
        }
    }

    protected void editingFinished(boolean bl) {
    }

    public void setColor(Color color) {
        this.d_color = color;
        this.d_modified = true;
        this.repaint();
    }

    public Color getColor() {
        return this.d_color;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle rectangle = this.getBounds();
        if (!this.isContentAreaFilled()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        }
        if (this.d_color == null) {
            return;
        }
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        rectangle.width = rectangle.width - insets.right - insets.left - 1;
        rectangle.height = rectangle.height - insets.top - insets.bottom - 1;
        Color color = this.d_color.getAlpha() == 255 ? this.d_color : ColorPool.get(new Color(this.d_color.getRed(), this.d_color.getGreen(), this.d_color.getBlue(), 255));
        graphics.setColor(color);
        graphics.fillRect(n, n2, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, rectangle.width, rectangle.height);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean bl) {
        this.d_modified = bl;
    }

    public void yell() {
        for (Object e : this.d_observers) {
            ((Observer)e).update(null, null);
        }
    }

    public void addObserver(Observer observer) {
        this.d_observers.add(observer);
    }

    public void deleteObserver(Observer observer) {
        this.d_observers.remove(observer);
    }
}

