/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.animate;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import thunderheadeng.Intl;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.animate.IAnimView;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.BitOptions;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.theUtil;

public class TimeView
implements IAnimView,
IEventObserver {
    public static final int OPT_REVERSE = 1;
    public static final int OPT_LOOP = 2;
    private final Mediator d_mediator;
    private final IAnimSession d_session;
    private final BitOptions d_options;
    private final guiPanel d_panel;
    private final JSlider d_timeSlider;
    private final JButton d_playPauseBtn;
    private final JButton d_stopBtn;
    private final JButton d_gotoStartBtn;
    private final JButton d_gotoEndBtn;
    private final JButton d_incSpeedBtn;
    private final JButton d_decSpeedBtn;
    private final guiCheckBox d_reverse;
    private final guiCheckBox d_loop;
    private Timer d_sliderTimer;

    public TimeView(Mediator mediator, IAnimSession iAnimSession, int n) {
        this(mediator, iAnimSession, n, null);
    }

    public TimeView(Mediator mediator, IAnimSession iAnimSession, int n, Component component) {
        this.d_options = new BitOptions(n);
        this.d_mediator = mediator;
        this.d_session = iAnimSession;
        this.d_panel = new guiPanel();
        this.d_playPauseBtn = TimeView.newMediaBtn(Intl.intl("Play"), "Play1", actionEvent -> {
            IAnimSession.State state = this.d_session.get(IAnimSession.STATE);
            switch (state) {
                case PAUSED: {
                    this.d_session.set(IAnimSession.STATE, IAnimSession.State.PLAYING);
                    break;
                }
                case PLAYING: {
                    this.d_session.set(IAnimSession.STATE, IAnimSession.State.PAUSED);
                }
            }
        });
        this.d_stopBtn = TimeView.newMediaBtn(Intl.intl("Stop"), "Stop1", actionEvent -> {
            this.d_session.set(IAnimSession.STATE, IAnimSession.State.PAUSED);
            this.d_session.set(IAnimSession.TIME, this.d_session.get(IAnimSession.TIME_RANGE)[0]);
        });
        this.d_gotoStartBtn = TimeView.newMediaBtn(Intl.intl("Move to Beginning"), "SkipBack", actionEvent -> this.d_session.set(IAnimSession.TIME, this.d_session.get(IAnimSession.TIME_RANGE)[0]));
        this.d_gotoEndBtn = TimeView.newMediaBtn(Intl.intl("Move to End"), "SkipForward", actionEvent -> this.d_session.set(IAnimSession.TIME, this.d_session.get(IAnimSession.TIME_RANGE)[1]));
        this.d_incSpeedBtn = TimeView.newMediaBtn(Intl.intl("Increase Speed"), "ScanForward", actionEvent -> this.scaleTime(2.0));
        this.d_decSpeedBtn = TimeView.newMediaBtn(Intl.intl("Decrease Speed"), "ScanBack", actionEvent -> this.scaleTime(0.5));
        this.d_reverse = new guiCheckBox(Intl.intl("Reverse"));
        this.d_reverse.addItemListener(itemEvent -> this.d_session.set(IAnimSession.TIME_SCALE, -1.0 * this.d_session.get(IAnimSession.TIME_SCALE)));
        this.d_loop = new guiCheckBox(Intl.intl("Loop"));
        this.d_loop.addItemListener(itemEvent -> this.d_session.set(IAnimSession.TIME_LOOP, this.d_loop.isSelected()));
        this.d_timeSlider = new JSlider();
        this.d_timeSlider.setMaximum(2000);
        this.d_timeSlider.setFocusable(false);
        this.d_timeSlider.addChangeListener(new SliderListener());
        this.d_timeSlider.setMajorTickSpacing(0);
        this.d_timeSlider.setMinorTickSpacing(0);
        this.d_timeSlider.setPaintTicks(true);
        guiPanel guiPanel2 = new guiPanel();
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
        gridBagHelper.d_colSpace = 3;
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        arrayList.addAll(Arrays.asList(this.d_playPauseBtn, this.d_stopBtn, Box.createHorizontalStrut(3), this.d_gotoStartBtn, this.d_decSpeedBtn, this.d_incSpeedBtn, this.d_gotoEndBtn));
        if (this.d_options.get(2L) && this.d_options.get(1L)) {
            arrayList.add(Box.createHorizontalStrut(3));
            guiPanel guiPanel3 = new guiPanel();
            GridBagHelper gridBagHelper2 = new GridBagHelper(guiPanel3);
            gridBagHelper2.d_rowSpace = 0;
            gridBagHelper2.addRow(this.d_reverse);
            gridBagHelper2.addRow(this.d_loop);
            gridBagHelper2.finalizeRows();
            arrayList.add(guiPanel3);
        } else if (this.d_options.get(1L)) {
            arrayList.add(Box.createHorizontalStrut(3));
            arrayList.add(this.d_reverse);
        } else if (this.d_options.get(2L)) {
            arrayList.add(Box.createHorizontalStrut(3));
            arrayList.add(this.d_loop);
        }
        if (component != null) {
            arrayList.add(Box.createHorizontalStrut(3));
            arrayList.add(component);
        }
        arrayList.add(Integer.valueOf(0));
        gridBagHelper.addRow(theUtil.toArray(arrayList, Object.class));
        gridBagHelper = new GridBagHelper(this.d_panel, false);
        this.d_panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gridBagHelper.d_rowSpace = 4;
        gridBagHelper.addRow(new Object[]{this.d_timeSlider, GridBagHelper.Anchor.CENTER, 0, 1.0});
        gridBagHelper.addRow(new Object[]{guiPanel2, GridBagHelper.Anchor.CENTER, 0});
        this.sync();
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    @Override
    public void connect() {
        if (this.d_sliderTimer != null) {
            return;
        }
        this.d_mediator.getEvents().addObserver(this);
        this.d_sliderTimer = new Timer(16, actionEvent -> this.syncTime());
        this.d_sliderTimer.start();
    }

    @Override
    public void disconnect() {
        if (this.d_sliderTimer == null) {
            return;
        }
        this.d_sliderTimer.stop();
        this.d_sliderTimer = null;
        this.d_mediator.getEvents().removeObserver(this);
    }

    private void scaleTime(double d) {
        double d2 = this.d_session.get(IAnimSession.TIME_SCALE) * d;
        this.d_session.set(IAnimSession.TIME_SCALE, d2);
    }

    private static JButton newMediaBtn(String string, String string2, ActionListener actionListener) {
        return guiUtil.newMediaBtn(string, "media/" + string2, actionListener);
    }

    private static void setMediaIcons(JButton jButton, String string) {
        guiUtil.setMediaIcons(jButton, "media/" + string);
    }

    @Override
    public guiPanel getViewUI() {
        return this.d_panel;
    }

    @Override
    public void update(Events events) {
        IEventRecord<IAnimSession> iEventRecord = events.getEvents(IAnimSession.class, new Class[0]);
        if (iEventRecord.isChanged(this.d_session, IAnimSession.STATE)) {
            this.syncState();
        }
        if (iEventRecord.isChanged(this.d_session, IAnimSession.TIME_SCALE)) {
            this.syncSpeed();
        }
        if (iEventRecord.isChanged(this.d_session, IAnimSession.TIME_LOOP)) {
            this.syncLoop();
        }
    }

    public void sync() {
        this.syncState();
        this.syncLoop();
        this.syncSpeed();
        this.syncTime();
    }

    private void syncState() {
        IAnimSession.State state = this.d_session.get(IAnimSession.STATE);
        switch (state) {
            case PAUSED: {
                this.d_playPauseBtn.setToolTipText(Intl.intl("Play"));
                TimeView.setMediaIcons(this.d_playPauseBtn, "Play1");
                break;
            }
            default: {
                this.d_playPauseBtn.setToolTipText(Intl.intl("Pause"));
                TimeView.setMediaIcons(this.d_playPauseBtn, "Pause");
            }
        }
    }

    private void syncSpeed() {
        double d = this.d_session.get(IAnimSession.TIME_SCALE);
        IListenerStripper iListenerStripper = guiUtil.stripListeners(this.d_reverse);
        this.d_reverse.setSelected(d < 0.0);
        iListenerStripper.restore();
    }

    private void syncLoop() {
        boolean bl = this.d_session.get(IAnimSession.TIME_LOOP);
        IListenerStripper iListenerStripper = guiUtil.stripListeners(this.d_loop);
        this.d_loop.setSelected(bl);
        iListenerStripper.restore();
    }

    private void syncTime() {
        double[] dArray;
        double d = this.d_session.get(IAnimSession.TIME);
        this.d_stopBtn.setEnabled(d > (dArray = this.d_session.get(IAnimSession.TIME_RANGE))[0]);
        double d2 = dArray[1] - dArray[0];
        int n = (int)(d / d2 * (double)this.d_timeSlider.getMaximum());
        IListenerStripper iListenerStripper = guiUtil.stripListeners(this.d_timeSlider::addChangeListener, this.d_timeSlider::getChangeListeners, this.d_timeSlider::removeChangeListener);
        this.d_timeSlider.setValue(n);
        iListenerStripper.restore();
    }

    private class SliderListener
    implements ChangeListener {
        private boolean d_slidingTime = false;
        private IAnimSession.State d_stateBeforeSliding = IAnimSession.State.PAUSED;

        private SliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.d_slidingTime != TimeView.this.d_timeSlider.getValueIsAdjusting()) {
                this.d_slidingTime = TimeView.this.d_timeSlider.getValueIsAdjusting();
                if (this.d_slidingTime) {
                    this.d_stateBeforeSliding = TimeView.this.d_session.get(IAnimSession.STATE);
                    TimeView.this.d_session.set(IAnimSession.STATE, IAnimSession.State.PAUSED);
                } else {
                    TimeView.this.d_session.set(IAnimSession.STATE, this.d_stateBeforeSliding);
                }
            }
            double d = (double)TimeView.this.d_timeSlider.getValue() / (double)TimeView.this.d_timeSlider.getMaximum();
            double[] dArray = TimeView.this.d_session.get(IAnimSession.TIME_RANGE);
            double d2 = dArray[0] + (dArray[1] - dArray[0]) * d;
            TimeView.this.d_session.set(IAnimSession.TIME, d2);
        }
    }
}

