/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.animate;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.Timer;
import thunderheadeng.Intl;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.animate.IAnimView;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiStatusBar;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;

public class StatusView
implements IAnimView,
IEventObserver {
    private final Mediator d_mediator;
    private final IAnimSession d_session;
    private final BarInfo d_barInfo;
    private Timer d_fpsTimer;
    private Timer d_timeTimer;
    private double d_lastFPS = Double.NEGATIVE_INFINITY;
    private double d_lastTime = Double.NEGATIVE_INFINITY;
    private double[] d_lastTimeRange = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};

    public StatusView(Mediator mediator, IAnimSession iAnimSession) {
        this(mediator, iAnimSession, new BarInfo());
    }

    public StatusView(Mediator mediator, IAnimSession iAnimSession, BarInfo barInfo) {
        this.d_mediator = mediator;
        this.d_session = iAnimSession;
        this.d_barInfo = barInfo;
        this.sync();
    }

    public BarInfo getBarInfo() {
        return this.d_barInfo;
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    @Override
    public void connect() {
        if (this.d_fpsTimer != null) {
            return;
        }
        this.d_mediator.getEvents().addObserver(this);
        this.d_fpsTimer = new Timer(1000, actionEvent -> this.syncFPS());
        this.d_fpsTimer.start();
        this.d_timeTimer = new Timer(16, actionEvent -> this.syncTime());
        this.d_timeTimer.start();
    }

    @Override
    public void disconnect() {
        if (this.d_fpsTimer == null) {
            return;
        }
        this.d_timeTimer.stop();
        this.d_fpsTimer.stop();
        this.d_fpsTimer = null;
        this.d_mediator.getEvents().removeObserver(this);
    }

    @Override
    public Component getViewUI() {
        return this.d_barInfo.bar;
    }

    public void sync() {
        this.syncFPS();
        this.syncSpeed();
        this.syncTime();
        this.syncState();
    }

    private static String formatFPS(double d) {
        return String.format(Intl.intl("Framerate: %.1f fps"), d);
    }

    private static String formatTime(double d) {
        int n = (int)Math.floor(d);
        int n2 = n / 60;
        return String.format(Intl.intl("%d:%02d"), n2, n %= 60);
    }

    private static String formatSpeed(double d) {
        String string = "";
        if (d < 0.0) {
            string = string + "-";
        }
        if ((d = Math.abs(d)) < 1.0) {
            string = string + "1/";
            d = 1.0 / d;
        }
        long l = Math.round(d);
        string = string + l + " X";
        return string;
    }

    private static String formatSpeedMsg(double d) {
        String string = StatusView.formatSpeed(d);
        return String.format(Intl.intl("Speed: %s"), string);
    }

    private static String formatTime(double d, double d2) {
        return String.format(Intl.intl("Time: %s / %s"), StatusView.formatTime(d), StatusView.formatTime(d2));
    }

    private static int getDesiredWidth(guiStatusBar guiStatusBar2, int n, String string) {
        guiLabel guiLabel2 = (guiLabel)guiStatusBar2.getPane(n);
        String string2 = guiLabel2.getText();
        guiLabel2.setText(string);
        guiLabel2.setPreferredSize(null);
        Dimension dimension = guiLabel2.getPreferredSize();
        guiLabel2.setText(string2);
        return dimension.width;
    }

    private static void setWidth(guiStatusBar guiStatusBar2, int n, int n2) {
        JComponent jComponent = guiStatusBar2.getPane(n);
        jComponent.setPreferredSize(new Dimension(n2, jComponent.getPreferredSize().height));
    }

    private void syncSpeed() {
        guiStatusBar guiStatusBar2 = this.d_barInfo.bar;
        int n = this.d_barInfo.speedIx;
        int n2 = Math.max(StatusView.getDesiredWidth(guiStatusBar2, n, StatusView.formatSpeedMsg(128.0)), StatusView.getDesiredWidth(guiStatusBar2, n, StatusView.formatSpeedMsg(0.03125)));
        StatusView.setWidth(guiStatusBar2, n, n2);
        double d = this.d_session.get(IAnimSession.TIME_SCALE);
        guiStatusBar2.setMessage(n, StatusView.formatSpeedMsg(d));
    }

    private void syncFPS() {
        double d = this.d_session.getFPS();
        if (d != this.d_lastFPS) {
            guiStatusBar guiStatusBar2 = this.d_barInfo.bar;
            int n = this.d_barInfo.fpsIx;
            int n2 = StatusView.getDesiredWidth(guiStatusBar2, n, StatusView.formatFPS(9999.900390625));
            StatusView.setWidth(guiStatusBar2, n, n2);
            guiStatusBar2.setMessage(n, StatusView.formatFPS(d));
            this.d_lastFPS = d;
        }
    }

    private void syncTime() {
        double d = this.d_session.get(IAnimSession.TIME);
        double[] dArray = this.d_session.get(IAnimSession.TIME_RANGE);
        double d2 = dArray[1];
        if (d != this.d_lastTime || d2 != this.d_lastTimeRange[1]) {
            guiStatusBar guiStatusBar2 = this.d_barInfo.bar;
            int n = this.d_barInfo.timeIx;
            int n2 = StatusView.getDesiredWidth(guiStatusBar2, n, StatusView.formatTime(d, 0.0));
            StatusView.setWidth(guiStatusBar2, n, n2);
            guiStatusBar2.setMessage(n, StatusView.formatTime(d, d2));
            this.d_lastTime = d;
            this.d_lastTimeRange = dArray;
        }
    }

    private void syncState() {
        IAnimSession.State state = this.d_session.get(IAnimSession.STATE);
        double d = this.d_session.get(IAnimSession.TIME);
        double[] dArray = this.d_session.get(IAnimSession.TIME_RANGE);
        String string = state == IAnimSession.State.PAUSED && d == dArray[0] ? Intl.intl("Stopped") : (state == IAnimSession.State.PAUSED ? Intl.intl("Paused") : Intl.intl("Playing"));
        this.d_barInfo.bar.setMessage(this.d_barInfo.statusIx, string);
    }

    @Override
    public void update(Events events) {
        IEventRecord<IAnimSession> iEventRecord = events.getEvents(IAnimSession.class, new Class[0]);
        if (iEventRecord.isChanged(this.d_session, IAnimSession.TIME_SCALE)) {
            this.syncSpeed();
        }
        if (iEventRecord.isChanged(this.d_session, IAnimSession.STATE)) {
            this.syncState();
        }
    }

    public static class BarInfo {
        public final guiStatusBar bar;
        public final int statusIx;
        public final int timeIx;
        public final int speedIx;
        public final int fpsIx;

        public BarInfo() {
            this.bar = new guiStatusBar();
            this.statusIx = 0;
            this.timeIx = this.bar.addPane(new guiLabel(), 0.0);
            this.speedIx = this.bar.addPane(new guiLabel(), 0.0);
            this.fpsIx = this.bar.addPane(new guiLabel(), 0.0);
        }

        public BarInfo(guiStatusBar guiStatusBar2, int n, int n2, int n3, int n4) {
            this.bar = guiStatusBar2;
            this.statusIx = n;
            this.timeIx = n2;
            this.speedIx = n3;
            this.fpsIx = n4;
        }
    }
}

