/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.util.IWarning;
import thunderheadeng.util.WarningReport;

public class WarningDlg<T extends IWarning>
extends guiDialog {
    private WarningReport<T> d_report;
    private final List<T> d_warnings;
    private final guiTableEditor d_editor;
    private final guiTable d_table;
    private final JButton d_saveReportToFileButton;
    private final JButton d_copyReportToClipBoardButton;
    private final MultiLineLabel d_messageLab;
    private final guiPanel d_actionPnl;

    public static <T extends IWarning> WarningDlg create(Component component, String string, String string2, WarningReport<T> warningReport) {
        if ((component = Utils.findParentWindow(component)) instanceof JDialog) {
            return new WarningDlg<T>((Window)((JDialog)component), string, string2, warningReport);
        }
        if (component instanceof JFrame) {
            return new WarningDlg<T>((Window)((JFrame)component), string, string2, warningReport);
        }
        return new WarningDlg<T>((Window)Application.getApp().getActiveFrame(), string, string2, warningReport);
    }

    public WarningDlg(Window window, String string, String string2, WarningReport<T> warningReport) {
        this(window, string, string2, warningReport, 1, Severity.WARNING);
    }

    public WarningDlg(Window window, String string, String string2, WarningReport<T> warningReport, int n, Severity severity) {
        super(window, string, n);
        this.d_report = warningReport;
        this.d_warnings = new ArrayList<T>(this.d_report.getWarnings());
        Object[] objectArray = new Class[this.d_report.getInfoTypes().length];
        Arrays.fill(objectArray, String.class);
        this.d_table = guiTableUtil.fixedColumnTable(this.d_report.getInfoDescriptions(), (Class[])objectArray, 7);
        this.d_table.setSortOrder(0);
        this.d_table.setAutoResizeMode(0);
        this.d_editor = new guiTableEditor(this.d_table, 0);
        this.d_table.setCellSelectionEnabled(false);
        this.d_table.setRowSelectionAllowed(true);
        CellRenderer cellRenderer = new CellRenderer();
        CellEditor cellEditor = new CellEditor();
        for (int i = 0; i < this.d_report.getInfoTypes().length; ++i) {
            this.d_table.getColumnModel().getColumn(i).setCellRenderer(cellRenderer);
            this.d_table.getColumnModel().getColumn(i).setCellEditor(cellEditor);
        }
        this.d_table.addMouseListener(new MouseMessageListener());
        this.d_saveReportToFileButton = new JButton(Intl.intl("Save to File..."));
        this.d_saveReportToFileButton.setToolTipText(Intl.intl("Save the list of errors to a file."));
        this.d_saveReportToFileButton.addActionListener(new SaveToFileAction());
        this.d_copyReportToClipBoardButton = new JButton(Intl.intl("Copy to Clipboard"));
        this.d_copyReportToClipBoardButton.setToolTipText(Intl.intl("Copy the list of errors to the clipboard."));
        this.d_copyReportToClipBoardButton.addActionListener(new CopyToClipboardAction());
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        Icon icon = null;
        switch (severity) {
            case WARNING: {
                icon = UIManager.getIcon("OptionPane.warningIcon");
                break;
            }
            case ERROR: {
                icon = UIManager.getIcon("OptionPane.errorIcon");
            }
        }
        JLabel jLabel = new JLabel(icon);
        this.d_messageLab = new MultiLineLabel(string2);
        int n2 = 0;
        GridBagUtil.add(guiPanel2, jLabel, 0, n2, 1, 1, 0, 0, 12, 6, 2, 0.0, 0.0, 10);
        GridBagUtil.add(guiPanel2, this.d_messageLab, 1, n2, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 10);
        GridBagUtil.add(guiPanel2, this.d_editor, 0, ++n2, 2, 1, 0, 0, 12, 0, 1, 1.0, 1.0, 10);
        this.d_actionPnl = new guiPanel(new FlowLayout(1, 6, 0));
        this.d_actionPnl.add(this.d_saveReportToFileButton);
        this.d_actionPnl.add(this.d_copyReportToClipBoardButton);
        GridBagUtil.add(guiPanel2, this.d_actionPnl, 0, ++n2, 2, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 10);
        this.loadValues();
        this.d_table.autoSizeColumns(true);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.setPreferredSize(new Dimension(500, 300));
    }

    public guiTable getTable() {
        return this.d_table;
    }

    public void setMessage(String string) {
        this.d_messageLab.setText(string);
    }

    public guiPanel getActionPanel() {
        return this.d_actionPnl;
    }

    public List<T> getSelectedWarnings() {
        int[] nArray;
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int n : nArray = this.d_table.getSelectedRows()) {
            int n2 = this.d_table.convertRowIndexToModel(n);
            arrayList.add(this.d_warnings.get(n2));
        }
        return arrayList;
    }

    public void removeIf(Predicate<? super T> predicate) {
        if (this.d_warnings.removeIf(predicate)) {
            this.loadValues();
        }
    }

    private String getMessageForWarning(T t) {
        String string = "";
        int[] nArray = this.d_report.getInfoTypes();
        String[] stringArray = this.d_report.getInfoDescriptions();
        for (int i = 0; i < nArray.length; ++i) {
            Comparable comparable = t.getWarningInfo(nArray[i]);
            string = string + stringArray[i] + ":  " + comparable.toString() + "\n";
        }
        return string;
    }

    private void loadValues() {
        int[] nArray = this.d_report.getInfoTypes();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.d_table.getModel();
        defaultTableModel.setNumRows(this.d_warnings.size());
        for (int i = 0; i < this.d_warnings.size(); ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                defaultTableModel.setValueAt(this.getObjectAt(i, j), i, j);
            }
        }
    }

    public Comparable getObjectAt(int n, int n2) {
        IWarning iWarning = (IWarning)this.d_warnings.get(n);
        return iWarning.getWarningInfo(this.d_report.getInfoTypes()[n2]);
    }

    private void prepareForReport() {
        int n;
        int n2 = this.d_table.getSortColumn();
        int n3 = this.d_report.getInfoTypes()[n2];
        int n4 = this.d_table.getSortOrder();
        switch (n4) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                assert (false);
                n = 0;
            }
        }
        this.d_report.sortWarnings(n3, n);
    }

    private class CopyToClipboardAction
    extends AbstractAction {
        private CopyToClipboardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WarningDlg.this.prepareForReport();
            String string = WarningDlg.this.d_report.prepareReport();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(string), null);
        }
    }

    private class SaveToFileAction
    extends AbstractAction {
        private SaveToFileAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            guiFileChooser guiFileChooser2 = new guiFileChooser("txt", Intl.intl("Text Files"));
            guiFileChooser2.setAcceptAllFileFilterUsed(true);
            guiFileChooser2.setSelectedFile(new File("warning_log.txt"));
            int n = guiFileChooser2.showSaveDialog(WarningDlg.this);
            if (n == 0) {
                WarningDlg.this.prepareForReport();
                File file = guiFileChooser2.getSelectedFile();
                try {
                    WarningDlg.this.d_report.writeReport(file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    WarningDlg.this.showMessageBox(iOException.getMessage());
                }
            }
        }
    }

    private class CellEditor
    implements TableCellEditor {
        private CellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return false;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, "<html>" + object, bl, bl2, n, n2);
            if (component instanceof JComponent && object != null) {
                ((JComponent)component).setToolTipText(object.toString());
            }
            return component;
        }
    }

    private class MouseMessageListener
    extends MouseAdapter {
        private MouseMessageListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() >= 2) {
                int n = WarningDlg.this.d_table.rowAtPoint(mouseEvent.getPoint());
                int n2 = WarningDlg.this.d_table.columnAtPoint(mouseEvent.getPoint());
                if (n < 0 || n2 < 0 || n >= WarningDlg.this.d_report.getWarnings().size() || n2 >= WarningDlg.this.d_report.getInfoTypes().length) {
                    return;
                }
                IWarning iWarning = (IWarning)WarningDlg.this.d_warnings.get(n);
                String string = WarningDlg.this.getMessageForWarning(iWarning);
                JOptionPane.showMessageDialog(WarningDlg.this, string, Intl.intl("Warning"), 2);
            }
        }
    }

    public static enum Severity {
        ERROR,
        WARNING;

    }
}

