/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;

public class WaitCursorMgr {
    public static final int DEFAULT_DELAY = 250;
    private static final MouseListener MOUSE_TRAP = new MouseAdapter(){};
    private static final MouseMotionAdapter MOUSE_MOTION_TRAP = new MouseMotionAdapter(){};
    private static final KeyAdapter KEY_TRAP = new KeyAdapter(){};
    private static final ComponentListener FOCUS_TRAP = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            componentEvent.getComponent().requestFocusInWindow();
        }
    };
    private List<Component> d_components;
    private int d_waitCursorCount = 0;
    private Timer d_waitTimer = null;
    private boolean d_showing = false;

    public WaitCursorMgr(Component ... componentArray) {
        this(Arrays.asList(componentArray));
    }

    public WaitCursorMgr(List<? extends Component> list) {
        this.d_components = new ArrayList<Component>(list);
    }

    public void beginWaitCursor() {
        this.beginWaitCursor(0);
    }

    public void beginWaitCursor(boolean bl) {
        int n = bl ? 250 : 0;
        this.beginWaitCursor(n);
    }

    public void beginWaitCursor(final int n) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitCursorMgr.this.forceBeginWaitCursor(n);
                }
            });
        } else {
            this.forceBeginWaitCursor(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceBeginWaitCursor(int n) {
        WaitCursorMgr waitCursorMgr = this;
        synchronized (waitCursorMgr) {
            if (++this.d_waitCursorCount == 1) {
                this.beginEventTrap();
                if (n <= 0) {
                    this.showWaitCursor();
                } else {
                    this.d_waitTimer = new Timer();
                    this.d_waitTimer.schedule(new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            WaitCursorMgr waitCursorMgr = WaitCursorMgr.this;
                            synchronized (waitCursorMgr) {
                                if (WaitCursorMgr.this.d_waitCursorCount > 0) {
                                    WaitCursorMgr.this.showWaitCursor();
                                }
                            }
                        }
                    }, n);
                }
            }
        }
    }

    private void beginEventTrap() {
        for (Component component : this.d_components) {
            if (!(component instanceof RootPaneContainer)) continue;
            JRootPane jRootPane = ((RootPaneContainer)((Object)component)).getRootPane();
            Component component2 = jRootPane.getGlassPane();
            component2.addMouseListener(MOUSE_TRAP);
            component2.addMouseMotionListener(MOUSE_MOTION_TRAP);
            component2.addKeyListener(KEY_TRAP);
            component2.setFocusTraversalKeysEnabled(false);
            component2.setVisible(true);
        }
    }

    private void showWaitCursor() {
        if (this.d_showing) {
            return;
        }
        this.d_showing = true;
        Cursor cursor = Cursor.getPredefinedCursor(3);
        List<Component> list = this.d_components;
        for (Component component : list) {
            if (component instanceof RootPaneContainer) {
                JRootPane jRootPane = ((RootPaneContainer)((Object)component)).getRootPane();
                jRootPane.setCursor(cursor);
                jRootPane.getGlassPane().setCursor(cursor);
                continue;
            }
            component.setCursor(cursor);
        }
    }

    public void endWaitCursor() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitCursorMgr.this.forceEndWaitCursor();
                }
            });
        } else {
            this.forceEndWaitCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceEndWaitCursor() {
        WaitCursorMgr waitCursorMgr = this;
        synchronized (waitCursorMgr) {
            if (--this.d_waitCursorCount == 0) {
                if (this.d_waitTimer != null) {
                    this.d_waitTimer.cancel();
                    this.d_waitTimer = null;
                }
                this.hideWaitCursor();
                this.endEventTrap();
            }
        }
    }

    private void hideWaitCursor() {
        if (!this.d_showing) {
            return;
        }
        this.d_showing = false;
        Cursor cursor = Cursor.getPredefinedCursor(0);
        List<Component> list = this.d_components;
        for (Component component : list) {
            if (component instanceof RootPaneContainer) {
                JRootPane jRootPane = ((RootPaneContainer)((Object)component)).getRootPane();
                jRootPane.setCursor(cursor);
                Component component2 = jRootPane.getGlassPane();
                component2.setCursor(cursor);
                continue;
            }
            component.setCursor(cursor);
        }
    }

    private void endEventTrap() {
        for (Component component : this.d_components) {
            if (!(component instanceof RootPaneContainer)) continue;
            JRootPane jRootPane = ((RootPaneContainer)((Object)component)).getRootPane();
            Component component2 = jRootPane.getGlassPane();
            component2.removeMouseListener(MOUSE_TRAP);
            component2.removeMouseMotionListener(MOUSE_MOTION_TRAP);
            component2.removeKeyListener(KEY_TRAP);
            component2.setFocusTraversalKeysEnabled(true);
            component2.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputBlocked() {
        WaitCursorMgr waitCursorMgr = this;
        synchronized (waitCursorMgr) {
            return this.d_waitCursorCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWaitCursorShowing(Component component) {
        WaitCursorMgr waitCursorMgr = this;
        synchronized (waitCursorMgr) {
            return this.d_waitCursorCount > 0 && this.d_showing;
        }
    }
}

