/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.text.Format;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.format.DoubleFormat;
import thunderheadeng.gui.format.IValueFormat;
import thunderheadeng.gui.format.IntFormat;
import thunderheadeng.gui.format.LongFormat;
import thunderheadeng.gui.format.UnitDoubleFormat;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.units.ConstantUnitSrc;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.ValueRange;

public class ValueFields {
    public static <T> ValueField<T> fld(Class<T> clazz) throws IllegalArgumentException {
        return new ValueField<T>(ValueFields.getFormat(clazz), ValueFields.getInitVal(clazz));
    }

    public static <T> ValueField<T> fld(T t) throws NullPointerException, IllegalArgumentException {
        return new ValueField<T>(ValueFields.getFormat(t.getClass()), t);
    }

    public static <T> ValueField<T> fld(T t, Predicate<T> predicate, Class<T> clazz) throws IllegalArgumentException {
        return new ValueField<T>(new guiFormattedFld.Formatter<T>(ValueFields.getFormat(clazz), predicate), t);
    }

    public static <T> ValueField<T> fld(ValueRange<T> valueRange, Class<T> clazz) throws IllegalArgumentException {
        T t = valueRange.clampValue(ValueFields.getInitVal(clazz));
        return new ValueField<T>(new guiFormattedFld.Formatter<T>(ValueFields.getFormat(clazz), valueRange), t);
    }

    public static <T> ValueField<T> fld(T t, Predicate<T> predicate) throws NullPointerException, IllegalArgumentException {
        return new ValueField<T>(new guiFormattedFld.Formatter<T>(ValueFields.getFormat(t.getClass()), predicate), t);
    }

    public static <T> IValueFormat<T> getFormat(ValueField<T> valueField) {
        Format format = valueField.getFormat();
        if (format instanceof IValueFormat) {
            return (IValueFormat)((Object)format);
        }
        return null;
    }

    protected static <T> Format getFormat(Class<T> clazz) throws IllegalArgumentException {
        if (Double.class.isAssignableFrom(clazz)) {
            return new DoubleFormat();
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return new IntFormat();
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return new LongFormat();
        }
        throw new IllegalArgumentException();
    }

    protected static <T> T getInitVal(Class<T> clazz) throws IllegalArgumentException {
        if (clazz.equals(Long.class)) {
            return (T)new Long(0L);
        }
        if (clazz.equals(Double.class)) {
            return (T)new Double(0.0);
        }
        if (clazz.equals(Integer.class)) {
            return (T)new Integer(0);
        }
        throw new IllegalArgumentException();
    }

    public static ValueField<Double> doubleFld() {
        return ValueFields.doubleFld(0.0);
    }

    public static ValueField<Double> doubleFld(Double d) {
        return new ValueField<Double>(new DoubleFormat(), d);
    }

    public static ValueField<Double> doubleFld(DoubleVR doubleVR) {
        Double d = doubleVR.clampValue(0.0);
        return ValueFields.doubleFld(d, doubleVR);
    }

    public static ValueField<Double> doubleFld(Double d, Predicate<Double> predicate) {
        return new ValueField<Double>(new guiFormattedFld.Formatter<Double>((Format)new DoubleFormat(), predicate), d);
    }

    public static ValueField<Integer> intFld() {
        return ValueFields.intFld(0);
    }

    public static ValueField<Integer> intFld(Integer n) {
        return new ValueField<Integer>(new IntFormat(), n);
    }

    public static ValueField<Integer> intFld(IntVR intVR) {
        Integer n = intVR.clampValue(0);
        return ValueFields.intFld(n, intVR);
    }

    public static ValueField<Integer> intFld(Integer n, Predicate<Integer> predicate) {
        return new ValueField<Integer>(new guiFormattedFld.Formatter<Integer>((Format)new IntFormat(), predicate), n);
    }

    public static ValueField<UnitDouble> udFld(IUnitSrc iUnitSrc) {
        return ValueFields.udFld(new UnitDouble(0.0, iUnitSrc.getUnit()), iUnitSrc);
    }

    public static ValueField<UnitDouble> udFld(IUnitSrc iUnitSrc, UnitDoubleVR unitDoubleVR) {
        return ValueFields.udFld(unitDoubleVR.clampValue(new UnitDouble(0.0, iUnitSrc.getUnit())), unitDoubleVR, iUnitSrc);
    }

    public static ValueField<UnitDouble> udFld(double d, Unit unit) {
        return new ValueField<UnitDouble>(new UnitDoubleFormat(new ConstantUnitSrc(unit)), new UnitDouble(d, unit));
    }

    public static ValueField<UnitDouble> udFld(UnitDouble unitDouble) {
        return new ValueField<UnitDouble>(new UnitDoubleFormat(new ConstantUnitSrc(unitDouble.getUnit())), unitDouble);
    }

    public static ValueField<UnitDouble> udFld(UnitDouble unitDouble, IUnitSrc iUnitSrc) {
        return new ValueField<UnitDouble>(new UnitDoubleFormat(iUnitSrc), unitDouble);
    }

    public static ValueField<UnitDouble> udFld(Unit unit, DoubleVR doubleVR) {
        return ValueFields.udFld(doubleVR, unit);
    }

    public static ValueField<UnitDouble> udFld(DoubleVR doubleVR, Unit unit) {
        return ValueFields.udFld((double)doubleVR.clampValue(0.0), doubleVR, unit);
    }

    public static ValueField<UnitDouble> udFld(double d, DoubleVR doubleVR, Unit unit) {
        return new ValueField<UnitDouble>(new guiFormattedFld.Formatter<UnitDouble>((Format)new UnitDoubleFormat(new ConstantUnitSrc(unit)), UnitDoubleVR.from(doubleVR, unit)), new UnitDouble(d, unit));
    }

    public static ValueField<UnitDouble> udFld(double d, Unit unit, IUnitSrc iUnitSrc) {
        return new ValueField<UnitDouble>(new UnitDoubleFormat(iUnitSrc), new UnitDouble(d, unit));
    }

    public static ValueField<UnitDouble> udFld(double d, DoubleVR doubleVR, Unit unit, IUnitSrc iUnitSrc) {
        return new ValueField<UnitDouble>(new guiFormattedFld.Formatter<UnitDouble>((Format)new UnitDoubleFormat(iUnitSrc), UnitDoubleVR.from(doubleVR, unit)), new UnitDouble(d, unit));
    }

    public static ValueField<UnitDouble> udFld(DoubleVR doubleVR, Unit unit, IUnitSrc iUnitSrc) {
        return ValueFields.udFld(doubleVR.clampValue(0.0), doubleVR, unit, iUnitSrc);
    }

    public static ValueField<UnitDouble> udFld(UnitDouble unitDouble, Predicate<UnitDouble> predicate) {
        return new ValueField<UnitDouble>(new guiFormattedFld.Formatter<UnitDouble>((Format)new UnitDoubleFormat(new ConstantUnitSrc(unitDouble.getUnit())), predicate), unitDouble);
    }

    public static ValueField<UnitDouble> udFld(UnitDouble unitDouble, Predicate<UnitDouble> predicate, IUnitSrc iUnitSrc) {
        return new ValueField<UnitDouble>(new guiFormattedFld.Formatter<UnitDouble>((Format)new UnitDoubleFormat(iUnitSrc), predicate), unitDouble);
    }

    public static IUnitSrc getUnitSource(ValueField<UnitDouble> valueField) {
        if (valueField.getFormat() instanceof UnitDoubleFormat) {
            return ((UnitDoubleFormat)valueField.getFormat()).getUnitType();
        }
        return null;
    }

    public static void setUnitSource(ValueField<UnitDouble> valueField, IUnitSrc iUnitSrc) {
        IUnitSrc iUnitSrc2 = ValueFields.getUnitSource(valueField);
        if (iUnitSrc2 == null || iUnitSrc2.equals(iUnitSrc)) {
            return;
        }
        Unit unit = iUnitSrc2.getUnit();
        Unit unit2 = iUnitSrc.getUnit();
        UnitDouble unitDouble = (UnitDouble)valueField.getValue();
        boolean bl = UnitDouble.areCompatible(unit, unit2);
        if (unitDouble != null && !bl) {
            unitDouble = unitDouble.reinterpret(unit2);
        }
        valueField.setValue(null);
        UnitDoubleFormat unitDoubleFormat = (UnitDoubleFormat)valueField.getFormat();
        Map<String, UnitDouble> map = bl ? unitDoubleFormat.getAliases() : Collections.EMPTY_MAP;
        unitDoubleFormat = unitDoubleFormat.newFormat(iUnitSrc, map);
        if (valueField.getFormatter() instanceof guiFormattedFld.Formatter) {
            guiFormattedFld.Formatter formatter = (guiFormattedFld.Formatter)valueField.getFormatter();
            formatter = bl ? formatter.newFormatter(unitDoubleFormat, formatter.getFilter()) : formatter.newFormatter(unitDoubleFormat);
            valueField.setFormatter(formatter);
        }
        valueField.setValue(unitDouble);
    }
}

