/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HoverWindow;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ValueEditor
extends HoverWindow
implements Validateable {
    private final KeyAdapter d_activateKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                ValueEditor.this.nextChoice();
            }
        }

        @Override
        public void keyTyped(final KeyEvent keyEvent) {
            switch (keyEvent.getKeyChar()) {
                case '\t': 
                case ' ': {
                    return;
                }
            }
            final Choice choice = ValueEditor.this.getCurrentChoice();
            if (choice != null) {
                ValueEditor.this.beginEditing();
                choice.field.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                choice.field.setText("");
                                choice.field.dispatchEvent(keyEvent);
                            }
                        });
                        choice.field.removeFocusListener(this);
                    }
                });
            }
        }
    };
    private final KeyAdapter d_editorKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 9: {
                    keyEvent.consume();
                    ValueEditor.this.nextChoice();
                    break;
                }
                case 10: {
                    keyEvent.consume();
                    ValueEditor.this.endEditing(true);
                    break;
                }
                case 27: {
                    keyEvent.consume();
                    ValueEditor.this.endEditing(false);
                }
            }
        }
    };
    private final Map<String, List<Choice>> d_values;
    private String d_currKey = null;
    private int d_currChoice = Integer.MAX_VALUE;
    private boolean d_editing = false;
    private final Set<IListener> d_listeners;

    public ValueEditor(Component component) {
        this((Window)SwingUtilities.getAncestorOfClass(Window.class, component), component);
    }

    public ValueEditor(Window window, Component component) {
        super(window, component);
        this.d_values = new HashMap<String, List<Choice>>();
        this.d_listeners = new LinkedHashSet<IListener>();
    }

    public void addListener(IListener iListener) {
        this.d_listeners.remove(iListener);
        this.d_listeners.add(iListener);
    }

    public void removeListener(IListener iListener) {
        this.d_listeners.remove(iListener);
    }

    public void addChoice(String string, final Choice choice) {
        List<Choice> list = this.d_values.get(string);
        if (list == null) {
            list = new ArrayList<Choice>();
            this.d_values.put(string, list);
        }
        list.add(choice);
        choice.field.addKeyListener(this.d_editorKeyListener);
        choice.field.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!(ValueEditor.this.isVisible() && ValueEditor.this.isChoosing() && ValueEditor.this.isEditing())) {
                    return;
                }
                Choice choice2 = ValueEditor.this.getCurrentChoice();
                if (choice2 != choice) {
                    return;
                }
                if (!ValueEditor.this.validateData(false, false)) {
                    return;
                }
                for (IListener iListener : new ArrayList(ValueEditor.this.d_listeners)) {
                    iListener.valueEditorChanged(ValueEditor.this, false);
                }
            }
        });
        choice.field.setCommitOnValidEdit(true);
        choice.field.setFocusTraversalKeysEnabled(false);
    }

    @Override
    public void attach() {
        super.attach();
        this.getAttachedComponent().addKeyListener(this.d_activateKeyListener);
        this.set(this.d_currKey, this.d_currChoice, this.d_editing);
    }

    @Override
    public void detach() {
        this.getAttachedComponent().removeKeyListener(this.d_activateKeyListener);
        this.set(null, Integer.MAX_VALUE, false);
        super.detach();
    }

    public <T> void setValue(T t) {
        this.setValue(t, this.getCurrentChoice());
    }

    public <T> void setValue(T t, int n, boolean bl) {
        Choice choice = (Choice)this.getChoice((int)n).v2;
        if (choice != null) {
            if (bl) {
                this.setChoice(n);
            }
            this.setValue(t, choice);
        }
    }

    protected <T> void setValue(T t, Choice choice) {
        if (choice != null) {
            if (choice == this.getCurrentChoice()) {
                this.endEditing(false);
            }
            choice.field.setValue(t);
            choice.lbl.setText(choice.field.getText());
            if (choice == this.getCurrentChoice()) {
                this.pack();
            }
        }
    }

    public <T> T getValue() {
        if (this.isChoosing()) {
            guiFormattedFld guiFormattedFld2 = this.d_values.get((Object)this.d_currKey).get((int)this.d_currChoice).field;
            return guiFormattedFld2.getValue();
        }
        return null;
    }

    @Override
    protected void setCursorLocation(Point point) {
        super.setCursorLocation(point);
        if (this.isVisible() && !this.isChoosing()) {
            this.setVisible(false);
        }
    }

    public boolean isChoosing() {
        return this.d_currKey != null && this.d_values.containsKey(this.d_currKey) && this.d_currChoice < this.d_values.get(this.d_currKey).size();
    }

    public Choice getCurrentChoice() {
        if (!this.isChoosing()) {
            return null;
        }
        return this.d_values.get(this.d_currKey).get(this.d_currChoice);
    }

    public int getCurrentChoiceId() {
        Choice choice = this.getCurrentChoice();
        if (choice == null) {
            return -1;
        }
        return choice.id;
    }

    public void setValueType(String string) {
        if (theUtil.equal(string, this.d_currKey)) {
            return;
        }
        this.set(string, 0, this.d_editing);
    }

    public String getCurrentValueType() {
        return this.d_currKey;
    }

    public void clear() {
        this.set(null, Integer.MAX_VALUE, false);
    }

    public void nextChoice() {
        if (!this.d_values.containsKey(this.d_currKey)) {
            return;
        }
        List<Choice> list = this.d_values.get(this.d_currKey);
        int n = (this.d_currChoice + 1) % list.size();
        this.set(this.d_currKey, n, this.d_editing);
    }

    protected Pair<Integer, Choice> getChoice(int n) {
        List<Choice> list = this.d_values.get(this.d_currKey);
        if (list == null) {
            return new Pair<Integer, Object>(-1, null);
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).id != n) continue;
            return new Pair<Integer, Choice>(i, list.get(i));
        }
        return new Pair<Integer, Object>(-1, null);
    }

    public void setChoice(int n) {
        this.set(this.d_currKey, (Integer)this.getChoice((int)n).v1, this.d_editing);
    }

    protected void set(String string, int n, boolean bl) {
        if (theUtil.equal(this.d_currKey, string) && n == this.d_currChoice && this.isVisible() && bl == this.d_editing) {
            return;
        }
        this.d_currKey = string;
        this.d_currChoice = n;
        this.d_editing = bl;
        final Choice choice = this.getCurrentChoice();
        if (choice == null) {
            this.setVisible(false);
            this.getAttachedComponent().setFocusTraversalKeysEnabled(true);
            return;
        }
        this.getContentPane().removeAll();
        guiPanel guiPanel2 = new guiPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = new Dimension(super.getPreferredSize());
                dimension.height = Math.max(choice.field.getPreferredSize().height, choice.lbl.getPreferredSize().height);
                return dimension;
            }
        };
        guiPanel2.setOpaque(false);
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
        JComponent jComponent = this.d_editing ? choice.field : choice.lbl;
        String string2 = "<html><b>" + String.format(Intl.intl("%s:"), choice.desc) + "</b></html>";
        gridBagHelper.addRow(string2, jComponent);
        this.getContentPane().add((Component)guiPanel2, "Center");
        this.pack();
        this.setVisible(false);
        this.setFocusableWindowState(this.d_editing);
        this.setVisible(true);
        this.getAttachedComponent().setFocusTraversalKeysEnabled(this.d_values.get(this.d_currKey).size() < 2);
    }

    public void beginEditing() {
        this.set(this.d_currKey, this.d_currChoice, true);
    }

    public void endEditing(boolean bl) {
        if (!(this.isVisible() && this.isChoosing() && this.isEditing())) {
            return;
        }
        if (bl && !this.validateData(true, true)) {
            return;
        }
        this.set(this.d_currKey, this.d_currChoice, false);
        if (bl) {
            for (IListener iListener : new ArrayList<IListener>(this.d_listeners)) {
                iListener.valueEditorChanged(this, true);
            }
        }
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!(this.isVisible() && this.isChoosing() && this.isEditing())) {
            return true;
        }
        Choice choice = this.getCurrentChoice();
        return choice.field.validateData(bl, bl2);
    }

    public boolean isEditing() {
        return this.d_editing;
    }

    public String getStatusMessage() {
        if (this.isChoosing()) {
            Choice choice;
            List<Choice> list = this.d_values.get(this.d_currKey);
            Choice choice2 = list.get(this.d_currChoice);
            String string = choice2 != (choice = list.get((this.d_currChoice + 1) % list.size())) ? String.format(Intl.intl("Type to enter <i>%s</i> or press TAB for alternatives"), choice2.desc) : String.format(Intl.intl("Type to enter <i>%s</i>"), choice2.desc);
            string = "<html>&lt;" + string + "&gt;</html>";
            return string;
        }
        return "";
    }

    public static interface IListener {
        public void valueEditorChanged(ValueEditor var1, boolean var2);
    }

    public static class Choice {
        public final int id;
        public final String desc;
        public final guiFormattedFld field;
        public final guiLabel lbl;

        public Choice(String string, guiFormattedFld guiFormattedFld2) {
            this(0, string, guiFormattedFld2);
        }

        public Choice(int n, String string, guiFormattedFld guiFormattedFld2) {
            this.id = n;
            this.desc = string;
            this.field = guiFormattedFld2;
            this.lbl = new guiLabel();
        }
    }
}

