/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.util.function.Predicate;
import thunderheadeng.gui.ITeciComponent;
import thunderheadeng.util.Filters;

public class TeciComponentProxy {
    public final ITeciComponent d_component;
    private Predicate<ITeciComponent> d_filter;
    private boolean d_enabled;
    private boolean d_modified;

    public TeciComponentProxy(ITeciComponent iTeciComponent) {
        assert (iTeciComponent instanceof ITeciComponent);
        this.d_component = iTeciComponent;
        this.d_filter = Filters.acceptAll();
        this.d_enabled = true;
        this.d_modified = false;
    }

    public boolean isModified() {
        return this.d_modified;
    }

    public void setModified(boolean bl) {
        this.d_modified = bl;
    }

    public void setEnabled(boolean bl) {
        if (bl == this.d_enabled) {
            return;
        }
        this.d_enabled = bl;
        this.updateEnabled();
    }

    public boolean isEnabledSet() {
        return this.d_enabled;
    }

    public boolean isEnabled() {
        return this.d_enabled && this.d_filter.test(this.d_component);
    }

    public void setEnabledFilter(Predicate<ITeciComponent> predicate) {
        if (predicate == this.d_filter) {
            return;
        }
        this.d_filter = predicate;
        this.updateEnabled();
    }

    public Predicate<ITeciComponent> getEnabledFilter() {
        return this.d_filter;
    }

    public void updateEnabled() {
        this.d_component.updateEnabled();
    }
}

