/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value;
    private Thread thread;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object object) {
        this.value = object;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread thread;
        while ((thread = this.threadVar.get()) != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        this.init();
    }

    private void init() {
        RunConstructor runConstructor = new RunConstructor();
        Thread thread = new Thread(runConstructor);
        this.threadVar = new ThreadVar(thread);
    }

    public void start() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.start();
        } else {
            this.init();
            thread = this.threadVar.get();
            thread.start();
        }
    }

    private class RunConstructor
    implements Runnable {
        private RunConstructor() {
        }

        @Override
        public void run() {
            try {
                SwingWorker.this.setValue(SwingWorker.this.construct());
            }
            finally {
                SwingWorker.this.threadVar.clear();
            }
            SwingUtilities.invokeLater(new DoFinished());
        }
    }

    private class DoFinished
    implements Runnable {
        private DoFinished() {
        }

        @Override
        public void run() {
            SwingWorker.this.finished();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread thread) {
            this.thread = thread;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

