/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.IntVR;

public class SpinBox
extends guiPanel {
    private guiIntField d_intField;
    private JButton d_upButton;
    private JButton d_downButton;
    private UpAction d_upAction;
    private DownAction d_downAction;
    private ActionListener d_actionListener;

    private void init(int n, IntVR intVR) {
        this.d_upAction = new UpAction();
        this.d_downAction = new DownAction();
        this.d_intField = new guiIntField(n, intVR);
        this.d_upButton = new JButton(this.d_upAction);
        this.d_upButton.setFocusable(false);
        this.d_downButton = new JButton(this.d_downAction);
        this.d_downButton.setFocusable(false);
        this.d_intField.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "up");
        this.d_intField.getActionMap().put("up", this.d_upAction);
        this.d_intField.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "down");
        this.d_intField.getActionMap().put("down", this.d_downAction);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.d_intField, gridBagConstraints);
        this.d_upButton.setMargin(new Insets(0, 0, 0, 0));
        this.d_downButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.d_upButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.d_downButton, gridBagConstraints);
    }

    public SpinBox() {
        this.init(0, IntVR.unbounded());
    }

    public SpinBox(int n, int n2, int n3) {
        this.init(n, IntVR.between(n2, n3, true, true));
    }

    public SpinBox(int n, int n2, IntVR intVR) {
        this.init(n, intVR);
        this.d_intField.setColumns(n2);
    }

    public SpinBox(int n, int n2, int n3, int n4) {
        this(n, n4, IntVR.between(n2, n3, true, true));
    }

    public void setValue(int n) {
        int n2 = n;
        int n3 = this.getValue();
        if (n2 != n3) {
            this.d_intField.setValue(n2);
        }
    }

    public int getValue() {
        return (Integer)this.d_intField.getValue();
    }

    public void setAutoValidate(boolean bl) {
        this.d_intField.setAutoValidate(bl);
    }

    public void setValueRange(IntVR intVR) {
        this.d_intField.setValueRange(intVR);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (bl2) {
            int n = this.getValue();
            int n2 = this.d_intField.getValueRange().clampValue(n);
            if (n2 != n) {
                this.setValue(n2);
                this.setModified(true);
            }
        }
        return true;
    }

    public void addActionListener(ActionListener actionListener) {
        this.d_actionListener = AWTEventMulticaster.add(this.d_actionListener, actionListener);
        this.d_intField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "commit");
        this.d_intField.getActionMap().put("commit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpinBox.this.validateData(true, true);
                if (SpinBox.this.d_intField.isModified() && SpinBox.this.d_actionListener != null) {
                    SpinBox.this.d_actionListener.actionPerformed(new ActionEvent(SpinBox.this, 1001, null));
                    SpinBox.this.d_intField.setModified(false);
                }
            }
        });
    }

    public void removeActionListener(ActionListener actionListener) {
        this.d_actionListener = AWTEventMulticaster.remove(this.d_actionListener, actionListener);
        if (((ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.d_actionListener, ActionListener.class)).length == 0) {
            this.d_intField.getInputMap().remove(KeyStroke.getKeyStroke(10, 0));
            this.d_intField.getActionMap().remove("commit");
        }
    }

    private class DownAction
    extends AbstractAction {
        public DownAction() {
            super("", guiUtil.loadTeciIcon("SpinDown.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpinBox.this.validateData(true, true);
            int n = SpinBox.this.getValue();
            int n2 = n - 1;
            if (SpinBox.this.d_intField.getValueRange().checkValue(n2)) {
                SpinBox.this.setValue(n2);
                if (SpinBox.this.d_actionListener != null) {
                    SpinBox.this.d_actionListener.actionPerformed(new ActionEvent(SpinBox.this, 1001, null));
                }
            }
        }
    }

    private class UpAction
    extends AbstractAction {
        public UpAction() {
            super("", guiUtil.loadTeciIcon("SpinUp.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SpinBox.this.validateData(true, true);
            int n = SpinBox.this.getValue();
            int n2 = n + 1;
            if (SpinBox.this.d_intField.getValueRange().checkValue(n2)) {
                SpinBox.this.setValue(n2);
                if (SpinBox.this.d_actionListener != null) {
                    SpinBox.this.d_actionListener.actionPerformed(new ActionEvent(SpinBox.this, 1001, null));
                }
            }
        }
    }
}

