/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.util.function.IntToDoubleFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import thunderheadeng.gui.ASeries;
import thunderheadeng.gui.LWSeries;

public class Series
extends ASeries {
    private double[] d_x;
    private double[] d_y;

    public Series(double[] dArray, double[] dArray2, String string, Color color, int n, int n2, int n3) {
        super(string, color, n, n2, n3);
        this.d_x = new double[dArray.length];
        this.d_y = new double[dArray2.length];
        System.arraycopy(dArray, 0, this.d_x, 0, dArray.length);
        System.arraycopy(dArray2, 0, this.d_y, 0, dArray2.length);
        this.updateBounds();
    }

    public LWSeries toLWSeries() {
        return new LWSeries(Series.toIntRangeSupplier(this.d_x.length), Series.toIntFunctionSupplier(this.d_x), Series.toIntFunctionSupplier(this.d_y), this.getName(), this.getColor(), this.getMarkType(), this.getLineType(), this.getWeight());
    }

    private static Supplier<IntStream> toIntRangeSupplier(int n) {
        return () -> IntStream.range(0, n);
    }

    private static Supplier<IntToDoubleFunction> toIntFunctionSupplier(double[] dArray) {
        return () -> n -> dArray[n];
    }

    public void setData(double[] dArray, double[] dArray2) {
        this.d_x = dArray;
        this.d_y = dArray2;
        this.updateBounds();
    }

    @Override
    public IntStream getIndexes() {
        return IntStream.range(0, this.d_x.length);
    }

    @Override
    public IntToDoubleFunction getX() {
        return n -> this.d_x[n];
    }

    public double[] getXVals() {
        return this.d_x;
    }

    @Override
    public IntToDoubleFunction getY() {
        return n -> this.d_y[n];
    }

    public double[] getYVals() {
        return this.d_y;
    }

    private static class RangeProducer
    implements Supplier<IntStream> {
        private final int d_length;

        public RangeProducer(int n) {
            this.d_length = n;
        }

        @Override
        public IntStream get() {
            return IntStream.range(0, this.d_length);
        }
    }
}

