/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.lang.reflect.Constructor;
import javax.swing.JComponent;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.IPropEditor;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;

public class PropEditors {

    public static class UnitDoublePropEditor
    implements IPropEditor<UnitDouble> {
        private guiLabel d_lab;
        private guiUnitDoubleField d_udField;

        public UnitDoublePropEditor(String string, Unit unit, UnitDoubleVR unitDoubleVR) {
            this(string, new guiUnitDoubleField(unit, unitDoubleVR));
        }

        public UnitDoublePropEditor(String string, guiUnitDoubleField guiUnitDoubleField2) {
            this.d_lab = new guiLabel(string);
            this.d_udField = guiUnitDoubleField2;
        }

        @Override
        public int getComponentWidth(int n) {
            return 1;
        }

        @Override
        public JComponent getEditorComponent(int n) {
            if (n == 0) {
                return this.d_lab;
            }
            if (n == 1) {
                return this.d_udField;
            }
            return null;
        }

        @Override
        public int getNumComponents() {
            return 2;
        }

        @Override
        public UnitDouble getValue() {
            return (UnitDouble)this.d_udField.getValue();
        }

        @Override
        public void setValue(UnitDouble unitDouble) {
            this.d_udField.setValue(unitDouble);
        }
    }

    public static class StringPropEditor
    implements IPropEditor<String> {
        private guiLabel d_lab;
        private guiTextField d_textField;

        public StringPropEditor(String string) {
            this.d_lab = new guiLabel(string);
            this.d_textField = new guiTextField();
        }

        @Override
        public int getComponentWidth(int n) {
            return 1;
        }

        @Override
        public JComponent getEditorComponent(int n) {
            if (n == 0) {
                return this.d_lab;
            }
            if (n == 1) {
                return this.d_textField;
            }
            return null;
        }

        @Override
        public int getNumComponents() {
            return 2;
        }

        @Override
        public String getValue() {
            return this.d_textField.getValue();
        }

        @Override
        public void setValue(String string) {
            this.d_textField.setValue(string);
        }
    }

    public static class Point3dPropEditor
    implements IPropEditor<Point3d> {
        private guiLabel d_lab;
        private Unit d_naturalUnit;
        private guiUnitDoubleField d_xField;
        private guiUnitDoubleField d_yField;
        private guiUnitDoubleField d_zField;

        public Point3dPropEditor(String string, Unit unit) {
            this(string, unit, guiUnitDoubleField.class);
        }

        public Point3dPropEditor(String string, Unit unit, Class<? extends guiUnitDoubleField> clazz) {
            this.d_lab = new guiLabel(string);
            this.d_naturalUnit = unit;
            try {
                Constructor<? extends guiUnitDoubleField> constructor = clazz.getConstructor(Unit.class);
                this.d_xField = constructor.newInstance(unit);
                this.d_yField = constructor.newInstance(unit);
                this.d_zField = constructor.newInstance(unit);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.d_xField = new guiUnitDoubleField(unit);
                this.d_yField = new guiUnitDoubleField(unit);
                this.d_zField = new guiUnitDoubleField(unit);
            }
        }

        @Override
        public int getComponentWidth(int n) {
            return 1;
        }

        @Override
        public JComponent getEditorComponent(int n) {
            if (n == 0) {
                return this.d_lab;
            }
            if (n == 1) {
                return this.d_xField;
            }
            if (n == 2) {
                return this.d_yField;
            }
            if (n == 3) {
                return this.d_zField;
            }
            return null;
        }

        @Override
        public int getNumComponents() {
            return 4;
        }

        @Override
        public Point3d getValue() {
            double d = ((UnitDouble)this.d_xField.getValue()).getValue(this.d_naturalUnit);
            double d2 = ((UnitDouble)this.d_yField.getValue()).getValue(this.d_naturalUnit);
            double d3 = ((UnitDouble)this.d_zField.getValue()).getValue(this.d_naturalUnit);
            return new Point3d(d, d2, d3);
        }

        @Override
        public void setValue(Point3d point3d) {
            this.d_xField.setValue(new UnitDouble(point3d.x, this.d_naturalUnit));
            this.d_yField.setValue(new UnitDouble(point3d.y, this.d_naturalUnit));
            this.d_zField.setValue(new UnitDouble(point3d.z, this.d_naturalUnit));
        }
    }

    public static class BoolPropEditor
    implements IPropEditor<Boolean> {
        private guiCheckBox d_check;

        public BoolPropEditor(String string) {
            this.d_check = new guiCheckBox(string);
        }

        @Override
        public int getComponentWidth(int n) {
            return 10;
        }

        @Override
        public JComponent getEditorComponent(int n) {
            return this.d_check;
        }

        @Override
        public int getNumComponents() {
            return 1;
        }

        @Override
        public Boolean getValue() {
            return this.d_check.isSelected();
        }

        @Override
        public void setValue(Boolean bl) {
            this.d_check.setSelected(bl);
        }
    }
}

