/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import thunderheadeng.gui.Application;

public class OutputLog {
    public static File logFile = null;
    public static OutputStream logOut = null;
    public static final PrintStream origStdOut = System.out;
    public static final PrintStream origStdErr = System.err;
    private static long t = System.currentTimeMillis();

    public static String getDefaultLogDir(String string) {
        try {
            return Application.getAppDataDir(string) + "log" + File.separator;
        }
        catch (Throwable throwable) {
            return System.getProperty("user.home");
        }
    }

    public static File createLogFile(String string, String string2, String string3) throws IOException {
        String string4 = Long.toString(t);
        String string5 = String.format("%s%s%s", string2, string4, string3);
        return new File(string, string5);
    }

    public static void begin(String string) {
        assert (logFile == null);
        try {
            String string2 = String.format("%s_out", string.toLowerCase());
            logFile = OutputLog.createLogFile(OutputLog.getDefaultLogDir(string), string2, ".log");
            logFile.getParentFile().mkdirs();
            logOut = new FileOutputStream(logFile);
            FileEchoStream fileEchoStream = new FileEchoStream(origStdOut, logOut);
            System.setOut(new PrintStream(fileEchoStream));
            FileEchoStream fileEchoStream2 = new FileEchoStream(origStdErr, logOut);
            System.setErr(new PrintStream(fileEchoStream2));
            System.out.printf("Logging out/err to \"%s\"%n", logFile.getPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void end() {
        assert (logFile != null);
        System.setOut(origStdOut);
        System.setErr(origStdErr);
        try {
            logOut.close();
            logOut = null;
            logFile.delete();
            logFile = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class FileEchoStream
    extends FilterOutputStream {
        private OutputStream d_logOut;

        public FileEchoStream(OutputStream outputStream, OutputStream outputStream2) {
            super(outputStream);
            this.d_logOut = outputStream2;
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.d_logOut.flush();
        }

        @Override
        public void write(int n) throws IOException {
            super.write(n);
            this.d_logOut.write(n);
        }
    }
}

