/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import thunderheadeng.gui.guiUtil;

public class NoIcon
implements Icon {
    private final Color d_color;
    private final int d_width;
    private final int d_height;

    public NoIcon(Color color, int n, int n2) {
        this.d_color = color;
        this.d_width = n;
        this.d_height = n2;
    }

    @Override
    public int getIconHeight() {
        return this.d_height;
    }

    @Override
    public int getIconWidth() {
        return this.d_width;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color = NoIcon.choose(component, this.d_color);
        Graphics2D graphics2D = (Graphics2D)graphics;
        float f = Math.min(this.d_width, this.d_height) - 1;
        graphics2D.setColor(color);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f2 = f * 0.125f;
        float f3 = (f -= f2) * 0.5f;
        float f4 = (f3 - f2 * 0.5f) / (float)Math.sqrt(2.0);
        float f5 = (float)(this.d_width - 1) * 0.5f + (float)n;
        float f6 = (float)(this.d_height - 1) * 0.5f + (float)n2;
        graphics2D.setStroke(new BasicStroke(f2));
        graphics2D.drawOval(Math.round(f5 - f3), Math.round(f6 - f3), Math.round(f), Math.round(f));
        graphics2D.drawLine(Math.round(f5 - f4), Math.round(f6 + f4), Math.round(f5 + f4), Math.round(f6 - f4));
    }

    private static Color choose(Component component, Color color) {
        if (component.isEnabled()) {
            return color;
        }
        return new Color(guiUtil.DISABLED_FILTER.filterRGB(0, 0, color.getRGB()));
    }
}

