/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.io.File;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.Application;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class ModelBackup {
    public static final UnitDouble DEF_AUTOSAVE_PERIOD = new UnitDouble(10.0, NonSI.MINUTE);
    public static final String BACKUP_POSTFIX = "~";
    public static final String AUTOSAVE_PREFIX = "~";
    private final String d_appName;
    private final IHandler d_callback;
    private final String d_fileExtension;
    private boolean d_backupEnabled = true;
    private AutoSave d_autosave;
    private UnitDouble d_autosavePeriod = DEF_AUTOSAVE_PERIOD;
    private boolean d_modified = false;
    private String d_filename = "";

    public ModelBackup(String string, String string2, IHandler iHandler) {
        this.d_appName = string;
        this.d_callback = iHandler;
        this.d_fileExtension = string2;
    }

    public boolean isReservedPath(String string) {
        return AutoSave.isAutosavePath(string) || this.isBackupPath(string);
    }

    public boolean isAutosavePath(String string) {
        return AutoSave.isAutosavePath(string);
    }

    public boolean isBackupPath(String string) {
        String string2 = this.d_fileExtension.substring(0, this.d_fileExtension.length() - 1) + "~";
        return FilenameManager.getExtension(string).equals(string2);
    }

    public void setBackupEnabled(boolean bl) {
        this.d_backupEnabled = bl;
    }

    public boolean isBackupEnabled() {
        return this.d_backupEnabled;
    }

    public void setModified(boolean bl) {
        this.d_modified = bl;
        if (this.d_autosave != null) {
            this.d_autosave.setModified(bl);
        }
    }

    public void setAutosavePeriod(UnitDouble unitDouble) {
        if (unitDouble.equals(this.d_autosavePeriod)) {
            return;
        }
        this.d_autosavePeriod = unitDouble;
        if (this.d_autosave != null) {
            this.d_autosave.stop();
            this.d_autosave.setTimerPeriod(unitDouble);
            this.d_autosave.start();
        }
    }

    public void setFilename(String string) {
        if (theUtil.equal(string, this.d_filename)) {
            return;
        }
        this.d_filename = string;
        if (this.d_autosave != null) {
            this.d_autosave.stop();
            this.d_autosave.setFilename(string);
            this.d_autosave.start();
        }
    }

    public boolean isAutosaveEnabled() {
        return this.d_autosave != null;
    }

    public void setAutosaveEnabled(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.d_autosave != null;
        if (bl == bl2) {
            return;
        }
        if (bl) {
            UnitDouble unitDouble = this.d_autosavePeriod;
            this.d_autosave = new AutoSave(this.d_callback, unitDouble, this.d_filename, this.d_fileExtension);
            if (this.d_modified) {
                this.d_autosave.setModified(this.d_modified);
            }
        } else {
            assert (this.d_autosave != null);
            this.d_autosave.end(true);
            this.d_autosave = null;
        }
    }

    public String cancelAutosave() {
        String string = this.getAutosavePath();
        if (this.d_autosave != null) {
            this.d_autosave.end(false);
            this.d_autosave = null;
        }
        return string;
    }

    public String getAutosavePath() {
        if (this.d_autosave != null && this.d_autosave.isSaved()) {
            return this.d_autosave.getFilePath();
        }
        return null;
    }

    private File[] getBackupPaths(File file) {
        String string = file.getName();
        String string2 = string.substring(0, string.length() - 1) + "~";
        File file2 = new File(file.getParentFile(), string2);
        File file3 = new File(Application.getAppDataDir(this.d_appName) + "backup" + File.separator, string2);
        return new File[]{file2, file3};
    }

    public void createBackupFile(String string) {
        if (!this.d_backupEnabled || this.isReservedPath(string)) {
            return;
        }
        File file = new File(string);
        File[] fileArray = this.getBackupPaths(file);
        boolean bl = false;
        for (File file2 : fileArray) {
            try {
                System.out.printf("Saving backup file: %s%n", file2);
                file2.getParentFile().mkdirs();
                CopyFile.copyFileStream(file, file2);
                bl = true;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            System.err.println("Failed to create backup on open.");
        }
    }

    public File getBackupFile(String string) {
        if (this.isBackupPath(string)) {
            return null;
        }
        File[] fileArray = this.getBackupPaths(new File(string));
        if (fileArray[0].exists()) {
            return fileArray[0];
        }
        if (fileArray[1].exists()) {
            return fileArray[1];
        }
        return null;
    }

    public static interface IHandler {
        public void save(File var1) throws Exception;
    }

    private static class AutoSave {
        private static final Random RAND = new Random();
        private final Thread d_shutdownHook;
        private Timer d_timer;
        private TimerTask d_tt;
        private volatile boolean d_modified;
        private File d_saveFile;
        private UnitDouble d_timerPeriod;
        private boolean d_hasSaved;
        private UnitDouble d_lastSaveTime;
        private final IHandler d_callback;
        private final String d_fileExtension;
        private String d_baseFilename;

        public AutoSave(IHandler iHandler, UnitDouble unitDouble, String string, String string2) {
            this.d_fileExtension = string2;
            this.d_callback = iHandler;
            this.d_lastSaveTime = AutoSave.currTime();
            this.d_timerPeriod = unitDouble;
            this.d_hasSaved = false;
            this.d_modified = false;
            this.d_timer = null;
            this.d_tt = null;
            this.d_shutdownHook = new Thread(){

                @Override
                public void run() {
                    this.deleteSaveFile();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.d_shutdownHook);
            this.setFilename(string);
            this.start();
        }

        public static boolean isAutosavePath(String string) {
            File file = new File(string);
            String string2 = file.getName();
            return string2.startsWith("~");
        }

        public boolean isRunning() {
            return this.d_timer != null && this.d_tt != null;
        }

        private static UnitDouble currTime() {
            return new UnitDouble(System.nanoTime(), SI.NANO(SI.SECOND));
        }

        private static long toMillis(UnitDouble unitDouble) {
            return Math.round(unitDouble.getValue(SI.MILLI(SI.SECOND)));
        }

        public void setFilename(String string) {
            this.d_baseFilename = string;
            File file = this.getSaveDir(this.d_baseFilename);
            String string2 = this.getSaveFn(this.d_baseFilename);
            File file2 = null;
            if (file != null) {
                file2 = new File(file, string2);
            } else {
                File file3 = null;
                try {
                    file3 = File.createTempFile(string2, "." + this.d_fileExtension);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                file2 = file3;
            }
            if (theUtil.equal(file2, this.d_saveFile)) {
                return;
            }
            boolean bl = this.isRunning();
            if (bl) {
                this.stop();
            }
            this.deleteSaveFile();
            this.d_saveFile = file2;
            if (bl) {
                this.start();
            }
        }

        public void setTimerPeriod(UnitDouble unitDouble) {
            if (unitDouble.equals(this.d_timerPeriod)) {
                return;
            }
            boolean bl = this.isRunning();
            if (bl) {
                this.stop();
            }
            this.d_timerPeriod = unitDouble;
            if (bl) {
                this.start();
            }
        }

        public void setModified(boolean bl) {
            this.d_modified = bl;
        }

        private String getSaveFn(String string) {
            String string2 = string;
            if (string2 != null) {
                String string3 = string2;
                int n = string3.lastIndexOf(File.separatorChar);
                if (n != -1) {
                    return "~" + string3.substring(n + 1);
                }
                return "~" + string3;
            }
            return "~untitled" + RAND.nextInt(9999) + "." + this.d_fileExtension;
        }

        private File getSaveDir(String string) {
            File file;
            File file2;
            String string2 = string;
            File file3 = file2 = string2 != null ? new File(string2) : null;
            if (file2 != null && (file = file2.getParentFile()).exists()) {
                return file2.getParentFile();
            }
            return new File(System.getProperty("java.io.tmpdir"));
        }

        public void end(boolean bl) {
            Runtime.getRuntime().removeShutdownHook(this.d_shutdownHook);
            this.stop();
            if (bl) {
                this.deleteSaveFile();
            }
        }

        public boolean start() {
            assert (this.d_tt == null && this.d_timer == null);
            if (this.d_saveFile == null) {
                return false;
            }
            this.d_tt = new TimerTask(){

                @Override
                public void run() {
                    this.save();
                }
            };
            this.d_timer = new Timer("Autosave Timer");
            UnitDouble unitDouble = AutoSave.currTime().sub(this.d_lastSaveTime);
            UnitDouble unitDouble2 = this.d_timerPeriod.sub(unitDouble);
            if (unitDouble2.getValueNoUnit() <= 0.0) {
                unitDouble2 = new UnitDouble(0.0, SI.SECOND);
            }
            this.d_timer.schedule(this.d_tt, AutoSave.toMillis(unitDouble2), AutoSave.toMillis(this.d_timerPeriod));
            return true;
        }

        private void stop() {
            if (this.d_tt != null) {
                this.d_tt.cancel();
                this.d_tt = null;
            }
            if (this.d_timer != null) {
                this.d_timer.cancel();
                this.d_timer = null;
            }
        }

        public String getFilePath() {
            return this.d_saveFile != null ? this.d_saveFile.getAbsolutePath() : null;
        }

        public boolean isSaved() {
            return this.d_hasSaved;
        }

        private void deleteSaveFile() {
            if (this.d_saveFile == null) {
                return;
            }
            if (this.d_saveFile.exists()) {
                System.out.println("autosave: [normal close] deleting " + this.d_saveFile);
                this.d_saveFile.delete();
            }
            this.d_saveFile = null;
        }

        public void save() {
            if (!this.d_modified) {
                return;
            }
            assert (this.d_saveFile != null);
            boolean bl = false;
            try {
                this.d_callback.save(this.d_saveFile);
                bl = true;
                this.d_lastSaveTime = AutoSave.currTime();
                this.d_modified = false;
                System.out.println("autosave: " + this.d_saveFile);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (!bl) {
                System.out.println("autosave: [failed!] deleting corrupted save file");
                this.d_saveFile.delete();
            }
            this.d_hasSaved = bl;
        }
    }
}

