/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import thunderheadeng.gui.SelectableAction;
import thunderheadeng.gui.guiListBuilder;
import thunderheadeng.gui.guiUtil;

public class MenuBuilder {
    private final guiListBuilder<Object> d_listBuilder = new guiListBuilder();

    public void add(String string) {
        this.d_listBuilder.add(string);
    }

    public void add(Action action) {
        if (action != null && action.isEnabled()) {
            this.d_listBuilder.add(action);
        }
    }

    public void add(JMenuItem jMenuItem) {
        this.d_listBuilder.add(jMenuItem);
    }

    public void addMutuallyExclusive(SelectableAction ... selectableActionArray) {
        this.d_listBuilder.add(Arrays.asList(selectableActionArray));
    }

    public void addMutuallyExclusive(Collection<? extends SelectableAction> collection) {
        this.d_listBuilder.add(new ArrayList<SelectableAction>(collection));
    }

    public void addSeparator() {
        this.d_listBuilder.addSeparator();
    }

    public JMenu buildMenu(String string) {
        JMenu jMenu = new JMenu(string);
        List<Object> list = this.d_listBuilder.finalizeList();
        for (Object object : list) {
            if (object == null) {
                jMenu.addSeparator();
                continue;
            }
            if (object instanceof String) {
                jMenu.add((String)object);
                continue;
            }
            if (object instanceof SelectableAction) {
                guiUtil.addSelectableMenuItem(jMenu, (SelectableAction)object);
                continue;
            }
            if (object instanceof Action) {
                jMenu.add((Action)object);
                continue;
            }
            if (object instanceof JMenuItem) {
                jMenu.add((JMenuItem)object);
                continue;
            }
            if (!(object instanceof List)) continue;
            guiUtil.addMEMenuItems(jMenu, (Collection<? extends SelectableAction>)((List)object));
        }
        if (jMenu.getMenuComponentCount() == 0) {
            return null;
        }
        return jMenu;
    }

    public JPopupMenu buildPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        List<Object> list = this.d_listBuilder.finalizeList();
        for (Object object : list) {
            if (object == null) {
                jPopupMenu.addSeparator();
                continue;
            }
            if (object instanceof String) {
                jPopupMenu.add((String)object);
                continue;
            }
            if (object instanceof SelectableAction) {
                guiUtil.addSelectableMenuItem(jPopupMenu, (SelectableAction)object);
                continue;
            }
            if (object instanceof Action) {
                jPopupMenu.add((Action)object);
                continue;
            }
            if (object instanceof JMenuItem) {
                jPopupMenu.add((JMenuItem)object);
                continue;
            }
            if (!(object instanceof List)) continue;
            guiUtil.addMEMenuItems(jPopupMenu, (Collection<? extends SelectableAction>)((List)object));
        }
        if (jPopupMenu.getComponentCount() == 0) {
            return null;
        }
        return jPopupMenu;
    }
}

