/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Stack;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public abstract class Mediator {
    private transient Events d_events = new Events();
    private boolean d_printDebugStatements = System.getProperty("debug") != null;
    private static final Stack<ListenerResponse> s_eventResponses = new Stack();
    private static final DecimalFormat s_timeFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);

    protected void setEvents(Events events) {
        this.d_events = events;
    }

    public void setDebugPrintingEnabled(boolean bl) {
        this.d_printDebugStatements = bl;
    }

    public Events getEvents() {
        return this.d_events;
    }

    public boolean willFireOnResume() {
        return this.d_events.willFireOnResume();
    }

    public void pauseUpdates() {
        this.pauseUpdates(true);
    }

    public void pauseUpdates(boolean bl) {
        this.d_events.pause(bl);
    }

    public boolean isListening() {
        return this.d_events.isListening();
    }

    public boolean resumeUpdates() {
        return this.d_events.resume();
    }

    public static void debugResponseStarted(IEventObserver iEventObserver) {
        if (System.getProperty("debug") == null) {
            return;
        }
        ListenerResponse listenerResponse = new ListenerResponse(iEventObserver);
        s_eventResponses.push(listenerResponse);
        listenerResponse.startResponse();
    }

    public static void debugResponseEnded() {
        if (System.getProperty("debug") == null) {
            return;
        }
        assert (!s_eventResponses.isEmpty());
        ListenerResponse listenerResponse = s_eventResponses.pop();
        listenerResponse.endResponse();
    }

    public static void debugPrintEvents(String string) {
        if (System.getProperty("debug") == null) {
            return;
        }
        System.out.println("----" + string + " Responding to event...");
        System.out.flush();
    }

    public static void debugPrintElapsedTimeForEvents(String string, double d) {
        if (System.getProperty("debug") == null) {
            return;
        }
        String string2 = s_timeFormat.format(d);
        System.out.println("----" + string + " Response to event took " + string2 + " sec.");
        System.out.flush();
    }

    static {
        s_timeFormat.applyPattern("0.0000");
    }

    private static class ListenerResponse {
        protected long d_timeStarted;
        protected final IEventObserver d_listener;

        public ListenerResponse(IEventObserver iEventObserver) {
            this.d_listener = iEventObserver;
        }

        public void startResponse() {
            this.d_timeStarted = System.nanoTime();
            Mediator.debugPrintEvents(this.d_listener.getClass().getSimpleName());
        }

        public void endResponse() {
            long l = System.nanoTime();
            double d = (double)(l - this.d_timeStarted) * 1.0E-9;
            Mediator.debugPrintElapsedTimeForEvents(this.d_listener.getClass().getSimpleName(), d);
        }
    }
}

