/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import thunderheadeng.gui.MRUListener;
import thunderheadeng.gui.guiMenu;
import thunderheadeng.io.MRUFileList;

public class MRUMenu
extends guiMenu {
    private MRUFileList d_mru;
    private MRUListener d_listener;

    public MRUMenu(String string, MRUFileList mRUFileList, MRUListener mRUListener) {
        super(string);
        this.d_mru = mRUFileList;
        this.d_listener = mRUListener;
        this.update();
    }

    public void setNumMenuItems(int n) {
        this.d_mru.setMaxEntries(n);
    }

    public int getNumMenuItems() {
        return this.d_mru.getMaxEntries();
    }

    public void usedFile(String string) {
        this.d_mru.usedFile(string);
        this.update();
    }

    public void removeFile(String string) {
        this.d_mru.removeFile(string);
        this.update();
    }

    private void update() {
        this.removeAll();
        String[] stringArray = this.d_mru.getFileList();
        for (int i = 0; i < stringArray.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
            jMenuItem.addActionListener(new ItemListener(stringArray[i], i));
            this.add(jMenuItem);
        }
        this.setEnabled(stringArray.length > 0);
    }

    private class ItemListener
    implements ActionListener,
    Runnable {
        private String d_name;
        protected int d_index;

        public ItemListener(String string, int n) {
            this.d_name = string;
            this.d_index = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            if (MRUMenu.this.d_listener != null) {
                if (MRUMenu.this.d_listener.itemSelected(this.d_index, this.d_name)) {
                    MRUMenu.this.usedFile(this.d_name);
                } else {
                    MRUMenu.this.removeFile(this.d_name);
                }
            }
        }
    }
}

