/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.io.Closeable;
import java.util.function.IntToDoubleFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import thunderheadeng.gui.ASeries;
import thunderheadeng.gui.Series;

public class LWSeries
extends ASeries
implements Closeable {
    private Supplier<IntStream> d_indexesSrc;
    private Supplier<IntToDoubleFunction> d_xSrc;
    private Supplier<IntToDoubleFunction> d_ySrc;
    private IntToDoubleFunction d_x;
    private IntToDoubleFunction d_y;
    private int d_open;

    public LWSeries(Supplier<IntStream> supplier, Supplier<IntToDoubleFunction> supplier2, Supplier<IntToDoubleFunction> supplier3, String string, Color color, int n, int n2, int n3) {
        super(string, color, n, n2, n3);
        this.d_xSrc = supplier2;
        this.d_ySrc = supplier3;
        this.d_indexesSrc = supplier;
        this.d_open = 0;
    }

    public void setData(Supplier<IntStream> supplier, Supplier<IntToDoubleFunction> supplier2, Supplier<IntToDoubleFunction> supplier3) {
        boolean bl = this.isOpen();
        if (bl) {
            this.forceClose();
        }
        this.resetBounds();
        this.d_indexesSrc = supplier;
        this.d_xSrc = supplier2;
        this.d_ySrc = supplier3;
        if (bl) {
            this.forceOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Series toSeries() {
        boolean bl = this.isOpen();
        if (!bl) {
            this.open();
        }
        try {
            IntStream intStream = this.d_indexesSrc.get().limit(Integer.MAX_VALUE);
            int n2 = (int)intStream.count();
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            int[] nArray = new int[]{0};
            this.d_indexesSrc.get().limit(Integer.MAX_VALUE).sequential().forEachOrdered(n -> {
                int n2 = nArray[0];
                nArray[0] = n2 + 1;
                int n3 = n2;
                dArray[n3] = this.d_x.applyAsDouble(n);
                dArray2[n3] = this.d_y.applyAsDouble(n);
            });
            Series series = new Series(dArray, dArray2, this.getName(), this.getColor(), this.getMarkType(), this.getLineType(), this.getWeight());
            return series;
        }
        finally {
            if (!bl) {
                this.close();
            }
        }
    }

    public boolean isOpen() {
        return this.d_open > 0;
    }

    public void open() {
        if (++this.d_open == 1) {
            this.forceOpen();
        }
    }

    private void forceOpen() {
        this.d_x = this.d_xSrc.get();
        this.d_y = this.d_ySrc.get();
        this.updateBounds();
    }

    @Override
    public void close() {
        if (--this.d_open == 0) {
            this.forceClose();
        }
    }

    private void forceClose() {
        this.d_x = null;
        this.d_y = null;
    }

    public void makeBoundsValid() {
        if (!this.getBoundsValid() && !this.isOpen()) {
            this.open();
            this.close();
        }
    }

    @Override
    @OpenOnce
    public double getMinX() {
        return super.getMinX();
    }

    @Override
    @OpenOnce
    public double getMaxX() {
        return super.getMaxX();
    }

    @Override
    @OpenOnce
    public double getMinY() {
        return super.getMinY();
    }

    @Override
    @OpenOnce
    public double getMaxY() {
        return super.getMaxY();
    }

    public Supplier<IntStream> getIndexesSrc() {
        return this.d_indexesSrc;
    }

    public Supplier<IntToDoubleFunction> getXSrc() {
        return this.d_xSrc;
    }

    public Supplier<IntToDoubleFunction> getYSrc() {
        return this.d_ySrc;
    }

    @Override
    public IntStream getIndexes() {
        return this.d_indexesSrc.get();
    }

    @Override
    @Open
    public IntToDoubleFunction getX() {
        assert (this.isOpen());
        return this.d_x;
    }

    @Override
    @Open
    public IntToDoubleFunction getY() {
        assert (this.isOpen());
        return this.d_y;
    }

    public static @interface OpenOnce {
    }

    public static @interface Open {
    }
}

