/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.RGBImageFilter;

public class ImageFilterToBufferedImageOp
implements BufferedImageOp {
    private final RGBImageFilter d_filter;

    public ImageFilterToBufferedImageOp(RGBImageFilter rGBImageFilter) {
        this.d_filter = rGBImageFilter;
    }

    public RGBImageFilter getFilter() {
        return this.d_filter;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        assert (bufferedImage.getWidth() == bufferedImage2.getWidth());
        assert (bufferedImage.getHeight() == bufferedImage2.getHeight());
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = bufferedImage.getRGB(j, i);
                n3 = this.d_filter.filterRGB(j, i, n3);
                bufferedImage2.setRGB(j, i, n3);
            }
        }
        return bufferedImage2;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel == null) {
            colorModel = bufferedImage.getColorModel();
        }
        return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
    }

    @Override
    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        return (Point2D)point2D.clone();
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }
}

