/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;

public class HoverWindow
extends JWindow {
    private final Component d_parent;
    private final MouseAdapter d_mouseListener;
    private Point d_mousePos;

    public HoverWindow(Component component) {
        this((Window)SwingUtilities.getAncestorOfClass(Window.class, component), component);
    }

    public HoverWindow(Window window, Component component) {
        super(window);
        this.d_parent = component;
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.getRootPane().setBorder(compoundBorder);
        Color color = (Color)UIManager.get("ToolTip.background");
        this.getContentPane().setBackground(color);
        this.d_mouseListener = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                HoverWindow.this.setCursorLocation(mouseEvent.getLocationOnScreen());
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                HoverWindow.this.setCursorLocation(mouseEvent.getLocationOnScreen());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                HoverWindow.this.setCursorLocation(new Point(-1, -1));
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                HoverWindow.this.setCursorLocation(mouseEvent.getLocationOnScreen());
            }
        };
        this.d_mousePos = new Point(-1, -1);
    }

    public Component getAttachedComponent() {
        return this.d_parent;
    }

    public void attach() {
        this.d_parent.addMouseMotionListener(this.d_mouseListener);
        this.d_parent.addMouseListener(this.d_mouseListener);
    }

    public void detach() {
        this.d_parent.removeMouseListener(this.d_mouseListener);
        this.d_parent.removeMouseMotionListener(this.d_mouseListener);
        this.setCursorLocation(new Point(-1, -1));
    }

    @Override
    public void setVisible(boolean bl) {
        Window window;
        if (bl && (window = SwingUtilities.getWindowAncestor(this.d_parent)) != null && !window.isFocused()) {
            return;
        }
        super.setVisible(bl);
    }

    protected void setCursorLocation(Point point) {
        this.d_mousePos = point;
        this.updateLocation();
        this.setVisible(point.x >= 0 && point.y >= 0);
    }

    protected void updateLocation() {
        Point point = this.d_mousePos;
        int n = 5;
        this.setLocation(point.x + n, point.y - n - this.getHeight());
    }

    @Override
    public void pack() {
        super.pack();
        this.updateLocation();
    }
}

