/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class HTMLLabel
extends JEditorPane {
    private int d_width;
    private String d_text;
    private String d_formatted;
    private boolean d_openLinksAsWebpages;
    private static final OpenLinksListener OPEN_LINKS_LISTENER = new OpenLinksListener();

    public HTMLLabel(String string) {
        this(string, 0);
    }

    public HTMLLabel(String string, int n) {
        super("text/html", HTMLLabel.format(string, n));
        this.d_text = string;
        this.d_formatted = HTMLLabel.format(string, n);
        this.d_width = n;
        this.setOpenLinksAsWebpages(true);
        this.setHighlighter(null);
        this.setEditable(false);
        Font font = UIManager.getFont("Label.font");
        String string2 = String.format("body { font-family: %s; font-size: %dpt; }", font.getFamily(), font.getSize());
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(string2);
        this.setOpaque(false);
    }

    public void setWrapEnabled(boolean bl) {
        String string = bl ? "initial" : "nowrap";
        String string2 = String.format("body { white-space: %s }", string);
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(string2);
    }

    public int getPreferredWidth() {
        return this.d_width;
    }

    public void setPreferredWidth(int n) {
        if (n == this.d_width) {
            return;
        }
        this.d_width = n;
        if (this.d_width > 0) {
            this.setMinimumSize(new Dimension(this.d_width, this.getMinimumSize().height));
            this.setPreferredSize(new Dimension(this.d_width, this.getPreferredSize().height));
        }
        this.setText(this.d_text);
        this.invalidate();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        return dimension;
    }

    @Override
    public void setText(String string) {
        String string2 = HTMLLabel.format(string, this.d_width);
        if (!string2.equals(this.d_formatted)) {
            this.d_text = string;
            this.d_formatted = string2;
            super.setText(string2);
        }
    }

    @Override
    public String getText() {
        return this.d_text;
    }

    public String getFormattedText() {
        return super.getText();
    }

    private static String format(String string, int n) {
        if (n <= 0) {
            return "<html>" + string + "</html>";
        }
        return String.format("<html><body width='%d'>%s</html>", n, string);
    }

    public void setOpenLinksAsWebpages(boolean bl) {
        if (bl != this.d_openLinksAsWebpages) {
            this.d_openLinksAsWebpages = bl;
            if (bl) {
                this.addHyperlinkListener(OPEN_LINKS_LISTENER);
            } else {
                this.removeHyperlinkListener(OPEN_LINKS_LISTENER);
            }
        }
    }

    private static class OpenLinksListener
    implements HyperlinkListener {
        private OpenLinksListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String string = hyperlinkEvent.getDescription();
                try {
                    Desktop.getDesktop().browse(new URL(string).toURI());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

