/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import thunderheadeng.gui.HTMLLabel;

public class HTMLBtn
extends HTMLLabel {
    private List<ActionListener> d_listeners = null;

    public HTMLBtn(String string) {
        super(HTMLBtn.escape(string));
        this.setOpenLinksAsWebpages(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (!HTMLBtn.this.isEnabled() || hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED || HTMLBtn.this.d_listeners == null) {
                    return;
                }
                ActionEvent actionEvent = new ActionEvent(hyperlinkEvent.getSource(), 1001, hyperlinkEvent.getDescription(), System.currentTimeMillis(), 0);
                for (ActionListener actionListener : HTMLBtn.this.getListeners()) {
                    actionListener.actionPerformed(actionEvent);
                }
            }
        });
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.d_listeners == null) {
            this.d_listeners = new ArrayList<ActionListener>(1);
        }
        if (!this.d_listeners.contains(actionListener)) {
            this.d_listeners.add(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.d_listeners == null) {
            return;
        }
        this.d_listeners.remove(actionListener);
        if (this.d_listeners.isEmpty()) {
            this.d_listeners = null;
        }
    }

    public ActionListener[] getListeners() {
        return this.d_listeners.toArray(new ActionListener[this.d_listeners.size()]);
    }

    @Override
    public void setText(String string) {
        super.setText(HTMLBtn.escape(string));
    }

    @Override
    public String getText() {
        return super.getText();
    }

    private static String escape(String string) {
        return "<a href='dmy'>" + string + "</a>";
    }
}

