/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import thunderheadeng.gui.ComponentGroup2;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.Pair;

public class GridBagHelper {
    public static int REMAINING = 0;
    public static final int DEF_COL_SPACE = 6;
    public static final int DEF_ROW_SPACE = 6;
    public static final int DEF_INDENT = 18;
    public static final Anchor DEF_ANCHOR = Anchor.LEFT;
    public static final double DEF_FILL = 0.0;
    private final Container d_panel;
    public int d_colSpace;
    public int d_rowSpace;
    public int d_indent;
    public Anchor d_anchor;
    public double d_hfill;
    public double d_vfill;
    public Fill d_fill;
    private boolean d_firstRowAdded = true;
    private int d_currRow;
    private int d_currCol;
    private int d_indentLevel;
    private final Deque<int[]> d_spacingStack;
    private final Deque<Pair<Object, List<Component>>> d_groupStack = new ArrayDeque<Pair<Object, List<Component>>>();

    public GridBagHelper(Container container, boolean bl, int n, int n2) {
        this.d_panel = container;
        if (!(container.getLayout() instanceof GridBagLayout)) {
            container.setLayout(new GridBagLayout());
        }
        this.d_colSpace = n;
        this.d_rowSpace = n2;
        this.d_indent = 18;
        this.d_anchor = DEF_ANCHOR;
        this.d_vfill = 0.0;
        this.d_hfill = 0.0;
        this.d_fill = null;
        this.d_currCol = 0;
        this.d_currRow = 0;
        this.d_indentLevel = 0;
        this.d_spacingStack = new ArrayDeque<int[]>();
        if (bl) {
            this.addBorder();
        }
    }

    public GridBagHelper(Container container) {
        this(container, false, 6, 6);
    }

    public GridBagHelper(Container container, boolean bl) {
        this(container, bl, 6, 6);
    }

    public void beginGroup(Object object) {
        this.d_groupStack.addFirst(new Pair(object, new ArrayList()));
    }

    public ComponentGroup2<Component> endGroup() {
        Pair<Object, List<Component>> pair = this.d_groupStack.removeFirst();
        if (this.d_panel instanceof guiPanel && pair.v1 != null) {
            return ((guiPanel)this.d_panel).group(pair.v1, (Collection)pair.v2);
        }
        return guiUtil.group((Collection)pair.v2);
    }

    public void setCurrentRow(int n) {
        this.d_currRow = n;
    }

    public int getCurrentRow() {
        return this.d_currRow;
    }

    public int getCurrentCol() {
        return this.d_currCol;
    }

    public Container getPanel() {
        return this.d_panel;
    }

    public void pushSpacing(int n, int n2) {
        this.d_spacingStack.push(new int[]{this.d_colSpace, this.d_rowSpace});
        if (n >= 0) {
            this.d_colSpace = n;
        }
        if (n2 >= 0) {
            this.d_rowSpace = n2;
        }
    }

    public void popSpacing() {
        int[] nArray = this.d_spacingStack.pop();
        this.d_colSpace = nArray[0];
        this.d_rowSpace = nArray[0];
    }

    public void indent(boolean bl) {
        if (bl) {
            this.indent();
        } else {
            this.unindent();
        }
    }

    public void indent() {
        ++this.d_indentLevel;
    }

    public void unindent() {
        --this.d_indentLevel;
    }

    public TitleSeparator addTitle(String string) {
        TitleSeparator titleSeparator = new TitleSeparator(string);
        this.addFilledRow(titleSeparator);
        return titleSeparator;
    }

    public void addSeparator() {
        this.addFilledRow(new JSeparator());
    }

    public void addFilledRow(Object object) {
        this.addRow(object, 1.0, REMAINING);
    }

    public void addIdentRow(Object ... objectArray) {
        this.indent(true);
        this.addRow(objectArray);
        this.indent(false);
    }

    public void addRowSpace(int n) {
        this.addRow(Box.createVerticalStrut(n));
    }

    public void addRow(Object ... objectArray) {
        this.add(objectArray);
        this.nextRow();
    }

    public void add(Object ... objectArray) {
        int n;
        for (n = 0; n < objectArray.length; ++n) {
            if (!(objectArray[n] instanceof String)) continue;
            objectArray[n] = new guiLabel((String)objectArray[n]);
        }
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null && !(objectArray[n] instanceof Component)) {
                ++n;
                continue;
            }
            Component component = (Component)objectArray[n];
            n = this.addCol(component, objectArray, n + 1);
        }
    }

    public void nextRow() {
        ++this.d_currRow;
        this.d_firstRowAdded = false;
        this.d_currCol = 0;
    }

    public void addCol(Component component, Object ... objectArray) {
        this.addCol(component, objectArray, 0);
    }

    public void addCol(String string, Object ... objectArray) {
        this.addCol((Component)new guiLabel(string), objectArray);
    }

    public int addCol(Component component, Object[] objectArray, int n) {
        int n2;
        Object object;
        int n3;
        int n4 = this.d_indentLevel * this.d_indent;
        int n5 = this.d_firstRowAdded ? 0 : this.d_rowSpace;
        Fill fill = this.d_fill;
        double d = this.d_hfill;
        double d2 = this.d_vfill;
        int n6 = 1;
        int n7 = 1;
        Anchor anchor = this.d_anchor;
        for (n3 = n; n3 < objectArray.length && !((object = objectArray[n3]) instanceof Component) && object != null; ++n3) {
            if (object instanceof Anchor) {
                anchor = (Anchor)((Object)object);
                continue;
            }
            if (object instanceof Double) {
                d = (Double)object;
                continue;
            }
            if (object instanceof double[]) {
                d = ((double[])object)[0];
                d2 = ((double[])object)[1];
                continue;
            }
            if (object instanceof Integer) {
                n6 = (Integer)object;
                continue;
            }
            if (object instanceof int[]) {
                n6 = ((int[])object)[0];
                n7 = ((int[])object)[1];
                continue;
            }
            if (!(object instanceof Fill)) continue;
            fill = (Fill)((Object)object);
        }
        int n8 = n2 = this.d_currCol == 0 ? n4 : this.d_colSpace;
        if (component == null) {
            this.d_currCol += n6;
            return n3;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (fill == null) {
            fill = d == 0.0 && d2 == 0.0 ? Fill.NONE : (d == 0.0 ? Fill.VERTICAL : (d2 == 0.0 ? Fill.HORIZONTAL : Fill.BOTH));
        }
        switch (fill) {
            case NONE: {
                gridBagConstraints.fill = 0;
                break;
            }
            case BOTH: {
                gridBagConstraints.fill = 1;
                break;
            }
            case VERTICAL: {
                gridBagConstraints.fill = 3;
                break;
            }
            default: {
                gridBagConstraints.fill = 2;
            }
        }
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        switch (anchor) {
            case TOP_LEFT: {
                gridBagConstraints.anchor = 18;
                break;
            }
            case TOP: {
                gridBagConstraints.anchor = 11;
                break;
            }
            case TOP_RIGHT: {
                gridBagConstraints.anchor = 12;
                break;
            }
            case LEFT: {
                gridBagConstraints.anchor = 17;
                break;
            }
            case CENTER: {
                gridBagConstraints.anchor = 10;
                break;
            }
            case RIGHT: {
                gridBagConstraints.anchor = 13;
                break;
            }
            case BOTTOM_LEFT: {
                gridBagConstraints.anchor = 16;
                break;
            }
            case BOTTOM: {
                gridBagConstraints.anchor = 15;
                break;
            }
            case BOTTOM_RIGHT: {
                gridBagConstraints.anchor = 14;
            }
        }
        gridBagConstraints.gridx = this.d_currCol;
        gridBagConstraints.gridy = this.d_currRow;
        gridBagConstraints.gridwidth = n6;
        gridBagConstraints.gridheight = n7;
        gridBagConstraints.insets = new Insets(n5, n2, 0, 0);
        this.d_panel.add(component, gridBagConstraints);
        if (!this.d_groupStack.isEmpty()) {
            ((List)this.d_groupStack.peekFirst().v2).add(component);
        }
        this.d_currCol += n6;
        return n3;
    }

    public void finalizeRows() {
        GridBagUtil.addGlue(this.d_panel);
    }

    public void addBorder() {
        this.addBorder(12, 12, 12, 12);
    }

    public void addBorder(int n, int n2, int n3, int n4) {
        if (this.d_panel instanceof JComponent) {
            ((JComponent)this.d_panel).setBorder(BorderFactory.createEmptyBorder(n, n2, n3, n4));
        }
    }

    public static enum Fill {
        NONE,
        HORIZONTAL,
        VERTICAL,
        BOTH;

    }

    public static enum Anchor {
        TOP_LEFT,
        TOP,
        TOP_RIGHT,
        LEFT,
        CENTER,
        RIGHT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT;

    }
}

