/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.ICrashHandler;
import thunderheadeng.gui.OutputLog;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.BoundedStack;
import thunderheadeng.util.Win32Native;

public class CrashCatcher
implements Thread.UncaughtExceptionHandler {
    public static final int MAX_ACTIONLOG_SIZE = 20;
    public static final int OPT_AWT = 1;
    public static final int OPT_ALL_THREADS = 2;
    private static String s_appName;
    private static String s_version;
    private static ICrashHandler s_handler;
    private static String s_supportAddr;
    private static BoundedStack<ActionLogEntry> s_actionLog;
    private CrashCatcherDlg d_mainDlg;

    public static void install(String string, String string2, ICrashHandler iCrashHandler) {
        CrashCatcher.install(string, string2, iCrashHandler, 1, new Thread[0]);
    }

    public static void install(String string, String string2, ICrashHandler iCrashHandler, int n, Thread ... threadArray) {
        CrashCatcher crashCatcher;
        s_appName = string;
        s_version = string2;
        s_handler = iCrashHandler;
        s_supportAddr = "support@thunderheadeng.com";
        if (CrashCatcher.test(n, 1) && !CrashCatcher.test(n, 2)) {
            SwingUtilities.invokeLater(() -> {
                CrashCatcher crashCatcher = new CrashCatcher();
                Thread.currentThread().setUncaughtExceptionHandler(crashCatcher);
            });
        } else if (CrashCatcher.test(n, 2)) {
            crashCatcher = new CrashCatcher();
            Thread.setDefaultUncaughtExceptionHandler(crashCatcher);
        }
        if (threadArray.length > 0) {
            crashCatcher = new CrashCatcher();
            for (Thread thread : threadArray) {
                thread.setUncaughtExceptionHandler(crashCatcher);
            }
        }
    }

    private static boolean test(int n, int n2) {
        return (n & n2) == n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logAction(String string) {
        BoundedStack<ActionLogEntry> boundedStack = s_actionLog;
        synchronized (boundedStack) {
            s_actionLog.push(new ActionLogEntry(string));
        }
    }

    @Override
    public synchronized void uncaughtException(Thread thread, Throwable throwable) {
        if (CrashCatcher.canSafelyIgnoreException(throwable)) {
            return;
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(() -> this.uncaughtException(thread, throwable));
            return;
        }
        String string = String.format(Intl.intl("%s has encountered an unknown error and must shut down."), s_appName);
        Application application = Application.getApp();
        JFrame jFrame = null;
        try {
            if (application != null) {
                jFrame = application.getMainFrame();
            }
        }
        catch (Throwable throwable2) {
            throwable.printStackTrace();
        }
        this.report(jFrame, string, thread, throwable);
        System.exit(0);
    }

    public static boolean canSafelyIgnoreException(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray.length > 3 && stackTraceElementArray[0].getClassName().equals("javax.swing.JComponent") && stackTraceElementArray[0].getMethodName().equals("repaint") && stackTraceElementArray[1].getClassName().equals("sun.swing.FilePane$2") && stackTraceElementArray[1].getMethodName().equals("repaintListSelection") && stackTraceElementArray[2].getClassName().equals("sun.swing.FilePane$2") && stackTraceElementArray[2].getMethodName().equals("repaintSelection") && stackTraceElementArray[3].getClassName().equals("sun.swing.FilePane$2") && (stackTraceElementArray[3].getMethodName().equals("focusLost") || stackTraceElementArray[3].getMethodName().equals("focusGained"))) {
            System.out.println("Non fatal NPE: http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6561072");
            System.out.println("trace[3]: " + stackTraceElementArray[3].getClassName() + stackTraceElementArray[3].getMethodName());
            return true;
        }
        int n = 0;
        if (throwable instanceof IllegalComponentStateException && throwable.getMessage().equals("component must be showing on the screen to determine its location") && (n = CrashCatcher.indexOf(stackTraceElementArray, n, "java.awt.Component.getLocationOnScreen_NoTreeLock")) != -1 && (n = CrashCatcher.indexOf(stackTraceElementArray, n, "java.awt.Component.getLocationOnScreen")) != -1 && (n = CrashCatcher.indexOf(stackTraceElementArray, n, "javax.swing.text.JTextComponent$InputMethodRequestsHandler.getTextLocation")) != -1 && (n = CrashCatcher.indexOf(stackTraceElementArray, n, "sun.awt.im.InputMethodContext.getTextLocation")) != -1 && (n = CrashCatcher.indexOf(stackTraceElementArray, n, "sun.awt.windows.WInputMethod$1.run")) != -1 && (n = CrashCatcher.indexOf(stackTraceElementArray, n, "java.awt.event.InvocationEvent.dispatch")) != -1 && (n = CrashCatcher.indexOf(stackTraceElementArray, n, "java.awt.EventDispatchThread.run")) != -1 && n == stackTraceElementArray.length - 1) {
            System.err.println("Non fatal Exception -- occurs when tab switch follows text component deactivate/reactivate");
            System.err.println(throwable.getClass() + ": " + throwable.getMessage());
            return true;
        }
        return false;
    }

    public static int indexOf(StackTraceElement[] stackTraceElementArray, int n, String string) {
        try {
            for (int i = n; i < stackTraceElementArray.length; ++i) {
                if (!stackTraceElementArray[i].toString().startsWith(string)) continue;
                return i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return -1;
    }

    public synchronized void report(Window window, String string, Thread thread, Throwable throwable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = this.writeLog(throwable);
        if (file != null) {
            arrayList.add(Intl.intl("Log File") + ": " + file.getAbsolutePath());
        }
        Application application = Application.getApp();
        s_handler.cleanup(application, arrayList);
        this.printStack(throwable, System.err);
        try {
            Win32Native.ProxyConfig proxyConfig = Win32Native.getProxyConfig();
            Win32Native.setJVMDefaultProxyProps(proxyConfig);
        }
        catch (Throwable throwable2) {
            throwable.printStackTrace();
        }
        if (System.getProperty("autoreport") != null) {
            try {
                CrashCatcher.sendReport(this.buildReport(throwable), "", "Generated with -Dautoreport");
            }
            catch (Throwable throwable3) {
                System.out.println("Problem sending error report.");
            }
        } else {
            this.d_mainDlg = new CrashCatcherDlg(window, string, arrayList, this.buildReport(throwable));
            this.d_mainDlg.doModal();
        }
    }

    private void printStack(Throwable throwable, PrintStream printStream) {
        if (throwable != null) {
            throwable.printStackTrace(printStream);
            this.printStack(throwable.getCause(), printStream);
        }
    }

    private void printStack(Throwable throwable, PrintWriter printWriter) {
        if (throwable != null) {
            throwable.printStackTrace(printWriter);
            this.printStack(throwable.getCause(), printWriter);
        }
    }

    private void writeHeader(PrintWriter printWriter) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, Locale.US);
        String string = dateFormat.format(new Date());
        String string2 = System.getProperty("os.name");
        String string3 = System.getProperty("os.arch");
        String string4 = System.getProperty("java.version");
        printWriter.printf("%s Version: %s%n", s_appName, s_version);
        printWriter.printf("Date: %s%n", string);
        printWriter.printf("Operating System: %s (%s)%n", string2, string3);
        printWriter.printf("Java Version: %s%n", string4);
    }

    private File writeLog(Throwable throwable) {
        try {
            File file;
            String string = String.format("%s_crash", s_appName.toLowerCase());
            String string2 = s_handler.getLogFileDir();
            if (string2 == null) {
                string2 = OutputLog.getDefaultLogDir(s_appName);
            }
            if ((file = OutputLog.createLogFile(string2, string, ".log")).getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            PrintWriter printWriter = new PrintWriter(file);
            this.writeHeader(printWriter);
            printWriter.println();
            this.printStack(throwable, printWriter);
            printWriter.close();
            return file;
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace();
            return null;
        }
    }

    private String buildReport(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.writeHeader(printWriter);
        printWriter.println();
        printWriter.println("Stack Trace: ");
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private static String[] splitFileAndLbl(String string) {
        int n = string.indexOf(58);
        if (n != -1 && n != 0 && n != string.length() - 1) {
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            if (!string2.isEmpty() && !string3.isEmpty()) {
                return new String[]{string2, string3};
            }
        }
        return new String[]{"", ""};
    }

    public static void sendReport(String string, String string2, String string3) throws Throwable {
        String string4;
        String string5 = URLEncoder.encode("to", "UTF-8") + "=" + URLEncoder.encode(s_supportAddr, "UTF-8");
        string5 = string5 + "&" + URLEncoder.encode("appname", "UTF-8") + "=" + URLEncoder.encode(s_appName, "UTF-8");
        string5 = string5 + "&" + URLEncoder.encode("msg", "UTF-8") + "=" + URLEncoder.encode(string, "UTF-8");
        string5 = string5 + "&" + URLEncoder.encode("comment", "UTF-8") + "=" + URLEncoder.encode(string3, "UTF-8");
        if (string2 != null) {
            string5 = string5 + "&" + URLEncoder.encode("from", "UTF-8") + "=" + URLEncoder.encode(string2, "UTF-8");
        }
        URL uRL = new URL("http://thunderheadeng.net/bug_report.php");
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
        outputStreamWriter.write(string5);
        outputStreamWriter.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        while ((string4 = bufferedReader.readLine()) != null) {
            System.out.println(string4);
        }
        outputStreamWriter.close();
        bufferedReader.close();
    }

    static {
        s_actionLog = new BoundedStack(20);
    }

    private static class ActionLogEntry {
        public final String action;
        public final long date;

        public ActionLogEntry(String string) {
            this.action = string;
            this.date = System.currentTimeMillis();
        }
    }

    private static class TopBanner
    extends guiPanel {
        private String d_title;
        private Icon d_icon;

        public TopBanner() {
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
            this.setMinimumSize(new Dimension(460, 50));
            this.setPreferredSize(new Dimension(460, 50));
            this.setMaximumSize(new Dimension(460, 50));
            this.d_title = null;
            this.d_icon = null;
        }

        public void setTitle(String string) {
            this.d_title = string;
        }

        public void setIcon(Icon icon) {
            this.d_icon = icon;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n;
            int n2;
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.d_icon != null) {
                int n3 = this.d_icon.getIconWidth();
                int n4 = this.d_icon.getIconHeight();
                n2 = (this.getHeight() - n4) / 2;
                n = n3 / 2;
                this.d_icon.paintIcon(this, graphics2D, n, n2);
            }
            graphics2D.setFont(this.getFont());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds("M", graphics2D);
            graphics2D.setColor(Color.BLACK);
            n2 = (int)(rectangle2D.getWidth() * 2.0 + (double)this.d_icon.getIconWidth() * 1.5);
            n = (int)rectangle2D.getHeight() * 5 / 2;
            graphics2D.setFont(this.getFont().deriveFont(1));
            graphics2D.drawString(this.d_title, n2, n);
        }
    }

    public class ShowErrorReportDlg
    extends guiDialog {
        public ShowErrorReportDlg(Window window, String string) {
            super(window, Intl.intl("Error Report"), 1);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setText(string);
            jTextArea.setEditable(false);
            jTextArea.setCaretPosition(0);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            this.setPreferredSize(new Dimension(700, 500));
            this.setResizable(true);
            GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane(), true, 1, 1);
            double[] dArray = new double[]{1.0, 1.0};
            gridBagHelper.addRow(jScrollPane, dArray);
        }
    }

    public class CrashCatcherDlg
    extends JDialog {
        public static final int OK = 1;
        public static final int CANCEL = 8;
        private final Window d_owner;
        private JButton d_reportBtn;
        private JButton d_cancelBtn;
        private String d_comments;
        private String d_replyAddr;
        private String d_report;
        private final JTextArea d_commentBox;
        private final guiTextField d_replyTextField;
        private final guiCheckBox d_includeActionHistory;
        private int d_status;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CrashCatcherDlg(Window window, String string, List<String> list, String string2) {
            super(window, String.format(Intl.intl("%s Error"), s_appName));
            this.setResizable(true);
            this.d_owner = window;
            this.d_report = string2;
            this.d_status = -1;
            Container container = this.getContentPane();
            container.setLayout(new GridBagLayout());
            TopBanner topBanner = new TopBanner();
            topBanner.setTitle(string);
            topBanner.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            this.d_reportBtn = new JButton(Intl.intl("Send Error Report"));
            this.d_cancelBtn = new JButton(Intl.intl("Don't Send"));
            this.d_commentBox = new JTextArea();
            this.d_commentBox.setLineWrap(true);
            this.d_commentBox.setWrapStyleWord(true);
            this.d_commentBox.setRows(5);
            JScrollPane jScrollPane = new JScrollPane(this.d_commentBox);
            this.d_replyTextField = new guiTextField();
            this.d_includeActionHistory = new guiCheckBox(Intl.intl("Include action history"), true);
            HTMLBtn hTMLBtn = new HTMLBtn(Intl.intl("click here."));
            hTMLBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = CrashCatcherDlg.this.d_commentBox.getText();
                    String string3 = CrashCatcherDlg.this.d_replyTextField.getText();
                    if (!string3.isEmpty()) {
                        stringBuffer.append(Intl.intl("Reply Address: ") + string3 + "\n\n");
                    }
                    if (!string2.isEmpty()) {
                        stringBuffer.append(Intl.intl("User Comment: ") + string2 + "\n\n");
                    }
                    String string4 = string = CrashCatcherDlg.this.d_includeActionHistory.isSelected() ? CrashCatcherDlg.this.formatActionLog() : "";
                    if (!string.isEmpty()) {
                        stringBuffer.append(string);
                        stringBuffer.append("\n\n");
                    }
                    stringBuffer.append(CrashCatcherDlg.this.d_report);
                    ShowErrorReportDlg showErrorReportDlg = new ShowErrorReportDlg(CrashCatcherDlg.this.d_owner, stringBuffer.toString());
                    showErrorReportDlg.doModal();
                }
            });
            guiPanel guiPanel2 = new guiPanel();
            GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
            gridBagHelper.addRow(this.d_reportBtn, this.d_cancelBtn);
            guiPanel guiPanel3 = new guiPanel();
            gridBagHelper = new GridBagHelper(guiPanel3);
            for (String string3 : list) {
                boolean bl = false;
                String[] stringArray = CrashCatcher.splitFileAndLbl(string3);
                if (!stringArray[0].isEmpty() && !stringArray[1].isEmpty()) {
                    String string4 = stringArray[0] + ":";
                    String string5 = stringArray[1];
                    File file = new File(string5);
                    if (file.isFile() && file.getParentFile() != null) {
                        HTMLBtn hTMLBtn2 = new HTMLBtn(file.getName());
                        hTMLBtn2.setToolTipText(file.getAbsolutePath());
                        String string6 = file.getName();
                        String string7 = FilenameManager.splitFilename(string6)[1];
                        File file2 = string7.equalsIgnoreCase("txt") || string7.equalsIgnoreCase("htm") || string7.equalsIgnoreCase("pdf") || string7.equalsIgnoreCase("html") || string7.equalsIgnoreCase("log") ? file : file.getParentFile();
                        hTMLBtn2.addActionListener(actionEvent -> this.openFile(file2));
                        gridBagHelper.addRow(string4, hTMLBtn2, 1.0, 0);
                        bl = true;
                    }
                }
                if (bl) continue;
                gridBagHelper.addRow(string3, 0);
            }
            gridBagHelper.addRowSpace(2);
            gridBagHelper.addRow(Intl.intl("What were you doing at the time of the crash?"), 0);
            gridBagHelper.addRow(jScrollPane, new double[]{1.0, 1.0}, new int[]{0, 1});
            Object object = s_actionLog;
            synchronized (object) {
                if (s_actionLog.size() > 0) {
                    gridBagHelper.addRow(this.d_includeActionHistory, 0);
                }
            }
            gridBagHelper.addRowSpace(2);
            gridBagHelper.addRow(Intl.intl("Please enter your email address to help us fix this bug."), 0);
            gridBagHelper.addRow(Intl.intl("Reply address:"), 3, this.d_replyTextField, 1.0, 0);
            gridBagHelper.addRowSpace(2);
            gridBagHelper.addRow(Intl.intl("To see what data this error report contains, "), 5, hTMLBtn, 1.0, 0);
            object = new guiPanel();
            gridBagHelper = new GridBagHelper((Container)object, true);
            gridBagHelper.addRow(guiPanel3, new double[]{1.0, 1.0});
            gridBagHelper.addRowSpace(2);
            gridBagHelper.addRow(new Object[]{guiPanel2, GridBagHelper.Anchor.RIGHT});
            gridBagHelper = new GridBagHelper(container);
            gridBagHelper.addFilledRow(topBanner);
            gridBagHelper.pushSpacing(0, 0);
            gridBagHelper.addFilledRow(new guiSeparator());
            gridBagHelper.popSpacing();
            gridBagHelper.addRow(object, new double[]{1.0, 1.0});
            this.d_reportBtn.addActionListener(actionEvent -> {
                try {
                    this.sendReport();
                    JOptionPane.showMessageDialog(this, Intl.intl("Error report sent."), Intl.intl("Reporting Finished"), 1);
                }
                catch (Throwable throwable) {
                    guiUtil.showError(this, Intl.intl("Error Reporting"), Intl.intl("Problem sending error report"), throwable);
                }
                finally {
                    this.d_status = 1;
                    this.setVisible(false);
                }
            });
            this.d_cancelBtn.addActionListener(actionEvent -> {
                this.d_status = 8;
                this.setVisible(false);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String formatActionLog() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            BoundedStack boundedStack = s_actionLog;
            synchronized (boundedStack) {
                if (s_actionLog.size() > 0) {
                    printWriter.println("Action History:");
                    Date date = new Date(0L);
                    DateFormat dateFormat = DateFormat.getTimeInstance();
                    List list = s_actionLog.toList();
                    for (int i = list.size() - 1; i >= 0; --i) {
                        ActionLogEntry actionLogEntry = (ActionLogEntry)list.get(i);
                        date.setTime(actionLogEntry.date);
                        printWriter.printf("\t%s: %s", dateFormat.format(date), actionLogEntry.action);
                        if (i == 0) continue;
                        printWriter.println();
                    }
                }
            }
            printWriter.flush();
            return byteArrayOutputStream.toString();
        }

        public int doModal() {
            this.d_status = 8;
            this.setSize(this.getPreferredSize());
            this.setModal(true);
            this.setLocationRelativeTo(this.getParent());
            this.setVisible(true);
            return this.d_status;
        }

        public void sendReport() throws Throwable {
            String string;
            this.d_comments = this.d_commentBox.getText();
            if (this.d_includeActionHistory.isSelected() && !(string = this.formatActionLog()).isEmpty()) {
                if (!this.d_comments.isEmpty()) {
                    this.d_comments = this.d_comments + "\n\n";
                }
                this.d_comments = this.d_comments + string;
            }
            if (this.d_replyTextField.getValue().trim().isEmpty()) {
                this.d_replyAddr = this.d_replyTextField.getText();
            }
            CrashCatcher.sendReport(this.d_report, this.d_replyAddr, this.d_comments);
        }

        private void openFile(File file) {
            try {
                if (!Desktop.isDesktopSupported()) {
                    throw new Exception(Intl.intl("Unable to open file."));
                }
                Desktop.getDesktop().open(file);
            }
            catch (Throwable throwable) {
                guiUtil.showError(this, Intl.intl("Error"), Intl.intl("Unable to open file"), throwable);
            }
        }
    }
}

