/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import thunderheadeng.gui.guiUtil;

public class ColorIcon
implements Icon {
    public static final int OPT_BORDER = 1;
    public static final int OPT_NO_TRANSPARENCY = 2;
    private final Color d_color;
    private final Dimension d_dim;
    private final int d_options;

    public ColorIcon(Color color, int n, int n2, int n3) {
        this.d_dim = new Dimension(n, n2);
        this.d_color = color;
        this.d_options = n3;
    }

    @Override
    public int getIconHeight() {
        return this.d_dim.height;
    }

    @Override
    public int getIconWidth() {
        return this.d_dim.width;
    }

    private boolean test(int n) {
        return (this.d_options & n) == n;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.d_color == null) {
            return;
        }
        Color color = !this.test(2) || this.d_color.getAlpha() == 255 ? this.d_color : new Color(this.d_color.getRed(), this.d_color.getGreen(), this.d_color.getBlue(), 255);
        color = ColorIcon.choose(component, color);
        graphics.setColor(color);
        graphics.fillRect(n, n2, this.d_dim.width, this.d_dim.height);
        if (this.test(1)) {
            graphics.setColor(ColorIcon.choose(component, Color.BLACK));
            graphics.drawRect(n, n2, this.d_dim.width, this.d_dim.height);
        }
    }

    private static Color choose(Component component, Color color) {
        if (component.isEnabled()) {
            return color;
        }
        return new Color(guiUtil.DISABLED_FILTER.filterRGB(0, 0, color.getRGB()));
    }
}

