/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import thunderheadeng.Intl;
import thunderheadeng.gui.AbstractCommand;
import thunderheadeng.gui.Command;
import thunderheadeng.gui.CommandAction;
import thunderheadeng.gui.Document;
import thunderheadeng.gui.Editor;
import thunderheadeng.gui.OrderedProperties;
import thunderheadeng.gui.ResourcePaths;
import thunderheadeng.gui.SplashScreen;
import thunderheadeng.gui.View;
import thunderheadeng.gui.WaitCursorMgr;
import thunderheadeng.gui.guiError;
import thunderheadeng.gui.guiFrame;
import thunderheadeng.gui.guiTheme;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;

public abstract class Application {
    public static final String PROP_SAFEMODE = "SafeMode";
    public static final TypedProp<Boolean> PROP_SHOWSPLASH = new TypedProp<Boolean>((Object)"ShowSplash", true);
    public static final TypedProp<Integer> PROP_SIZE_WIDTH = new TypedProp<Integer>((Object)"Application.size.width", -1);
    public static final TypedProp<Integer> PROP_SIZE_HEIGHT = new TypedProp<Integer>((Object)"Application.size.height", -1);
    public static final TypedProp<Integer> PROP_OFFSET_X = new TypedProp<Integer>((Object)"Application.offset.x", Integer.class);
    public static final TypedProp<Integer> PROP_OFFSET_Y = new TypedProp<Integer>((Object)"Application.offset.y", Integer.class);
    public static final TypedProp<Integer> PROP_EXTENDED_STATE = new TypedProp<Integer>((Object)"Application.extendedState", 0);
    public static final CloseAllFramesCmd CLOSE_ALL_FRAMES_CMD = new CloseAllFramesCmd();
    public static final AppQuitCommand APP_QUIT_CMD = new AppQuitCommand();
    public static final OptionsCmd OPTIONS_CMD = new OptionsCmd();
    public static final double MAIN_FRAME_RATIO = 0.7;
    private static final GraphicsConfiguration s_defGC = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    private static final Logger LOGGER = Logger.getLogger(Application.class.getName());
    private static Application s_theApp;
    private String d_installDir;
    private final ResourcePaths d_resourcePaths;
    protected TeciProps d_props;
    private JFrame d_mainFrame;
    private String d_appName;
    protected Document d_document;
    private View d_activeView;
    private Command[] d_commands = new Command[]{APP_QUIT_CMD};
    private Vector<JFrame> d_frameList = new Vector();
    private SplashScreen d_splash;
    private final boolean d_safeMode;

    public Application(String string, String string2, JFrame jFrame) {
        s_theApp = this;
        this.d_installDir = string2;
        this.d_mainFrame = jFrame;
        this.d_appName = string;
        this.d_resourcePaths = new ResourcePaths(this, "lib");
        this.d_frameList.add(jFrame);
        this.d_safeMode = false;
        this.d_props = new TeciProps();
    }

    public Application(String string, String[] stringArray) {
        this(string, stringArray, null);
    }

    public Application(String string, String[] stringArray, URL uRL) {
        s_theApp = this;
        this.d_appName = string;
        this.d_installDir = null;
        this.d_resourcePaths = new ResourcePaths(this, "lib");
        this.readPreferences();
        this.updatePreferences(stringArray);
        boolean bl = this.d_safeMode = this.d_props.getProperty(PROP_SAFEMODE) != null;
        if (this.d_safeMode) {
            LOGGER.log(Level.INFO, "Starting in SAFE MODE");
            this.d_props.remove(PROP_SAFEMODE);
            this.loadSafeModeProps(this.d_props);
        }
        boolean bl2 = uRL != null && this.d_props.getBoolean(PROP_SHOWSPLASH) && System.getProperty("nosplash") == null;
        this.d_splash = bl2 ? new SplashScreen(uRL) : null;
        this.loadLibraries();
        MetalLookAndFeel.setCurrentTheme(new guiTheme());
        String string2 = System.getProperty("lafpackage", UIManager.getSystemLookAndFeelClassName());
        try {
            LOGGER.log(Level.CONFIG, "Using LaF class name: " + string2);
            UIManager.setLookAndFeel(string2);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.toString(), exception);
        }
        this.d_document = this.createDocument();
        this.createDefaultFrame();
        this.d_mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                if (Application.this.d_splash != null) {
                    Application.this.d_splash.hideSplash();
                    Application.this.d_splash = null;
                }
                Application.this.d_mainFrame.removeWindowListener(this);
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DecimalReplacer decimalReplacer = new DecimalReplacer();
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(decimalReplacer);
            }
        });
    }

    public SplashScreen getSplash() {
        return this.d_splash;
    }

    public boolean isSafeMode() {
        return this.d_safeMode;
    }

    protected void loadSafeModeProps(TeciProps teciProps) {
        teciProps.set(PROP_SHOWSPLASH, Boolean.valueOf(false));
    }

    protected abstract void loadLibraries();

    public static void loadLib(String string) {
        LOGGER.log(Level.FINE, "loading " + string + "...");
        System.loadLibrary(string);
        LOGGER.log(Level.FINE, "done");
    }

    private void createDefaultFrame() {
        guiFrame guiFrame2 = new guiFrame();
        this.d_frameList.add(guiFrame2);
        guiFrame2.setTitle(this.d_appName);
        guiFrame2.setCloseCommand(APP_QUIT_CMD);
        this.loadFrameProps(guiFrame2);
        guiFrame2.setJMenuBar(this.createMenuBar());
        this.d_mainFrame = guiFrame2;
    }

    public static Rectangle getVirtualBounds() {
        GraphicsDevice[] graphicsDeviceArray;
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            GraphicsConfiguration[] graphicsConfigurationArray;
            for (GraphicsConfiguration graphicsConfiguration : graphicsConfigurationArray = graphicsDevice.getConfigurations()) {
                rectangle = rectangle.union(graphicsConfiguration.getBounds());
            }
        }
        if (rectangle.width == 0 || rectangle.height == 0) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            return new Rectangle(dimension);
        }
        return rectangle;
    }

    protected void loadFrameProps(guiFrame guiFrame2) {
        Integer n = this.d_props.get(PROP_OFFSET_X);
        Integer n2 = this.d_props.get(PROP_OFFSET_Y);
        int n3 = this.d_props.getInt(PROP_SIZE_WIDTH);
        int n4 = this.d_props.getInt(PROP_SIZE_HEIGHT);
        int n5 = this.d_props.getInt(PROP_EXTENDED_STATE);
        Rectangle rectangle = null;
        if (n3 <= 0 || n4 <= 0) {
            guiFrame2.setSize(0.7);
        } else {
            if (rectangle == null) {
                rectangle = Application.getVirtualBounds();
            }
            n3 = Math.min(rectangle.width, n3);
            n4 = Math.min(rectangle.height, n4);
            if (n3 <= 0 || n4 <= 0) {
                guiFrame2.setSize(0.7);
            } else {
                guiFrame2.setSize(n3, n4);
            }
        }
        if (n != null && n2 != null) {
            if (rectangle == null) {
                rectangle = Application.getVirtualBounds();
            }
            int n6 = rectangle.width - guiFrame2.getSize().width;
            int n7 = rectangle.height - guiFrame2.getSize().height;
            int n8 = 0;
            int n9 = 0;
            if (n < n8) {
                n = n8;
            } else if (n > n6) {
                n = n6;
            }
            if (n2 < n9) {
                n2 = n9;
            } else if (n2 > n7) {
                n2 = n7;
            }
            guiFrame2.setLocation(n, n2);
        } else {
            guiFrame2.center();
        }
        guiFrame2.setExtendedState(n5);
    }

    protected void saveFrameProps(guiFrame guiFrame2) {
        if (guiFrame2 == null) {
            return;
        }
        guiFrame.FrameProps frameProps = guiFrame2.getFrameProps();
        Rectangle rectangle = frameProps.lastBounds;
        if (rectangle != null) {
            this.d_props.set(PROP_OFFSET_X, Integer.valueOf(rectangle.x));
            this.d_props.set(PROP_OFFSET_Y, Integer.valueOf(rectangle.y));
            this.d_props.set(PROP_SIZE_WIDTH, Integer.valueOf(rectangle.width));
            this.d_props.set(PROP_SIZE_HEIGHT, Integer.valueOf(rectangle.height));
        }
        this.d_props.set(PROP_EXTENDED_STATE, Integer.valueOf(frameProps.lastExtendedState));
    }

    public JMenuBar createMenuBar() {
        return new JMenuBar();
    }

    public JFrame getMainFrame() {
        return this.d_mainFrame;
    }

    public String getAppName() {
        return this.d_appName;
    }

    public String toString() {
        return this.getAppName();
    }

    public guiFrame createFrame() {
        guiFrame guiFrame2 = new guiFrame();
        this.addFrame(guiFrame2);
        return guiFrame2;
    }

    public void addFrame(JFrame jFrame) {
        jFrame.setIconImages(this.d_mainFrame.getIconImages());
        this.d_frameList.add(jFrame);
    }

    public void addEditor(Editor editor) {
        Command[] commandArray = editor.getCommands();
        this.d_commands = Command.merge(this.d_commands, commandArray);
    }

    public void addCommand(Command command) {
        List<Command> list = Arrays.asList(this.d_commands);
        list.add(command);
        this.d_commands = list.toArray(new Command[list.size()]);
    }

    public void loadMenu(String string) {
    }

    public void loadToolbar(String string) {
    }

    public void setActiveView(View view) {
        this.d_activeView = view;
    }

    public View getActiveView() {
        return this.d_activeView;
    }

    public Command getCommand(String string) {
        Command command = null;
        for (int i = 0; i < this.d_commands.length; ++i) {
            if (!this.d_commands[i].name().equals(string)) continue;
            command = this.d_commands[i];
        }
        return command;
    }

    public void createView(Document document) {
    }

    public Document createDocument() {
        return null;
    }

    public Document getDocument() {
        return this.d_document;
    }

    public void error(String string) {
        this.error(this.getAppName(), string);
    }

    public void error(guiError guiError2) {
        this.error(this.getAppName(), guiError2);
    }

    public void error(String string, final String string2) {
        this.error(string, new guiError(){

            @Override
            public String getMessage() {
                return string2;
            }
        });
    }

    public void error(final String string, final guiError guiError2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(Application.this.d_mainFrame, guiError2.getMessage(), string, 0);
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void error(int n) {
    }

    public final void quit() throws Exception {
        throw new Exception("This method is gone. Use the other quit() method now.");
    }

    public void quit(boolean bl) {
        assert (EventQueue.isDispatchThread());
        this.savePreferences();
        System.exit(0);
    }

    public static Application getApp() {
        return s_theApp;
    }

    public static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        return s_defGC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WaitCursorMgr> getWaitMgrs() {
        Vector<JFrame> vector = this.d_frameList;
        synchronized (vector) {
            ArrayList<WaitCursorMgr> arrayList = new ArrayList<WaitCursorMgr>(this.d_frameList.size());
            for (JFrame jFrame : this.d_frameList) {
                WaitCursorMgr waitCursorMgr = guiUtil.getWaitMgr(jFrame);
                if (waitCursorMgr == null) continue;
                arrayList.add(waitCursorMgr);
            }
            return arrayList;
        }
    }

    public void performWaitOp(Consumer<WaitCursorMgr> consumer) {
        this.getWaitMgrs().stream().forEach(consumer);
    }

    public void beginWaitCursor() {
        this.performWaitOp(waitCursorMgr -> waitCursorMgr.beginWaitCursor());
    }

    public void beginWaitCursor(boolean bl) {
        this.performWaitOp(waitCursorMgr -> waitCursorMgr.beginWaitCursor(bl));
    }

    public void beginWaitCursor(int n) {
        this.performWaitOp(waitCursorMgr -> waitCursorMgr.beginWaitCursor(n));
    }

    public boolean isInputBlocking(Component component) {
        WaitCursorMgr waitCursorMgr = guiUtil.getWaitMgr(component);
        return waitCursorMgr != null ? waitCursorMgr.isInputBlocked() : false;
    }

    public void endWaitCursor() {
        this.performWaitOp(waitCursorMgr -> waitCursorMgr.endWaitCursor());
    }

    public void removeFrame(JFrame jFrame) {
        this.d_frameList.remove(jFrame);
    }

    public JFrame getActiveFrame() {
        for (JFrame jFrame : this.d_frameList) {
            if (!(jFrame instanceof guiFrame) || ((guiFrame)jFrame).getView() != this.d_activeView) continue;
            return jFrame;
        }
        return this.d_mainFrame;
    }

    public void savePreferences() {
        if (this.d_mainFrame instanceof guiFrame) {
            this.saveFrameProps((guiFrame)this.d_mainFrame);
        }
        String string = this.getPropertyFilename();
        try {
            File file = new File(string);
            File file2 = file.getParentFile();
            if (!file2.exists() && !file2.mkdirs()) {
                throw new FileNotFoundException("Unable to create folder: " + file2);
            }
            OrderedProperties orderedProperties = new OrderedProperties(this.d_props);
            orderedProperties.store(new FileOutputStream(string), null);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Error saving preferences to file: " + string);
            LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
            return;
        }
    }

    public void readPreferences() {
        try {
            this.d_props = this.loadPreferences();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "Error retrieving preferences: " + iOException.getMessage());
            LOGGER.log(Level.INFO, "Using default preferences.");
            this.d_props = new TeciProps(this.getDefaultProperties());
        }
    }

    protected TeciProps loadPreferences() throws IOException {
        String string = this.getPropertyFilename();
        TeciProps teciProps = new TeciProps(this.getDefaultProperties());
        teciProps.load(new FileInputStream(string));
        return teciProps;
    }

    public void updatePreferences(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.startsWith("-D")) continue;
            String[] stringArray2 = string.substring(2).split("=");
            if (stringArray2.length == 1) {
                this.d_props.setProperty(stringArray2[0], "");
                continue;
            }
            if (stringArray2.length != 2) continue;
            this.d_props.setProperty(stringArray2[0], stringArray2[1]);
        }
    }

    public Properties getDefaultProperties() {
        return null;
    }

    public String getPreference(String string) {
        return this.d_props.getProperty(string);
    }

    public Integer getIntPreference(String string) {
        String string2 = this.getPreference(string);
        if (string2 == null) {
            return null;
        }
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean getBooleanPreference(String string) {
        return Boolean.valueOf(this.getPreference(string));
    }

    public TeciProps getPrefs() {
        return this.d_props;
    }

    public void setPreference(String string, String string2) {
        this.d_props.setProperty(string, string2);
    }

    public void setBooleanPreference(String string, boolean bl) {
        this.setPreference(string, new Boolean(bl).toString());
    }

    public String getWorkingDir() {
        return this.getPreference("WorkingDir");
    }

    public void setWorkingDir(String string) {
        this.setPreference("WorkingDir", string);
    }

    public String getResourceFile(String string) {
        return this.d_resourcePaths.get(string);
    }

    public ResourcePaths getResourcePaths() {
        return this.d_resourcePaths;
    }

    protected String getPropertyFilename() {
        String string = Application.getPrefsFilename(this.getAppDataDir(), this.getAppName());
        LOGGER.log(Level.INFO, "Using properties file: " + string);
        return string;
    }

    public static String getPrefsFilename(String string, String string2) {
        return string + string2 + ".props";
    }

    public static String getPrefsFilename(String string) {
        return Application.getPrefsFilename(Application.getAppDataDir(string), string);
    }

    public static String getPrefsProgramDataFilename(String string) {
        return Application.getPrefsFilename(Application.getEnvDir(string, "PROGRAMDATA"), string);
    }

    public String getAppDataDir() {
        return Application.getAppDataDir(this.getAppName());
    }

    public static String getAppDataDir(String string) {
        return Application.getEnvDir(string, "APPDATA");
    }

    public String getProgramDataDir() {
        return this.getProgramDataDir(this.getAppName());
    }

    public String getProgramDataDir(String string) {
        return Application.getEnvDir("Application Data" + File.separator + string, "ALLUSERSPROFILE");
    }

    private static String getEnvDir(String string, String string2) {
        String string3 = File.separator;
        String string4 = System.getenv(string2);
        if (string4 == null) {
            throw new NullPointerException("Unable to locate APPDATA folder.");
        }
        return string4 + string3 + string + string3;
    }

    public abstract boolean isInstallFolder(File var1);

    private String findInstallFolder() {
        String string = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        LOGGER.log(Level.INFO, "Code Source: " + string);
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.SEVERE, unsupportedEncodingException.toString(), unsupportedEncodingException);
        }
        if (string.endsWith(".jar")) {
            string = new File(string).getParent();
        } else {
            string = string + this.getClass().getName().replace('.', '/');
            string = new File(string).getParent();
        }
        for (File file = new File(string); file != null; file = file.getParentFile()) {
            if (!this.isInstallFolder(file)) continue;
            return file.getPath();
        }
        return null;
    }

    public String getInstallDir() {
        if (this.d_installDir == null) {
            this.d_installDir = this.findInstallFolder();
            LOGGER.log(Level.INFO, "Install Folder: " + this.d_installDir);
        }
        return this.d_installDir;
    }

    public static class OptionsCmd
    extends AbstractCommand {
        public OptionsCmd() {
            super("Options...", "graphics/Preferences16.gif");
        }

        @Override
        public void execute() {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public String helpText() {
            return "Edit application options.";
        }
    }

    public static class AppQuitCommand
    extends CommandAction {
        public AppQuitCommand() {
            super(Intl.intl("Exit"), "");
            this.putValue("ShortDescription", "Exit");
            this.putValue("LongDescription", "Exit the application.");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Application.getApp().quit(true);
        }
    }

    public static class CloseAllFramesCmd
    extends AbstractCommand {
        public CloseAllFramesCmd() {
            super("Close all windows", "");
        }

        @Override
        public void execute() {
            super.execute();
            Application application = Application.getApp();
            int n = application.d_frameList.size();
            for (int i = n - 1; i >= 0; --i) {
                JFrame jFrame = (JFrame)application.d_frameList.get(i);
                if (jFrame == application.d_mainFrame || !(jFrame instanceof guiFrame) || ((guiFrame)jFrame).close()) continue;
                this.d_breakCommandChain = true;
                return;
            }
        }
    }

    private static class DecimalReplacer
    implements KeyEventDispatcher {
        private Character d_currentChar = null;

        private DecimalReplacer() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            switch (keyEvent.getID()) {
                case 401: {
                    if (keyEvent.getKeyCode() == 110) {
                        this.d_currentChar = Character.valueOf(DecimalReplacer.getDecimalSep());
                        break;
                    }
                    this.d_currentChar = null;
                    break;
                }
                case 402: {
                    if (keyEvent.getKeyCode() != 110) break;
                    this.d_currentChar = null;
                    break;
                }
                case 400: {
                    if (this.d_currentChar == null) break;
                    keyEvent.setKeyChar(this.d_currentChar.charValue());
                }
            }
            return false;
        }

        private static char getDecimalSep() {
            NumberFormat numberFormat = NumberFormat.getInstance();
            DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)numberFormat).getDecimalFormatSymbols();
            return decimalFormatSymbols.getDecimalSeparator();
        }
    }
}

