/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.util.function.IntToDoubleFunction;
import java.util.stream.IntStream;
import thunderheadeng.gui.ISeries;

public abstract class ASeries
implements ISeries {
    private String d_name;
    private Color d_color;
    private int d_markType;
    private int d_lineType;
    private int d_weight;
    private int d_id;
    private double d_minX;
    private double d_minY;
    private double d_maxX;
    private double d_maxY;
    private static int s_maxId = 0;

    public ASeries(String string, Color color, int n, int n2, int n3) {
        this.d_name = string;
        this.d_color = color;
        this.d_markType = n;
        this.d_lineType = n2;
        this.d_weight = n3;
        this.d_id = s_maxId++;
        this.resetBounds();
    }

    protected void resetBounds() {
        this.d_maxY = Double.NaN;
        this.d_minY = Double.NaN;
        this.d_maxX = Double.NaN;
        this.d_minX = Double.NaN;
    }

    protected boolean getBoundsValid() {
        return !Double.isNaN(this.d_minX);
    }

    @Override
    public String getName() {
        return this.d_name;
    }

    public void setName(String string) {
        this.d_name = string;
    }

    @Override
    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color color) {
        this.d_color = color;
    }

    @Override
    public int getMarkType() {
        return this.d_markType;
    }

    @Override
    public int getLineType() {
        return this.d_lineType;
    }

    public void setLineType(int n) {
        this.d_lineType = n;
    }

    @Override
    public int getWeight() {
        return this.d_weight;
    }

    @Override
    public int getId() {
        return this.d_id;
    }

    protected void updateBounds() {
        IntToDoubleFunction intToDoubleFunction = this.getX();
        IntToDoubleFunction intToDoubleFunction2 = this.getY();
        this.d_minX = ASeries.min(this.getIndexes(), intToDoubleFunction);
        this.d_maxX = ASeries.max(this.getIndexes(), intToDoubleFunction);
        this.d_minY = ASeries.min(this.getIndexes(), intToDoubleFunction2);
        this.d_maxY = ASeries.max(this.getIndexes(), intToDoubleFunction2);
    }

    @Override
    public double getMinX() {
        return this.d_minX;
    }

    @Override
    public double getMaxX() {
        return this.d_maxX;
    }

    @Override
    public double getMinY() {
        return this.d_minY;
    }

    @Override
    public double getMaxY() {
        return this.d_maxY;
    }

    private static double min(IntStream intStream, IntToDoubleFunction intToDoubleFunction) {
        return intStream.mapToDouble(intToDoubleFunction).min().orElse(Double.MAX_VALUE);
    }

    private static double max(IntStream intStream, IntToDoubleFunction intToDoubleFunction) {
        return intStream.mapToDouble(intToDoubleFunction).max().orElse(-1.7976931348623157E308);
    }
}

