/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.util.Filters;

public class CollResult<ResT, CollT extends ResT>
implements IResult<ResT> {
    public final Class<CollT> type;
    public final Predicate<? super CollT> filter;
    public final Collection<CollT> coll;

    public CollResult() {
        this(new ArrayList());
    }

    public CollResult(Class<CollT> clazz) {
        this(new ArrayList(), clazz);
    }

    public CollResult(Class<CollT> clazz, Predicate<? super CollT> predicate) {
        this(new ArrayList(), clazz, predicate);
    }

    public CollResult(Collection<CollT> collection) {
        this(collection, null);
    }

    public CollResult(Collection<CollT> collection, Class<CollT> clazz) {
        this(collection, clazz, Filters.acceptAll());
    }

    public CollResult(Collection<CollT> collection, Class<CollT> clazz, Predicate<? super CollT> predicate) {
        this.coll = collection;
        this.type = clazz;
        this.filter = predicate;
    }

    @Override
    public void mark(ResT ResT, Containment containment) {
        if (this.type == null || this.type.isInstance(ResT) && this.filter.test(ResT)) {
            this.coll.add(ResT);
        }
    }
}

