/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public class TranslateXform
implements ITransform,
Serializable {
    private static final long serialVersionUID = 1L;
    public final double x;
    public final double y;
    public final double z;

    public TranslateXform(Tuple3d tuple3d) {
        this(tuple3d.x, tuple3d.y, tuple3d.z);
    }

    public TranslateXform(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof TranslateXform && ((TranslateXform)object).x == this.x && ((TranslateXform)object).y == this.y && ((TranslateXform)object).z == this.z;
    }

    public int hashCode() {
        return 0x123498FE ^ Double.hashCode(this.x) + Double.hashCode(this.y) + Double.hashCode(this.z);
    }

    @Override
    public Matrix4d toMatrix(boolean bl) {
        return new Matrix4d(1.0, 0.0, 0.0, this.x, 0.0, 1.0, 0.0, this.y, 0.0, 0.0, 1.0, this.z, 0.0, 0.0, 0.0, 1.0);
    }

    @Override
    public TransformInfo getInfo() {
        return new TransformInfo((ITransform)this, false);
    }

    @Override
    public ITransform concatenate(ITransform iTransform) {
        if (iTransform instanceof TranslateXform) {
            TranslateXform translateXform = (TranslateXform)iTransform;
            return new TranslateXform(this.x + translateXform.x, this.y + translateXform.y, this.z + translateXform.z);
        }
        return ITransform.super.concatenate(iTransform);
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        return new TranslateXform(-this.x, -this.y, -this.z);
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    @Override
    public ITransform optimize() {
        if (this.isIdentity()) {
            return IdentityXform.INSTANCE;
        }
        return ITransform.super.optimize();
    }

    @Override
    public ITransform.ITransformer getTransformer() {
        return new ITransform.ITransformer(){

            @Override
            public void transform(Point3d point3d) {
                point3d.x += TranslateXform.this.x;
                point3d.y += TranslateXform.this.y;
                point3d.z += TranslateXform.this.z;
            }

            @Override
            public void transform(Vector3d vector3d) {
            }
        };
    }

    @Override
    public boolean isIdentity() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public String toString() {
        return String.format("Translate: (%s, %s, %s)", Double.toString(this.x), Double.toString(this.y), Double.toString(this.z));
    }
}

