/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Quat4d;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.transform.ConcatTransform;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;
import thunderheadeng.geometry.objs.transform.MirrorXform;
import thunderheadeng.geometry.objs.transform.RotateXform;
import thunderheadeng.geometry.objs.transform.ScaleXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TranslateXform;

public class TransformUtil {
    public static final IdentityXform IDENTITY = IdentityXform.INSTANCE;
    public static final TransformInfo IDENTITY_INFO = IDENTITY.getInfo();
    public static final Predicate<ITransform> SCALING_FILTER = iTransform -> !(iTransform instanceof TranslateXform) && !(iTransform instanceof RotateXform) && !(iTransform instanceof MirrorXform) && !iTransform.isIdentity();

    public static ITransform rotate(double d, double d2, double d3, double d4) {
        if (d4 == 0.0) {
            return IDENTITY;
        }
        return new RotateXform(d, d2, d3, d4);
    }

    public static ITransform rotate(AxisAngle4d axisAngle4d) {
        if (axisAngle4d.angle == 0.0) {
            return IDENTITY;
        }
        return new RotateXform(axisAngle4d);
    }

    public static ITransform rotate(Quat4d quat4d) {
        if (quat4d.w == 1.0) {
            return IDENTITY;
        }
        return new RotateXform(quat4d);
    }

    public static ITransform scale(double d, double d2, double d3) {
        if (d == 1.0 && d2 == 1.0 && d3 == 1.0) {
            return IDENTITY;
        }
        return new ScaleXform(d, d2, d3);
    }

    public static ITransform translate(double d, double d2, double d3) {
        if (d == 0.0 && d2 == 0.0 && d3 == 0.0) {
            return IDENTITY;
        }
        return new TranslateXform(d, d2, d3);
    }

    public static ITransform mirror(Plane3d plane3d) {
        return new MirrorXform(plane3d);
    }

    public static void iterateLastToFirst(ITransform iTransform, Consumer<ITransform> consumer) {
        if (iTransform instanceof ConcatTransform) {
            ConcatTransform concatTransform = (ConcatTransform)iTransform;
            TransformUtil.iterateLastToFirst(concatTransform.left, consumer);
            TransformUtil.iterateLastToFirst(concatTransform.right, consumer);
            return;
        }
        consumer.accept(iTransform);
    }

    public static void iterateFirstToLast(ITransform iTransform, Consumer<ITransform> consumer) {
        if (iTransform instanceof ConcatTransform) {
            ConcatTransform concatTransform = (ConcatTransform)iTransform;
            TransformUtil.iterateFirstToLast(concatTransform.right, consumer);
            TransformUtil.iterateFirstToLast(concatTransform.left, consumer);
            return;
        }
        consumer.accept(iTransform);
    }

    public static ITransform findTransformLastToFirst(ITransform iTransform2, Predicate<ITransform> predicate) {
        ITransform[] iTransformArray = new ITransform[]{null};
        try {
            TransformUtil.iterateLastToFirst(iTransform2, iTransform -> {
                if (predicate.test((ITransform)iTransform)) {
                    iTransformArray[0] = iTransform;
                    throw new CancellationException();
                }
            });
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return iTransformArray[0];
    }
}

