/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.util.Map;
import javax.vecmath.Matrix4d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.util.ListMap;

public class TransformInfo {
    public final ITransform xform;
    private Matrix4d d_matrix;
    private Double d_determinant;
    private Boolean d_isIdentity;
    private Boolean d_hasNegativeScale;
    private Map<IDOF, Boolean> d_dofCompatibility;
    private Boolean d_isInvertible;

    protected TransformInfo(ITransform iTransform) {
        this(iTransform, null);
    }

    public TransformInfo(Matrix4d matrix4d) {
        this((ITransform)new MatrixXform(matrix4d), matrix4d);
    }

    protected TransformInfo(ITransform iTransform, Matrix4d matrix4d) {
        this.xform = iTransform;
        this.d_matrix = matrix4d;
    }

    protected TransformInfo(ITransform iTransform, boolean bl) {
        this.xform = iTransform;
        this.d_matrix = null;
        this.d_hasNegativeScale = bl;
    }

    public synchronized Matrix4d getMatrix() {
        if (this.d_matrix == null) {
            this.d_matrix = this.xform.toMatrix(false);
        }
        return this.d_matrix;
    }

    public synchronized double getDeterminant() {
        if (this.d_determinant == null) {
            this.d_determinant = this.getMatrix().determinant();
        }
        return this.d_determinant;
    }

    public synchronized boolean isIdentity() {
        if (this.d_isIdentity == null) {
            this.d_isIdentity = this.xform.isIdentity();
        }
        return this.d_isIdentity;
    }

    public synchronized boolean isInvertible() {
        if (this.d_isInvertible == null) {
            this.d_isInvertible = this.xform.isInvertible();
        }
        return this.d_isInvertible;
    }

    public synchronized boolean isAccepted(IDOF iDOF2) {
        if (iDOF2 == IDOF.FREE) {
            return true;
        }
        if (this.d_dofCompatibility == null) {
            this.d_dofCompatibility = new ListMap<IDOF, Boolean>();
        }
        return this.d_dofCompatibility.computeIfAbsent(iDOF2, iDOF -> iDOF.accept(this));
    }

    public TransformInfo concatenate(ITransform iTransform) {
        ITransform iTransform2 = this.xform.concatenate(iTransform);
        if (iTransform2 == this.xform) {
            return this;
        }
        return iTransform2.getInfo();
    }

    public synchronized boolean hasNegativeScale() {
        if (this.d_hasNegativeScale == null) {
            double d = this.getDeterminant();
            this.d_hasNegativeScale = Double.isNaN(d) ? false : d < 0.0;
        }
        return this.d_hasNegativeScale;
    }

    public AABox getBounds(IGeom iGeom, AABox aABox) {
        return GeomUtil.getTransformedBounds(this, iGeom, aABox);
    }
}

