/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.Intl;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;

public class ScaleXform
implements ITransform,
Serializable {
    private static final long serialVersionUID = 1L;
    public final double x;
    public final double y;
    public final double z;

    public ScaleXform(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof ScaleXform && ((ScaleXform)object).x == this.x && ((ScaleXform)object).y == this.y && ((ScaleXform)object).z == this.z;
    }

    public int hashCode() {
        return 0x239FA83 ^ Double.hashCode(this.x) + Double.hashCode(this.y) + Double.hashCode(this.z);
    }

    @Override
    public Matrix4d toMatrix(boolean bl) {
        return new Matrix4d(this.x, 0.0, 0.0, 0.0, 0.0, this.y, 0.0, 0.0, 0.0, 0.0, this.z, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @Override
    public ITransform concatenate(ITransform iTransform) {
        if (iTransform instanceof ScaleXform) {
            ScaleXform scaleXform = (ScaleXform)iTransform;
            return new ScaleXform(this.x * scaleXform.x, this.y * scaleXform.y, this.z * scaleXform.z);
        }
        return ITransform.super.concatenate(iTransform);
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        if (!this.isInvertible()) {
            throw new NoninvertibleTransformException(Intl.intl("Non-invertible scale transform: contains 0 scaling factor."));
        }
        return new ScaleXform(1.0 / this.x, 1.0 / this.y, 1.0 / this.z);
    }

    @Override
    public boolean isInvertible() {
        return this.x != 0.0 && this.y != 0.0 && this.z != 0.0;
    }

    @Override
    public ITransform optimize() {
        if (this.isIdentity()) {
            return IdentityXform.INSTANCE;
        }
        return ITransform.super.optimize();
    }

    @Override
    public ITransform.ITransformer getTransformer() {
        return new ITransform.ITransformer(){

            @Override
            public void transform(Point3d point3d) {
                point3d.x *= ScaleXform.this.x;
                point3d.y *= ScaleXform.this.y;
                point3d.z *= ScaleXform.this.z;
            }

            @Override
            public void transform(Vector3d vector3d) {
                vector3d.x *= ScaleXform.this.x;
                vector3d.y *= ScaleXform.this.y;
                vector3d.z *= ScaleXform.this.z;
            }
        };
    }

    @Override
    public boolean isIdentity() {
        return this.x == 1.0 && this.y == 1.0 && this.z == 1.0;
    }

    public String toString() {
        return String.format("Scale: (%s, %s, %s)", Double.toString(this.x), Double.toString(this.y), Double.toString(this.z));
    }
}

