/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.Intl;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public class RotateXform
implements ITransform,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Quat4d rotation;

    public RotateXform(double d, double d2, double d3, double d4) {
        this(new AxisAngle4d(d, d2, d3, d4));
    }

    public RotateXform(AxisAngle4d axisAngle4d) {
        this(RotateXform.toQuat(axisAngle4d));
    }

    public RotateXform(Quat4d quat4d) {
        this.rotation = quat4d;
    }

    private static Quat4d toQuat(AxisAngle4d axisAngle4d) {
        Quat4d quat4d = new Quat4d();
        quat4d.set(axisAngle4d);
        return quat4d;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof RotateXform && ((RotateXform)object).rotation.equals(this.rotation);
    }

    public int hashCode() {
        return 0x239FA83 ^ this.rotation.hashCode();
    }

    @Override
    public Matrix4d toMatrix(boolean bl) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.set(this.rotation);
        return matrix4d;
    }

    @Override
    public TransformInfo getInfo() {
        return new TransformInfo((ITransform)this, false);
    }

    public double getAngle() {
        return 2.0 * Math.acos(this.rotation.w);
    }

    public Vector3d getAxis() {
        return this.getAxis(this.getAngle());
    }

    private Vector3d getAxis(double d) {
        double d2 = 1.0 / Math.sin(d);
        return new Vector3d(this.rotation.x * d2, this.rotation.y * d2, this.rotation.z * d2);
    }

    public AxisAngle4d getAxisAngle() {
        double d = this.getAngle();
        Vector3d vector3d = this.getAxis(d);
        return new AxisAngle4d(vector3d, d);
    }

    @Override
    public ITransform concatenate(ITransform iTransform) {
        if (iTransform instanceof RotateXform) {
            RotateXform rotateXform = (RotateXform)iTransform;
            Quat4d quat4d = new Quat4d(this.rotation);
            quat4d.mul(rotateXform.rotation);
            return new RotateXform(quat4d);
        }
        return ITransform.super.concatenate(iTransform);
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        try {
            Quat4d quat4d = new Quat4d(this.rotation);
            quat4d.inverse();
            return new RotateXform(quat4d);
        }
        catch (Throwable throwable) {
            throw new NoninvertibleTransformException(Intl.intl("Non-invertible rotation transform."));
        }
    }

    @Override
    public boolean isInvertible() {
        try {
            this.invert();
            return true;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return false;
        }
    }

    @Override
    public ITransform optimize() {
        if (this.isIdentity()) {
            return IdentityXform.INSTANCE;
        }
        return ITransform.super.optimize();
    }

    @Override
    public ITransform.ITransformer getTransformer() {
        return new ITransform.ITransformer(){

            @Override
            public void transform(Point3d point3d) {
                this.transform((Tuple3d)point3d);
            }

            @Override
            public void transform(Vector3d vector3d) {
                this.transform((Tuple3d)vector3d);
            }

            private void transform(Tuple3d tuple3d) {
                double d = -RotateXform.this.rotation.x * tuple3d.x - RotateXform.this.rotation.y * tuple3d.y - RotateXform.this.rotation.z * tuple3d.z;
                double d2 = RotateXform.this.rotation.w * tuple3d.x + RotateXform.this.rotation.y * tuple3d.z - RotateXform.this.rotation.z * tuple3d.y;
                double d3 = RotateXform.this.rotation.w * tuple3d.y - RotateXform.this.rotation.x * tuple3d.z + RotateXform.this.rotation.z * tuple3d.x;
                double d4 = RotateXform.this.rotation.w * tuple3d.z + RotateXform.this.rotation.x * tuple3d.y - RotateXform.this.rotation.y * tuple3d.x;
                tuple3d.x = -d * RotateXform.this.rotation.x + d2 * RotateXform.this.rotation.w - d3 * RotateXform.this.rotation.z + d4 * RotateXform.this.rotation.y;
                tuple3d.y = -d * RotateXform.this.rotation.y + d2 * RotateXform.this.rotation.z + d3 * RotateXform.this.rotation.w - d4 * RotateXform.this.rotation.x;
                tuple3d.z = -d * RotateXform.this.rotation.z - d2 * RotateXform.this.rotation.y + d3 * RotateXform.this.rotation.x + d4 * RotateXform.this.rotation.w;
            }
        };
    }

    @Override
    public boolean isIdentity() {
        return this.rotation.w == 1.0;
    }

    public String toString() {
        Vector3d vector3d = this.getAxis();
        double d = this.getAngle();
        return String.format("Rotate: %s %s deg", vector3d, Double.toString(Math.toDegrees(d)));
    }
}

