/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;

public class MirrorXform
implements ITransform,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Plane3d plane;

    public MirrorXform(Plane3d plane3d) {
        this.plane = plane3d;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof MirrorXform && ((MirrorXform)object).plane.equals(this.plane);
    }

    public int hashCode() {
        return 0x13BEA8F ^ this.plane.hashCode();
    }

    @Override
    public Matrix4d toMatrix(boolean bl) {
        double d = 2.0 * this.plane.x;
        double d2 = 2.0 * this.plane.y;
        double d3 = 2.0 * this.plane.z;
        return new Matrix4d(1.0 - d * this.plane.x, -d * this.plane.y, -d * this.plane.z, -d * this.plane.w, -d2 * this.plane.x, 1.0 - d2 * this.plane.y, -d2 * this.plane.z, -d2 * this.plane.w, -d3 * this.plane.x, -d3 * this.plane.y, 1.0 - d3 * this.plane.z, -d3 * this.plane.w, 0.0, 0.0, 0.0, 1.0);
    }

    @Override
    public ITransform concatenate(ITransform iTransform) {
        if (iTransform instanceof MirrorXform) {
            MirrorXform mirrorXform = (MirrorXform)iTransform;
            if (mirrorXform.plane.equals(this.plane)) {
                return IdentityXform.INSTANCE;
            }
        }
        return ITransform.super.concatenate(iTransform);
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        return this;
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    public String toString() {
        return String.format("Mirror: (%s, %s, %s, %s)", Double.toString(this.plane.x), Double.toString(this.plane.y), Double.toString(this.plane.z), Double.toString(this.plane.w));
    }
}

