/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.Intl;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;

public class MatrixXform
implements ITransform {
    static final long serialVersionUID = 1L;
    public final Matrix4d xform;

    public MatrixXform(Matrix4d matrix4d) {
        this.xform = matrix4d;
    }

    @Override
    public Matrix4d toMatrix(boolean bl) {
        if (!bl) {
            return this.xform;
        }
        return new Matrix4d(this.xform);
    }

    @Override
    public ITransform concatenate(ITransform iTransform) {
        if (iTransform instanceof MatrixXform) {
            Matrix4d matrix4d = this.toMatrix(true);
            matrix4d.mul(((MatrixXform)iTransform).xform);
            return new MatrixXform(matrix4d);
        }
        return ITransform.super.concatenate(iTransform);
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        Matrix4d matrix4d = this.toMatrix(true);
        try {
            matrix4d.invert();
        }
        catch (Throwable throwable) {
            throw new NoninvertibleTransformException(Intl.intl("Non-invertible transform matrix."));
        }
        return new MatrixXform(matrix4d);
    }

    @Override
    public boolean isInvertible() {
        try {
            this.invert();
            return true;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return false;
        }
    }

    @Override
    public ITransform optimize() {
        if (this.isIdentity()) {
            return IdentityXform.INSTANCE;
        }
        return ITransform.super.optimize();
    }

    @Override
    public ITransform.ITransformer getTransformer() {
        return new ITransform.ITransformer(){

            @Override
            public void transform(Point3d point3d) {
                MatrixXform.this.xform.transform(point3d);
            }

            @Override
            public void transform(Vector3d vector3d) {
                MatrixXform.this.xform.transform(vector3d);
            }
        };
    }

    @Override
    public boolean isIdentity() {
        return this.xform.equals(GeomConstants.IDENTITY4d);
    }

    public String toString() {
        return String.format("Matrix: %s", this.xform.toString());
    }
}

