/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.objs.transform.ConcatTransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;

public interface ITransform
extends Serializable {
    public Matrix4d toMatrix(boolean var1);

    default public ITransform concatenate(ITransform iTransform) {
        if (iTransform.isIdentity()) {
            return this;
        }
        return new ConcatTransform(this, iTransform);
    }

    default public ITransform optimize() {
        return this;
    }

    default public ITransformer getTransformer() {
        final Matrix4d matrix4d = this.toMatrix(false);
        return new ITransformer(){

            @Override
            public void transform(Point3d point3d) {
                matrix4d.transform(point3d);
            }

            @Override
            public void transform(Vector3d vector3d) {
                matrix4d.transform(vector3d);
            }
        };
    }

    public boolean isIdentity();

    public ITransform invert() throws NoninvertibleTransformException;

    public boolean isInvertible();

    default public TransformInfo getInfo() {
        return new TransformInfo(this);
    }

    public static interface ITransformer {
        default public void transform(Point3d ... point3dArray) {
            for (Point3d point3d : point3dArray) {
                this.transform(point3d);
            }
        }

        public void transform(Point3d var1);

        default public void transform(Vector3d ... vector3dArray) {
            for (Vector3d vector3d : vector3dArray) {
                this.transform(vector3d);
            }
        }

        public void transform(Vector3d var1);
    }
}

