/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.transform;

import java.awt.geom.NoninvertibleTransformException;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.objs.transform.ITransform;

public class ConcatTransform
implements ITransform {
    static final long serialVersionUID = 1L;
    public final ITransform left;
    public final ITransform right;

    public ConcatTransform(ITransform iTransform, ITransform iTransform2) {
        this.left = iTransform;
        this.right = iTransform2;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof ConcatTransform && ((ConcatTransform)object).left.equals(this.left) && ((ConcatTransform)object).right.equals(this.right);
    }

    public int hashCode() {
        return 0xB89B23FA ^ this.left.hashCode() + this.right.hashCode();
    }

    @Override
    public Matrix4d toMatrix(boolean bl) {
        Matrix4d matrix4d = this.left.toMatrix(true);
        matrix4d.mul(this.right.toMatrix(false));
        return matrix4d;
    }

    @Override
    public ITransform invert() throws NoninvertibleTransformException {
        return new ConcatTransform(this.right.invert(), this.left.invert());
    }

    @Override
    public boolean isInvertible() {
        return this.left.isInvertible() && this.right.isInvertible();
    }

    @Override
    public ITransform optimize() {
        ITransform iTransform = this.left.optimize();
        ITransform iTransform2 = this.right.optimize();
        return iTransform.concatenate(iTransform2);
    }

    @Override
    public ITransform.ITransformer getTransformer() {
        final ITransform.ITransformer iTransformer = this.right.getTransformer();
        final ITransform.ITransformer iTransformer2 = this.left.getTransformer();
        return new ITransform.ITransformer(){

            @Override
            public void transform(Point3d point3d) {
                iTransformer.transform(point3d);
                iTransformer2.transform(point3d);
            }

            @Override
            public void transform(Vector3d vector3d) {
                iTransformer.transform(vector3d);
                iTransformer2.transform(vector3d);
            }
        };
    }

    @Override
    public boolean isIdentity() {
        return this.left.isIdentity() && this.right.isIdentity();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.left.toString());
        stringBuilder.append(" <- ");
        stringBuilder.append(this.right.toString());
        return stringBuilder.toString();
    }
}

