/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.node;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.MappedIterator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TriFunction;

public interface IGeomNode {
    public static final int OPT_FLATTEN_GEOM_GROUPS = 1;
    public static final int OPT_EXCLUDE_ROOT_XFORM = 2;

    public ITransform getLocalTransform();

    public IGeom getLocalGeom();

    public IPropertySet getLocalElements();

    public Collection<? extends IGeomNode> getChildren();

    default public IGeomNode transform(TransformInfo transformInfo) {
        ITransform iTransform = this.getLocalTransform();
        ITransform iTransform2 = transformInfo.xform.concatenate(iTransform);
        if (iTransform2 == iTransform) {
            return this;
        }
        IGeomNode iGeomNode = GeomNodeUtil.bakeIfRecommended(transformInfo, this);
        if (iGeomNode != this) {
            return iGeomNode;
        }
        return GeomNodeUtil.newNode(iTransform2, this.getLocalGeom(), this.getLocalElements(), this.getChildren());
    }

    default public IGeomNode quickTransform(TransformInfo transformInfo) {
        ITransform iTransform = this.getLocalTransform();
        ITransform iTransform2 = transformInfo.xform.concatenate(iTransform);
        if (iTransform2 == iTransform) {
            return this;
        }
        return GeomNodeUtil.newNode(iTransform2, this.getLocalGeom(), this.getLocalElements(), this.getChildren());
    }

    default public IGeomNode applyLocalGeom(IGeom iGeom) {
        if (iGeom == this.getLocalGeom()) {
            return this;
        }
        return GeomNodeUtil.newNode(this.getLocalTransform(), iGeom, this.getLocalElements(), this.getChildren());
    }

    default public IGeomNode applyLocalTransform(ITransform iTransform) {
        if (iTransform == this.getLocalTransform()) {
            return this;
        }
        return GeomNodeUtil.newNode(iTransform, this.getLocalGeom(), this.getLocalElements(), this.getChildren());
    }

    default public IGeomNode applyLocalElements(IPropertySet iPropertySet) {
        if (iPropertySet == this.getLocalElements()) {
            return this;
        }
        return GeomNodeUtil.newNode(this.getLocalTransform(), this.getLocalGeom(), iPropertySet, this.getChildren());
    }

    default public AABox getBoundingBox(AABox aABox) {
        TransformInfo transformInfo = this.getLocalTransform().getInfo();
        AABox aABox2 = GeomUtil.getBoundsTransformer(transformInfo, aABox);
        this.getLocalGeom().getBoundingBox(aABox2);
        for (IGeomNode iGeomNode : this.getChildren()) {
            iGeomNode.getBoundingBox(aABox2);
        }
        return aABox;
    }

    default public IGeomNode flatten(int n) {
        return GeomNodeUtil.flatten(this, n);
    }

    default public IGeomNode flatten() {
        return this.flatten(0);
    }

    default public IGeomNode bakeIfRecommended() {
        return GeomNodeUtil.bakeIfRecommended(TransformUtil.IDENTITY_INFO, this);
    }

    default public List<Pair<TransformInfo, IGeom>> quickFlatten(int n) {
        return GeomNodeUtil.quickFlatten(this, n);
    }

    default public List<Pair<TransformInfo, IGeom>> quickFlatten() {
        return this.quickFlatten(0);
    }

    default public <T> IElemSource<T> getElements(Elements.ElemProp<T> elemProp) {
        return (IElemSource)this.getLocalElements().get(elemProp);
    }

    default public int getNumPrims(int n) {
        int n2 = this.getLocalGeom().getNumPrims(n);
        for (IGeomNode iGeomNode : this.getChildren()) {
            n2 += iGeomNode.getNumPrims(n);
        }
        return n2;
    }

    default public IDOF getDOF() {
        return GeomNodeUtil.getDOF(this);
    }

    default public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    default public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        GeomNodeUtil.pickPoints(this, iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
    }

    @Deprecated
    default public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        return false;
    }

    default public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        GeomNodeUtil.pickBox(this, object, iIsectFilter, convexHull, iBoxCollector);
    }

    default public <T> IGeomNode applyElements(Elements.ElemProp<T> elemProp, BiFunction<Integer, IElemSource<T>, IElemSource<T>> biFunction) {
        return GeomNodeUtil.applyElements(elemProp, this, biFunction);
    }

    default public IGeomNode applyUVElements(String string, BiFunction<Integer, IElemSource<Point2d>, IElemSource<Point2d>> biFunction) {
        return GeomNodeUtil.applyUVElements(string, this, biFunction);
    }

    default public IGeomNode initUVElements(IElemSource<Point2d> iElemSource) {
        return this.applyUniformProp(Elements.UV, Collections.singletonMap("teciuv0x193fa", iElemSource));
    }

    default public IGeomNode applyDefaultUVElements(IElemSource<Point2d> iElemSource) {
        return this.applyDefaultUVElements(() -> iElemSource);
    }

    default public IGeomNode applyDefaultUVElements(Supplier<IElemSource<Point2d>> supplier) {
        return this.applyProp(Elements.UV, (iGeomNode, map) -> {
            if (map.isEmpty()) {
                return Collections.singletonMap("teciuv0x193fa", supplier.get());
            }
            ListMap listMap = new ListMap(map);
            listMap.put("teciuv0x193fa", supplier.get());
            return listMap;
        });
    }

    default public IGeomNode applyUVElements(TriFunction<String, Integer, IElemSource<Point2d>, IElemSource<Point2d>> triFunction) {
        return GeomNodeUtil.applyUVElements(this, triFunction);
    }

    default public <T> IGeomNode applyProp(IPropertySet.Prop<T> prop, BiFunction<IGeomNode, T, T> biFunction) {
        return GeomNodeUtil.applyProp(prop, this, biFunction);
    }

    default public <T> IGeomNode applyUniformProp(IPropertySet.Prop<T> prop, T t) {
        return GeomNodeUtil.applyUniformProp(prop, this, t);
    }

    default public <T> IGeomNode prune() {
        return GeomNodeUtil.prune(this);
    }

    default public void find(ITest<AABox> iTest, IResult<? super IPrimitive> iResult) {
        GeomNodeUtil.find(this, iTest, iResult);
    }

    default public void getAll(IResult<? super IPrimitive> iResult) {
        GeomNodeUtil.getAll(this, iResult);
    }

    default public IGeomNode modify(Function<IGeom, IGeom> function, Function<IPropertySet, IPropertySet> function2) {
        return GeomNodeUtil.modify(this, function, function2);
    }

    default public Iterator<IGeomNode> flatIterator() {
        return new GeomNodeUtil.FlatIterator(this);
    }

    default public Iterator<IGeom> flatGeomIterator() {
        return new MappedIterator<IGeomNode, IGeom>(this.flatIterator(), iGeomNode -> iGeomNode.getLocalGeom());
    }

    default public Iterator<IPropertySet> flatElemIterator() {
        return new MappedIterator<IGeomNode, IPropertySet>(this.flatIterator(), iGeomNode -> iGeomNode.getLocalElements());
    }

    default public <T> Iterator<IElemSource<T>> flatElemIterator(Elements.ElemProp<T> elemProp) {
        return new MappedIterator<IGeomNode, IElemSource>(this.flatIterator(), iGeomNode -> iGeomNode.getElements(elemProp));
    }

    default public Iterator<Map<String, IElemSource<Point2d>>> flatUVIterator() {
        return new MappedIterator<IGeomNode, Map>(this.flatIterator(), iGeomNode -> iGeomNode.getLocalElements().get(Elements.UV));
    }

    default public Iterator<IElemSource<Point2d>> flatUVIterator(String string) {
        return new MappedIterator<IGeomNode, IElemSource>(this.flatIterator(), iGeomNode -> iGeomNode.getLocalElements().get(Elements.UV).getOrDefault(string, Elements.NO_UV));
    }

    default public Iterator<ITransform> flatTransformIterator() {
        return new MappedIterator<IGeomNode, ITransform>(this.flatIterator(), iGeomNode -> iGeomNode.getLocalTransform());
    }
}

