/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.node;

import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeGroup;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CachedSupplier;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.TriFunction;

public class GeomNodeUtil {
    public static final IGeomNode EMPTY_NODE = new GeomNodeLeaf(TransformUtil.IDENTITY, EmptyGeom.INSTANCE, Elements.NONE);

    public static GeomNodeLeaf newNode(IGeom iGeom) {
        return (GeomNodeLeaf)GeomNodeUtil.newNode(TransformUtil.IDENTITY, iGeom, Elements.NONE, Collections.emptyList());
    }

    public static GeomNodeLeaf newNode(ITransform iTransform, IGeom iGeom) {
        return (GeomNodeLeaf)GeomNodeUtil.newNode(iTransform, iGeom, Elements.NONE, Collections.emptyList());
    }

    public static GeomNodeLeaf newNode(ITransform iTransform, IGeom iGeom, IPropertySet iPropertySet) {
        return (GeomNodeLeaf)GeomNodeUtil.newNode(iTransform, iGeom, iPropertySet, Collections.emptyList());
    }

    public static GeomNodeLeaf newNode(IGeom iGeom, IPropertySet iPropertySet) {
        return (GeomNodeLeaf)GeomNodeUtil.newNode(TransformUtil.IDENTITY, iGeom, iPropertySet, Collections.emptyList());
    }

    public static GeomNodeGroup newNode(ITransform iTransform, Collection<? extends IGeomNode> collection) {
        return (GeomNodeGroup)GeomNodeUtil.newNode(iTransform, EmptyGeom.INSTANCE, Elements.NONE, collection);
    }

    public static GeomNodeGroup newNode(Collection<? extends IGeomNode> collection) {
        return (GeomNodeGroup)GeomNodeUtil.newNode(TransformUtil.IDENTITY, EmptyGeom.INSTANCE, Elements.NONE, collection);
    }

    public static IGeomNode newNode(ITransform iTransform, IGeom iGeom, IPropertySet iPropertySet, Collection<? extends IGeomNode> collection) {
        if (collection.isEmpty()) {
            if (iGeom == EmptyGeom.INSTANCE) {
                return EMPTY_NODE;
            }
            return new GeomNodeLeaf(iTransform, iGeom, iPropertySet);
        }
        return new GeomNodeGroup(iTransform, iGeom, iPropertySet, collection);
    }

    public static IGeomNode flatten(IGeomNode iGeomNode, int n) {
        boolean bl;
        boolean bl2 = bl = !GeomNodeUtil.test(n, 2);
        if (iGeomNode.getChildren().isEmpty() && (!bl || iGeomNode.getLocalTransform().isIdentity())) {
            return iGeomNode;
        }
        TransformInfo transformInfo = bl ? iGeomNode.getLocalTransform().getInfo() : TransformUtil.IDENTITY_INFO;
        int n2 = 1;
        if (iGeomNode.getChildren().isEmpty()) {
            IGeom iGeom = iGeomNode.getLocalGeom().transform(transformInfo, n2);
            IPropertySet iPropertySet = Elements.transform(iGeomNode.getLocalElements(), transformInfo);
            return GeomNodeUtil.newNode(iGeom, iPropertySet);
        }
        ArrayList<IGeom> arrayList = new ArrayList<IGeom>();
        ElementsBuilder elementsBuilder = new ElementsBuilder();
        GeomNodeUtil.flatten(transformInfo, iGeomNode, arrayList, elementsBuilder, n2);
        IGeom iGeom = GeomUtil.group(arrayList);
        IPropertySet iPropertySet = elementsBuilder.finish();
        ITransform iTransform = bl ? TransformUtil.IDENTITY : transformInfo.xform;
        return GeomNodeUtil.newNode(iTransform, iGeom, iPropertySet, Collections.emptyList());
    }

    private static void flatten(TransformInfo transformInfo, IGeomNode iGeomNode, List<IGeom> list, ElementsBuilder elementsBuilder, int n) {
        IGeom iGeom = iGeomNode.getLocalGeom();
        if (iGeom != EmptyGeom.INSTANCE && (iGeom = iGeom.transform(transformInfo, n)) != EmptyGeom.INSTANCE) {
            list.add(iGeom);
            int n2 = iGeom.getNumPrims(7);
            elementsBuilder.add(iGeomNode.getLocalElements(), n2);
        }
        for (IGeomNode iGeomNode2 : iGeomNode.getChildren()) {
            TransformInfo transformInfo2 = transformInfo.concatenate(iGeomNode2.getLocalTransform());
            GeomNodeUtil.flatten(transformInfo2, iGeomNode2, list, elementsBuilder, n);
        }
    }

    public static void pickBox(IGeomNode iGeomNode, Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, final IBoxCollector iBoxCollector) throws CancelledException {
        IBoxCollector iBoxCollector2;
        UnaryOperator unaryOperator;
        Object object2;
        ITransform iTransform = iGeomNode.getLocalTransform();
        if (!iTransform.isIdentity()) {
            try {
                object2 = iTransform.invert();
                convexHull = convexHull.transform(object2.toMatrix(false));
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
                return;
            }
            unaryOperator = supplier -> {
                Matrix4d matrix4d = iTransform.toMatrix(false);
                return () -> GeomNodeUtil.lambda$null$697((Supplier)supplier, matrix4d);
            };
            iBoxCollector2 = new IBoxCollector(){

                @Override
                public void addFace(Object object, int n, Supplier<Pair<Point3d, Vector3d>> supplier) throws CancelledException {
                    iBoxCollector.addFace(object, n, (Supplier)unaryOperator.apply(supplier));
                }

                @Override
                public void addNonFace(Object object) throws CancelledException {
                    iBoxCollector.addNonFace(object);
                }
            };
        } else {
            unaryOperator = supplier -> supplier;
            iBoxCollector2 = iBoxCollector;
        }
        object2 = iGeomNode.getElements(Elements.ORIENT);
        IBoxCollector iBoxCollector3 = new IBoxCollector((IElemSource)object2, iBoxCollector2){
            final /* synthetic */ IElemSource val$orients;
            final /* synthetic */ IBoxCollector val$xformedIsects;
            {
                this.val$orients = iElemSource;
                this.val$xformedIsects = iBoxCollector;
            }

            @Override
            public void addFace(Object object, int n, Supplier<Pair<Point3d, Vector3d>> supplier) throws CancelledException {
                Supplier<Pair<Point3d, Vector3d>> supplier2 = () -> {
                    Pair pair = (Pair)supplier.get();
                    Elements.Orient orient = (Elements.Orient)((Object)((Object)this.val$orients.getPrimElement(n)));
                    if (orient == Elements.Orient.CW) {
                        return new Pair(pair.v1, Util3D.negate((Vector3d)pair.v2));
                    }
                    return pair;
                };
                this.val$xformedIsects.addFace(object, n, supplier2);
            }

            @Override
            public void addNonFace(Object object) throws CancelledException {
                this.val$xformedIsects.addNonFace(object);
            }
        };
        iGeomNode.getLocalGeom().pickBox(object, iIsectFilter, convexHull, iBoxCollector3);
        Collection<? extends IGeomNode> collection = iGeomNode.getChildren();
        if (collection.isEmpty()) {
            return;
        }
        int n = iGeomNode.getLocalGeom().getNumPrims(7);
        for (IGeomNode iGeomNode2 : collection) {
            final int n2 = n;
            IBoxCollector iBoxCollector4 = new IBoxCollector(){

                @Override
                public void addFace(Object object, int n, Supplier<Pair<Point3d, Vector3d>> supplier) throws CancelledException {
                    iBoxCollector.addFace(object, n2 + n, (Supplier)unaryOperator.apply(supplier));
                }

                @Override
                public void addNonFace(Object object) throws CancelledException {
                    iBoxCollector.addNonFace(object);
                }
            };
            GeomNodeUtil.pickBox(iGeomNode2, object, iIsectFilter, convexHull, iBoxCollector4);
            n += iGeomNode2.getNumPrims(7);
        }
    }

    public static void pickPoints(IGeomNode iGeomNode, IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> xformTester) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        ITransform iTransform = iGeomNode.getLocalTransform();
        if (!iTransform.isIdentity()) {
            IIsectCollector iIsectCollector2;
            try {
                object5 = iTransform.invert().toMatrix(false);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
                return;
            }
            point3d = Util3D.xform((Matrix4d)object5, point3d);
            point3d2 = Util3D.xform((Matrix4d)object5, point3d2);
            vector3d = Util3D.xform((Matrix4d)object5, vector3d);
            vector3d.normalize();
            object4 = iGeomNode.getLocalTransform().getInfo();
            object3 = ((TransformInfo)object4).getMatrix();
            object2 = iIsectCollector;
            iIsectCollector = iIsectCollector2 = new IIsectCollector((Matrix4d)object3, (IIsectCollector)object2, (TransformInfo)object4){
                final /* synthetic */ Matrix4d val$mat;
                final /* synthetic */ IIsectCollector val$baseIsects;
                final /* synthetic */ TransformInfo val$xform;
                {
                    this.val$mat = matrix4d;
                    this.val$baseIsects = iIsectCollector;
                    this.val$xform = transformInfo;
                }

                @Override
                public void addNonFace(Object object, Point3d point3d, GeomType geomType) {
                    point3d = Util3D.xform(this.val$mat, point3d);
                    this.val$baseIsects.addNonFace(object, point3d, geomType);
                }

                @Override
                public void addFace(Object object, Point3d point3d, int n, Supplier<IFace> supplier, Supplier<Vector3d> supplier2) {
                    point3d = Util3D.xform(this.val$mat, point3d);
                    Supplier<Vector3d> supplier3 = () -> Util3D.xform(this.val$mat, (Vector3d)supplier2.get());
                    Supplier<IFace> supplier4 = supplier == null ? null : () -> ((IFace)supplier.get()).transform(this.val$xform, 0);
                    this.val$baseIsects.addFace(object, point3d, n, supplier4, supplier3);
                }

                @Override
                public void addInfinite(Object object, Point3d point3d, GeomType geomType, IPrimitive iPrimitive) {
                    point3d = Util3D.xform(this.val$mat, point3d);
                    iPrimitive = iPrimitive.transform(this.val$xform, 0);
                    this.val$baseIsects.addInfinite(object, point3d, geomType, iPrimitive);
                }

                @Override
                public TaskProgress getProgress() {
                    return this.val$baseIsects.getProgress();
                }
            };
            xformTester = new XformTester(xformTester, (TransformInfo)object4);
        }
        object5 = iGeomNode.getElements(Elements.ORIENT);
        object4 = iIsectCollector;
        object3 = new IIsectCollector((IIsectCollector)object4, (IElemSource)object5){
            final /* synthetic */ IIsectCollector val$baseIsects;
            final /* synthetic */ IElemSource val$orients;
            {
                this.val$baseIsects = iIsectCollector;
                this.val$orients = iElemSource;
            }

            @Override
            public void addNonFace(Object object, Point3d point3d, GeomType geomType) {
                this.val$baseIsects.addNonFace(object, point3d, geomType);
            }

            @Override
            public void addFace(Object object, Point3d point3d, int n, Supplier<IFace> supplier, Supplier<Vector3d> supplier2) {
                Supplier<Vector3d> supplier3 = () -> {
                    Vector3d vector3d = (Vector3d)supplier2.get();
                    Elements.Orient orient = (Elements.Orient)((Object)((Object)this.val$orients.getPrimElement(n)));
                    if (orient == Elements.Orient.CW) {
                        vector3d = Util3D.negate(vector3d);
                    }
                    return vector3d;
                };
                CachedSupplier<IFace> cachedSupplier = supplier == null ? null : () -> {
                    IFace iFace = (IFace)supplier.get();
                    Elements.Orient orient = (Elements.Orient)((Object)((Object)this.val$orients.getPrimElement(n)));
                    if (orient == Elements.Orient.CW) {
                        iFace = iFace.flipOrient();
                    }
                    return iFace;
                };
                cachedSupplier = cachedSupplier == null ? null : new CachedSupplier<IFace>(cachedSupplier);
                this.val$baseIsects.addFace(object, point3d, n, cachedSupplier, supplier3);
            }

            @Override
            public void addInfinite(Object object, Point3d point3d, GeomType geomType, IPrimitive iPrimitive) {
                this.val$baseIsects.addInfinite(object, point3d, geomType, iPrimitive);
            }

            @Override
            public TaskProgress getProgress() {
                return this.val$baseIsects.getProgress();
            }
        };
        iIsectCollector = object3;
        iGeomNode.getLocalGeom().pickPoints(iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, xformTester);
        object2 = iGeomNode.getChildren();
        if (object2.isEmpty()) {
            return;
        }
        int n = iGeomNode.getLocalGeom().getNumPrims(7);
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            IGeomNode iGeomNode2 = (IGeomNode)iterator.next();
            final IIsectCollector iIsectCollector3 = iIsectCollector;
            final int n2 = n;
            IIsectCollector iIsectCollector4 = new IIsectCollector(){

                @Override
                public void addNonFace(Object object, Point3d point3d, GeomType geomType) {
                    iIsectCollector3.addNonFace(object, point3d, geomType);
                }

                @Override
                public void addFace(Object object, Point3d point3d, int n, Supplier<IFace> supplier, Supplier<Vector3d> supplier2) {
                    iIsectCollector3.addFace(object, point3d, n2 + n, supplier, supplier2);
                }

                @Override
                public void addInfinite(Object object, Point3d point3d, GeomType geomType, IPrimitive iPrimitive) {
                    iIsectCollector3.addInfinite(object, point3d, geomType, iPrimitive);
                }

                @Override
                public TaskProgress getProgress() {
                    return iIsectCollector3.getProgress();
                }
            };
            GeomNodeUtil.pickPoints(iGeomNode2, iIsectCollector4, iIsectFilter, object, point3d, point3d2, vector3d, xformTester);
            n += iGeomNode2.getNumPrims(7);
        }
    }

    public static IDOF getDOF(IGeomNode iGeomNode) {
        LinkedHashSet<IDOF> linkedHashSet = new LinkedHashSet<IDOF>();
        GeomNodeUtil.getDOF(iGeomNode, linkedHashSet);
        return IDOF.group(linkedHashSet);
    }

    private static void getDOF(IGeomNode iGeomNode, Set<IDOF> set) {
        set.add(iGeomNode.getLocalGeom().getDOF());
        for (IGeomNode iGeomNode2 : iGeomNode.getChildren()) {
            GeomNodeUtil.getDOF(iGeomNode2, set);
        }
    }

    public static <T> IGeomNode applyUniformProp(IPropertySet.Prop<T> prop, IGeomNode iGeomNode2, T t) {
        BiFunction<IGeomNode, Object, Object> biFunction = (iGeomNode, object2) -> t;
        return GeomNodeUtil.applyProp(prop, iGeomNode2, biFunction);
    }

    public static <T> IGeomNode applyProp(IPropertySet.Prop<T> prop, IGeomNode iGeomNode, BiFunction<IGeomNode, T, T> biFunction) {
        boolean bl;
        T t;
        Object object;
        IPropertySet iPropertySet;
        IPropertySet iPropertySet2 = iPropertySet = iGeomNode.getLocalElements();
        if (iGeomNode.getLocalGeom() != EmptyGeom.INSTANCE && !Objects.equals(object = biFunction.apply(iGeomNode, (IGeomNode)(t = iPropertySet2.get(prop))), t)) {
            iPropertySet2 = Elements.copyOf(iGeomNode.getLocalElements());
            iPropertySet2.setIfNotDefault(prop, object);
            iPropertySet2 = Elements.finalizeElements(iPropertySet2);
        }
        boolean bl2 = iPropertySet2 != iPropertySet;
        iPropertySet = iPropertySet2;
        object = iGeomNode.getChildren();
        ArrayList<IGeomNode> arrayList = null;
        int n = 0;
        for (IGeomNode iGeomNode2 : iGeomNode.getChildren()) {
            IGeomNode iGeomNode3 = GeomNodeUtil.applyProp(prop, iGeomNode2, biFunction);
            if (iGeomNode3 != iGeomNode2) {
                if (arrayList == null) {
                    arrayList = new ArrayList<IGeomNode>((Collection<IGeomNode>)object);
                }
                arrayList.set(n, iGeomNode3);
            }
            ++n;
        }
        boolean bl3 = bl = arrayList != null;
        if (bl) {
            object = arrayList;
        }
        if (!bl2 && !bl) {
            return iGeomNode;
        }
        return GeomNodeUtil.newNode(iGeomNode.getLocalTransform(), iGeomNode.getLocalGeom(), iPropertySet, (Collection<? extends IGeomNode>)object);
    }

    public static <T> IGeomNode applyElements(Elements.ElemProp<T> elemProp, IGeomNode iGeomNode2, BiFunction<Integer, IElemSource<T>, IElemSource<T>> biFunction) {
        return GeomNodeUtil.applyElements((IElemSource)elemProp.defVal, iGeomNode -> (IElemSource)iGeomNode.getLocalElements().get(elemProp), (iGeomNode, iPropertySet, iElemSource) -> iPropertySet.setIfNotDefault(elemProp, iElemSource), iGeomNode2, biFunction);
    }

    public static IGeomNode applyUVElements(IGeomNode iGeomNode2, TriFunction<String, Integer, IElemSource<Point2d>, IElemSource<Point2d>> triFunction) {
        int[] nArray = new int[]{0};
        return GeomNodeUtil.applyProp(Elements.UV, iGeomNode2, (iGeomNode, map) -> {
            ListMap<String, IElemSource<Point2d>> listMap = null;
            int n2 = iGeomNode.getLocalGeom().getNumPrims(7);
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                IElemSource<Point2d> iElemSource2 = Elements.replaceElements(n2, (IElemSource)entry.getValue(), Elements.NO_UV, (n, iElemSource) -> (IElemSource)triFunction.apply(string, nArray[0] + n, (IElemSource<Point2d>)iElemSource));
                if (iElemSource2 == entry.getValue()) continue;
                if (listMap == null) {
                    listMap = new ListMap<String, IElemSource<Point2d>>((Map<String, IElemSource<Point2d>>)map);
                }
                listMap.put(string, iElemSource2);
            }
            nArray[0] = nArray[0] + n2;
            return listMap == null ? map : listMap;
        });
    }

    public static IGeomNode applyUVElements(String string, IGeomNode iGeomNode2, BiFunction<Integer, IElemSource<Point2d>, IElemSource<Point2d>> biFunction) {
        return GeomNodeUtil.applyElements(Elements.NO_UV, iGeomNode -> {
            IElemSource<Point2d> iElemSource = iGeomNode.getLocalElements().get(Elements.UV).get(string);
            return iElemSource != null ? iElemSource : Elements.NO_UV;
        }, (iGeomNode, iPropertySet, iElemSource) -> {
            ListMap<String, IElemSource<Point2d>> listMap = new ListMap<String, IElemSource<Point2d>>(iGeomNode.getLocalElements().get(Elements.UV));
            if (iElemSource != Elements.NO_UV) {
                listMap.put(string, (IElemSource<Point2d>)iElemSource);
            } else {
                listMap.remove(string);
            }
            iPropertySet.setIfNotDefault(Elements.UV, listMap);
        }, iGeomNode2, biFunction);
    }

    private static <T> IGeomNode applyElements(IElemSource<T> iElemSource, Function<IGeomNode, IElemSource<T>> function, TriConsumer<IGeomNode, IPropertySet, IElemSource<T>> triConsumer, IGeomNode iGeomNode, BiFunction<Integer, IElemSource<T>, IElemSource<T>> biFunction) {
        boolean bl;
        IElemSource<T> iElemSource2;
        Object object;
        IPropertySet iPropertySet = iGeomNode.getLocalElements();
        boolean bl2 = false;
        IGeom iGeom = iGeomNode.getLocalGeom();
        int n = iGeom.getNumPrims(7);
        if (n > 0 && (object = Elements.replaceElements(n, iElemSource2 = function.apply(iGeomNode), iElemSource, biFunction)) != iElemSource2) {
            bl2 = true;
            iPropertySet = GeomNodeUtil.applyElementsVal(triConsumer, iGeomNode, iPropertySet, object);
        }
        int n2 = n;
        object = null;
        int n3 = 0;
        Object object2 = iGeomNode.getChildren();
        Iterator<? extends IGeomNode> iterator = object2.iterator();
        while (iterator.hasNext()) {
            int n4;
            IGeomNode iGeomNode2 = iterator.next();
            IGeomNode iGeomNode3 = GeomNodeUtil.applyElements(iElemSource, function, triConsumer, iGeomNode2, (arg_0, arg_1) -> GeomNodeUtil.lambda$applyElements$712(biFunction, n4 = n2, arg_0, arg_1));
            if (iGeomNode3 != iGeomNode2 || object != null) {
                if (object == null) {
                    object = new ArrayList(object2.size());
                    Iterator iterator2 = object2.iterator();
                    for (int i = 0; i < n3; ++i) {
                        ((ArrayList)object).add(iterator2.next());
                    }
                }
                ((ArrayList)object).add((IGeomNode)iGeomNode3);
            }
            n2 += iGeomNode2.getNumPrims(7);
            ++n3;
        }
        boolean bl3 = bl = object != null;
        if (!bl2 && !bl) {
            return iGeomNode;
        }
        if (bl) {
            object2 = object;
        }
        return GeomNodeUtil.newNode(iGeomNode.getLocalTransform(), iGeomNode.getLocalGeom(), iPropertySet, (Collection<? extends IGeomNode>)object2);
    }

    private static <T> IPropertySet applyElementsVal(TriConsumer<IGeomNode, IPropertySet, T> triConsumer, IGeomNode iGeomNode, IPropertySet iPropertySet, T t) {
        iPropertySet = Elements.copyOf(iPropertySet);
        triConsumer.accept(iGeomNode, iPropertySet, t);
        return Elements.finalizeElements(iPropertySet);
    }

    public static IGeomNode prune(IGeomNode iGeomNode) {
        if (iGeomNode == EMPTY_NODE) {
            return iGeomNode;
        }
        boolean bl = false;
        ArrayList<IGeomNode> arrayList = new ArrayList<IGeomNode>(iGeomNode.getChildren().size());
        for (IGeomNode iGeomNode2 : iGeomNode.getChildren()) {
            IGeomNode iGeomNode3 = GeomNodeUtil.prune(iGeomNode2);
            if (iGeomNode3 == EMPTY_NODE) {
                bl = true;
                continue;
            }
            bl |= iGeomNode3 != iGeomNode2;
            arrayList.add(iGeomNode3);
        }
        if (!bl) {
            return iGeomNode;
        }
        if (iGeomNode.getLocalGeom() == EmptyGeom.INSTANCE && arrayList.size() == 1) {
            TransformInfo transformInfo = iGeomNode.getLocalTransform().getInfo();
            IGeomNode iGeomNode4 = (IGeomNode)arrayList.get(0);
            return iGeomNode4.transform(transformInfo);
        }
        return GeomNodeUtil.newNode(iGeomNode.getLocalTransform(), iGeomNode.getLocalGeom(), iGeomNode.getLocalElements(), arrayList);
    }

    public static void find(IGeomNode iGeomNode, ITest<AABox> xformTester, IResult<? super IPrimitive> xformResult) {
        ITransform iTransform = iGeomNode.getLocalTransform();
        if (!iTransform.isIdentity()) {
            TransformInfo transformInfo = iGeomNode.getLocalTransform().getInfo();
            xformTester = new XformTester(xformTester, transformInfo);
            xformResult = new XformResult(xformResult, transformInfo);
        }
        iGeomNode.getLocalGeom().find(xformTester, xformResult);
        for (IGeomNode iGeomNode2 : iGeomNode.getChildren()) {
            iGeomNode2.find(xformTester, xformResult);
        }
    }

    public static void getAll(IGeomNode iGeomNode, IResult<? super IPrimitive> iResult) {
        iGeomNode.flatten().getLocalGeom().getAll(iResult);
    }

    public static IGeomNode modify(IGeomNode iGeomNode, Function<IGeom, IGeom> function, Function<IPropertySet, IPropertySet> function2) {
        IGeom iGeom = iGeomNode.getLocalGeom();
        IPropertySet iPropertySet = iGeomNode.getLocalElements();
        IGeom iGeom2 = function.apply(iGeom);
        IPropertySet iPropertySet2 = function2.apply(iPropertySet);
        Collection<? extends IGeomNode> collection = iGeomNode.getChildren();
        ArrayList<IGeomNode> arrayList = null;
        int n = 0;
        for (IGeomNode iGeomNode2 : collection) {
            IGeomNode iGeomNode3;
            if (iGeomNode2 != (iGeomNode3 = iGeomNode2.modify(function, function2)) || arrayList != null) {
                if (arrayList == null) {
                    arrayList = new ArrayList<IGeomNode>(collection.size());
                    Iterator<? extends IGeomNode> iterator = collection.iterator();
                    for (int i = 0; i < n; ++i) {
                        arrayList.add(iterator.next());
                    }
                }
                arrayList.add(iGeomNode3);
            }
            ++n;
        }
        if (iGeom == iGeom2 && iPropertySet == iPropertySet2 && arrayList == null) {
            return iGeomNode;
        }
        if (arrayList != null) {
            collection = arrayList;
        }
        return GeomNodeUtil.newNode(iGeomNode.getLocalTransform(), iGeom2, iPropertySet2, collection);
    }

    public static List<Pair<TransformInfo, IGeom>> quickFlatten(IGeomNode iGeomNode, int n) {
        ArrayList<Pair<TransformInfo, IGeom>> arrayList = new ArrayList<Pair<TransformInfo, IGeom>>();
        GeomNodeUtil.quickFlatten(iGeomNode, n, arrayList);
        return arrayList;
    }

    public static void quickFlatten(IGeomNode iGeomNode, int n, List<Pair<TransformInfo, IGeom>> list) {
        GeomNodeUtil.quickFlatten(TransformUtil.IDENTITY, iGeomNode, n, list);
    }

    private static void quickFlatten(ITransform iTransform, IGeomNode iGeomNode, int n, List<Pair<TransformInfo, IGeom>> list) {
        ITransform iTransform2 = iTransform.concatenate(iGeomNode.getLocalTransform());
        TransformInfo transformInfo = iTransform2.getInfo();
        if (GeomNodeUtil.test(n, 1) && iGeomNode.getLocalGeom() instanceof GeomGroup) {
            for (IGeom object : GeomUtil.flatten(iGeomNode.getLocalGeom())) {
                list.add(new Pair<TransformInfo, IGeom>(transformInfo, object));
            }
        } else {
            list.add(new Pair<TransformInfo, IGeom>(transformInfo, iGeomNode.getLocalGeom()));
        }
        for (IGeomNode iGeomNode2 : iGeomNode.getChildren()) {
            GeomNodeUtil.quickFlatten(iTransform2, iGeomNode2, n, list);
        }
    }

    public static boolean test(int n, int n2) {
        return (n & n2) == n2;
    }

    public static IGeomNode bakeIfRecommended(TransformInfo transformInfo, IGeomNode iGeomNode) {
        if (iGeomNode.isLeaf() && (iGeomNode.getLocalGeom().getRetainingDOF() != IDOF.FREE || iGeomNode.getLocalGeom().getBakeTransform() || iGeomNode.getLocalTransform().isIdentity())) {
            TransformInfo transformInfo2 = transformInfo.concatenate(iGeomNode.getLocalTransform());
            if (transformInfo2.isIdentity()) {
                return iGeomNode;
            }
            IGeom iGeom = iGeomNode.getLocalGeom();
            if (transformInfo2.isAccepted(iGeom.getRetainingDOF())) {
                IGeom iGeom2 = iGeomNode.getLocalGeom().transform(transformInfo2, 1);
                IPropertySet iPropertySet = Elements.transform(iGeomNode.getLocalElements(), transformInfo2);
                return GeomNodeUtil.newNode(iGeom2, iPropertySet);
            }
        }
        return iGeomNode;
    }

    private static /* synthetic */ IElemSource lambda$applyElements$712(BiFunction biFunction, int n, Integer n2, IElemSource iElemSource) {
        return (IElemSource)biFunction.apply(n + n2, iElemSource);
    }

    private static /* synthetic */ Pair lambda$null$697(Supplier supplier, Matrix4d matrix4d) {
        Pair pair = (Pair)supplier.get();
        return new Pair<Point3d, Vector3d>(Util3D.xform(matrix4d, (Point3d)pair.v1), Util3D.xform(matrix4d, (Vector3d)pair.v2));
    }

    protected static class FlatIterator
    implements Iterator<IGeomNode> {
        private final IGeomNode node;
        private Iterator<? extends IGeomNode> childIt;
        private Iterator<? extends IGeomNode> childItemIt;

        public FlatIterator(IGeomNode iGeomNode) {
            this.node = iGeomNode;
            this.childIt = null;
            this.childItemIt = null;
        }

        @Override
        public boolean hasNext() {
            return this.childItemIt == null || this.childItemIt.hasNext();
        }

        @Override
        public IGeomNode next() {
            if (this.childIt == null) {
                IGeomNode iGeomNode = this.node;
                this.childIt = this.node.getChildren().iterator();
                if (this.childIt.hasNext()) {
                    IGeomNode iGeomNode2 = this.childIt.next();
                    this.childItemIt = iGeomNode2.flatIterator();
                    assert (this.childItemIt.hasNext());
                } else {
                    this.childItemIt = Collections.emptyIterator();
                }
                return iGeomNode;
            }
            IGeomNode iGeomNode = this.childItemIt.next();
            if (!this.childItemIt.hasNext() && this.childIt.hasNext()) {
                IGeomNode iGeomNode3 = this.childIt.next();
                this.childItemIt = iGeomNode3.flatIterator();
                assert (this.childItemIt.hasNext());
            }
            return iGeomNode;
        }
    }

    private static class XformResult
    implements IResult<IPrimitive> {
        private final TransformInfo d_xform;
        private final IResult<? super IPrimitive> d_base;

        public XformResult(IResult<? super IPrimitive> iResult, TransformInfo transformInfo) {
            this.d_xform = transformInfo;
            this.d_base = iResult;
        }

        @Override
        public void mark(IPrimitive iPrimitive, Containment containment) {
            iPrimitive = iPrimitive.transform(this.d_xform, 0);
            this.d_base.mark(iPrimitive, containment);
        }
    }

    private static class XformTester
    implements ITest<AABox> {
        private final ITest<AABox> base;
        private final TransformInfo xform;

        public XformTester(ITest<AABox> iTest, TransformInfo transformInfo) {
            this.base = iTest;
            this.xform = transformInfo;
        }

        @Override
        public Containment test(AABox aABox) {
            AABox aABox2 = new AABox(aABox);
            aABox2.transformEq(this.xform.getMatrix());
            return this.base.test(aABox2);
        }
    }
}

