/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;

public interface IElemSource<ElemT> {
    public static final int INFINITE = -1;

    public int getNumPrims();

    default public boolean isUnbounded() {
        return this.getNumPrims() == -1;
    }

    public IElemSource<ElemT> subset(int var1, int var2);

    public IElemSource<ElemT> getPrimSource(int var1);

    default public ElemT getPrimElement(int n) {
        return this.getPrimVertElement(n, 0);
    }

    public ElemT getPrimVertElement(int var1, int var2);

    public IElemSource<ElemT> transform(Class<ElemT> var1, UnaryOperator<ElemT> var2);

    default public ElementMesh<ElemT> generate(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc, int n, boolean bl) {
        if (!1.$assertionsDisabled && !this.isUnbounded() && list.size() != this.getNumPrims()) {
            throw new AssertionError();
        }
        return Elements.toMesh(clazz, this.generate(clazz, list, iElemSource, iPropsSrc), n, bl);
    }

    public List<ElemT> generate(Class<ElemT> var1, List<? extends IPolygon> var2, IElemSource<Elements.Orient> var3, IPropsSrc var4);

    public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> var1);

    public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> var1);

    public boolean isComposite();

    default public ElementMesh<ElemT> generate(Class<ElemT> clazz, Mesh mesh, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc) {
        switch (mesh.primtype) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return this.generate(clazz, mesh.getPrimitives(), iElemSource, iPropsSrc, mesh.getNumVertsPerPrim(), true);
    }

    default public ElementMesh<ElemT> generate(Class<ElemT> clazz, IPrimitive iPrimitive, Elements.Orient orient, Mesh mesh, IPrimProps iPrimProps) {
        return null;
    }

    default public List<IElemSource<ElemT>> getPrimList() {
        int n = this.getNumPrims();
        if (n == -1) {
            n = Integer.MAX_VALUE;
        }
        return new ElemList(this, n);
    }

    default public Iterator<IElemSource<ElemT>> getPrimIterator() {
        return this.getPrimIterator(0);
    }

    default public Iterator<IElemSource<ElemT>> getPrimIterator(int n) {
        return new ElemIterator(this, this.getNumPrims(), n);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class ElemList<ElemT>
    extends AbstractList<IElemSource<ElemT>> {
        public final IElemSource<ElemT> elems;
        public final int size;

        public ElemList(IElemSource<ElemT> iElemSource, int n) {
            this.elems = iElemSource;
            this.size = n;
        }

        @Override
        public IElemSource<ElemT> get(int n) {
            return this.elems.getPrimSource(n);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    public static class ElemIterator<ElemT>
    implements Iterator<IElemSource<ElemT>> {
        public final IElemSource<ElemT> elems;
        public final int size;
        private int ix;

        public ElemIterator(IElemSource<ElemT> iElemSource, int n, int n2) {
            this.elems = iElemSource;
            this.size = n;
            this.ix = n2;
        }

        @Override
        public IElemSource<ElemT> next() {
            IElemSource<ElemT> iElemSource = this.elems.getPrimSource(this.ix);
            ++this.ix;
            return iElemSource;
        }

        @Override
        public boolean hasNext() {
            return this.size == -1 || this.ix < this.size;
        }
    }
}

