/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.vecmath.Point2d;
import thunderheadeng.geometry.objs.elem.ElementBuilder;
import thunderheadeng.geometry.objs.elem.ElementBuilders;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ListMap;

public class ElementsBuilder {
    private final Map<Elements.ElemProp<?>, ElementBuilder<?>> d_elements = new HashMap();
    private final Map<String, ElementBuilder<Point2d>> d_uvElements = new ListMap<String, ElementBuilder<Point2d>>();
    private final int[] d_primsAdded = new int[]{0};
    private static final Function<Elements.ElemProp<?>, ElementBuilder<?>> s_newBuilder = elemProp -> new ElementBuilder((IElemSource)elemProp.defVal);
    private final Function<String, ElementBuilder<Point2d>> s_newUVBuilder = string -> ElementBuilders.uv();

    public void add(IPropertySet iPropertySet, int n) {
        for (Elements.ElemProp<?> object : Elements.FIXED) {
            this.add(object, (IElemSource)iPropertySet.get(object), n);
        }
        for (Map.Entry entry : iPropertySet.get(Elements.UV).entrySet()) {
            this.addUV((String)entry.getKey(), (IElemSource)entry.getValue(), n);
        }
        this.d_primsAdded[0] = this.d_primsAdded[0] + n;
    }

    public void addRange(IPropertySet iPropertySet, int n, int n2) {
        for (Elements.ElemProp<?> object : Elements.FIXED) {
            this.add(object, ((IElemSource)iPropertySet.get(object)).subset(n, n2), n2);
        }
        for (Map.Entry entry : iPropertySet.get(Elements.UV).entrySet()) {
            this.addUV((String)entry.getKey(), ((IElemSource)entry.getValue()).subset(n, n2), n2);
        }
        this.d_primsAdded[0] = this.d_primsAdded[0] + n2;
    }

    private void matchPrimCount(ElementBuilder<Point2d> elementBuilder) {
        if (elementBuilder.getNumPrims() < this.d_primsAdded[0]) {
            elementBuilder.add(Elements.NO_UV, this.d_primsAdded[0] - elementBuilder.getNumPrims());
        }
    }

    public <ElemT> void add(Elements.ElemProp<ElemT> elemProp, IElemSource<ElemT> iElemSource, int n) {
        this.d_elements.computeIfAbsent(elemProp, s_newBuilder).add(iElemSource, n);
    }

    public void addUV(String string, IElemSource<Point2d> iElemSource, int n) {
        ElementBuilder<Point2d> elementBuilder = this.d_uvElements.computeIfAbsent(string, this.s_newUVBuilder);
        this.matchPrimCount(elementBuilder);
        elementBuilder.add(iElemSource, n);
    }

    public void next(int n) {
        this.d_primsAdded[0] = this.d_primsAdded[0] + n;
    }

    public IPropertySet finish() {
        IPropertySet iPropertySet = Elements.newElements();
        for (Map.Entry<Elements.ElemProp<?>, ElementBuilder<?>> object : this.d_elements.entrySet()) {
            iPropertySet.setIfNotDefault((IPropertySet.Prop)object.getKey(), object.getValue().finish());
        }
        ListMap listMap = new ListMap();
        for (Map.Entry<String, ElementBuilder<Point2d>> entry : this.d_uvElements.entrySet()) {
            this.matchPrimCount(entry.getValue());
            listMap.put(entry.getKey(), entry.getValue().finish());
        }
        iPropertySet.setIfNotDefault(Elements.UV, listMap);
        return Elements.finalizeElements(iPropertySet);
    }
}

