/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.elem.ElementBuilder;
import thunderheadeng.geometry.objs.elem.ElementBuilders;
import thunderheadeng.geometry.objs.elem.ElementFlattened;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.ElementPoly;
import thunderheadeng.geometry.objs.elem.ElementUniform;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LWPropertySet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public class Elements {
    public static final IPropertySet NONE = new DefElements();
    public static final String DEFAULT_UVSET_NAME = "teciuv0x193fa";
    public static final IElemSource<Point2d> NO_UV = new EmptyElem<Point2d>(new Point2d(0.0, 0.0));
    public static final IElemSource<Vector3d> NO_NORMAL = new EmptyElem<Vector3d>(new Vector3d(0.0, 0.0, 1.0));
    public static final IElemSource<Boolean> ALL_CREASE = new UniformDefault<Boolean>(Boolean.TRUE);
    public static final IElemSource<Boolean> NO_CREASE = new UniformDefault<Boolean>(Boolean.FALSE);
    public static final IElemSource<Orient> CCW = new UniformDefault<Orient>((Object)Orient.CCW);
    public static final IElemSource<Orient> CW = new UniformDefault<Orient>((Object)Orient.CW);
    public static final ElemProp<Vector3d> NORMAL = new ElemProp<Vector3d>(1, Vector3d.class, NO_NORMAL);
    public static final ElemProp<Boolean> CREASE = new ElemProp<Boolean>(2, Boolean.class, ALL_CREASE);
    public static final ElemProp<Orient> ORIENT = new ElemProp<Orient>(3, Orient.class, CCW);
    public static final ElemProp<Point2d> UV_DIFFUSE = new ElemProp<Point2d>(4, Point2d.class, NO_UV);
    public static final IPropertySet.Prop<Map<String, IElemSource<Point2d>>> UV = new IPropertySet.Prop(5, Collections.emptyMap());
    public static final List<ElemProp<?>> FIXED = Arrays.asList(NORMAL, CREASE, ORIENT);
    private static final List<IPropertySet.Prop<?>> ALL = new ArrayList();
    private static final double CREASE_FROM_NORMAL_DOT_TOL;

    public static IPropertySet newElements(IElemSource<Point2d> iElemSource, IElemSource<Vector3d> iElemSource2, IElemSource<Boolean> iElemSource3, IElemSource<Orient> iElemSource4) {
        IPropertySet iPropertySet = Elements.newElements();
        if (iElemSource != null) {
            iPropertySet.setIfNotDefault(UV, Elements.newUVMap("uvset", iElemSource));
        }
        if (iElemSource2 != null) {
            iPropertySet.setIfNotDefault(NORMAL, iElemSource2);
        }
        if (iElemSource3 != null) {
            iPropertySet.setIfNotDefault(CREASE, iElemSource3);
        }
        if (iElemSource4 != null) {
            iPropertySet.setIfNotDefault(ORIENT, iElemSource4);
        }
        return Elements.finalizeElements(iPropertySet);
    }

    private static ListMap<String, IElemSource<Point2d>> newUVMap(Object ... objectArray) {
        assert (objectArray.length % 2 == 0);
        ListMap<String, IElemSource<Point2d>> listMap = new ListMap<String, IElemSource<Point2d>>();
        for (int i = 0; i < objectArray.length; i += 2) {
            listMap.put((String)objectArray[i], (IElemSource)objectArray[i + 1]);
        }
        return listMap;
    }

    public static IPropertySet newElements(Object ... objectArray) {
        return Elements.newElements(Arrays.asList(objectArray));
    }

    public static IPropertySet newElements(List<?> list) {
        assert (list.size() % 2 == 0);
        IPropertySet iPropertySet = Elements.newElements();
        ListMap<String, IElemSource> listMap = null;
        for (int i = 0; i < list.size(); i += 2) {
            Object obj = list.get(i);
            Object obj2 = list.get(i + 1);
            if (obj instanceof String) {
                if (listMap == null) {
                    listMap = new ListMap<String, IElemSource>();
                }
                listMap.put((String)obj, (IElemSource)obj2);
                continue;
            }
            IPropertySet.Prop prop = (IPropertySet.Prop)list.get(i);
            iPropertySet.setIfNotDefault(prop, obj2);
        }
        if (listMap != null) {
            iPropertySet.setIfNotDefault(UV, listMap);
        }
        return Elements.finalizeElements(iPropertySet);
    }

    public static IPropertySet fixLegacy(IPropertySet iPropertySet) {
        if (!iPropertySet.isDefined(UV_DIFFUSE)) {
            return iPropertySet;
        }
        IElemSource iElemSource = (IElemSource)((Object)iPropertySet.get(UV_DIFFUSE));
        iPropertySet = Elements.copyOf(iPropertySet);
        iPropertySet.remove(UV_DIFFUSE);
        ListMap<String, IElemSource<Point2d>> listMap = new ListMap<String, IElemSource<Point2d>>(iPropertySet.get(UV));
        listMap.put("uvset", iElemSource);
        iPropertySet.setIfNotDefault(UV, listMap);
        return Elements.finalizeElements(iPropertySet);
    }

    public static IPropertySet newElements() {
        return new LWPropertySet();
    }

    public static IPropertySet makeMutable(IPropertySet iPropertySet) {
        if (iPropertySet == NONE) {
            return Elements.newElements();
        }
        return iPropertySet;
    }

    public static IPropertySet copyOf(IPropertySet iPropertySet) {
        IPropertySet iPropertySet2 = Elements.newElements();
        iPropertySet2.merge(iPropertySet, ALL);
        return iPropertySet2;
    }

    public static IPropertySet finalizeElements(IPropertySet iPropertySet) {
        if (iPropertySet instanceof PropertySet && ((PropertySet)iPropertySet).size() == 0) {
            return NONE;
        }
        for (IPropertySet.Prop<?> prop : ALL) {
            if (iPropertySet.get(prop) == prop.defVal) continue;
            return iPropertySet;
        }
        return NONE;
    }

    private static boolean normalsEqual(Vector3d vector3d, Vector3d vector3d2) {
        return vector3d.dot(vector3d2) >= CREASE_FROM_NORMAL_DOT_TOL;
    }

    public static IElemSource<Vector3d> generateNormals(IGeom iGeom, IElemSource<Orient> iElemSource, boolean bl) {
        int n;
        Object object;
        int n2 = Elements.getAllFaceCount(iGeom);
        if (n2 == 0) {
            return NO_NORMAL;
        }
        List list = GeomUtil.explode(iGeom, IFace.class);
        if (bl) {
            Object object322;
            Object object422;
            int n3;
            Vector3d[] vector3dArray22;
            LinkedHashMap<Point3d, Pair> linkedHashMap = new LinkedHashMap<Point3d, Pair>();
            Function<Point3d, Pair> function = point3d -> new Pair<Integer, Vector3d>(linkedHashMap.size(), new Vector3d());
            int n4 = 0;
            for (int i = 0; i < list.size(); ++i) {
                vector3dArray22 = (IFace)list.get(i);
                n3 = -1;
                if (vector3dArray22 instanceof IPolygon) {
                    object422 = (IPolygon)vector3dArray22;
                    n3 = PolyUtil.getNumVerts((IPolygon)object422);
                    boolean bl2 = iElemSource.getPrimElement(i) == Orient.CCW;
                    object322 = object422.getNormal(bl2);
                    for (Point3d point3d2 : PolyUtil.getAllVerts((IPolygon)object422, false)) {
                        ((Vector3d)linkedHashMap.computeIfAbsent(point3d2, function).v2).add((Tuple3d)object322);
                    }
                }
                if (n4 == 0) {
                    n4 = n3;
                    continue;
                }
                if (n4 == n3) continue;
                n4 = -1;
            }
            for (Vector3d[] vector3dArray22 : linkedHashMap.values()) {
                ((Vector3d)vector3dArray22.v2).normalize();
            }
            if (linkedHashMap.isEmpty()) {
                return NO_NORMAL;
            }
            Vector3d vector3d = (Vector3d)((Pair)linkedHashMap.values().iterator().next()).v2;
            if (linkedHashMap.values().stream().allMatch(pair -> Elements.normalsEqual((Vector3d)pair.v2, vector3d))) {
                return new ElementUniform<Object>(vector3d);
            }
            if (n4 > 0) {
                vector3dArray22 = new Vector3d[linkedHashMap.size()];
                n3 = 0;
                for (Pair pair2 : linkedHashMap.values()) {
                    vector3dArray22[n3++] = (Vector3d)pair2.v2;
                }
                if (theUtil.isUniform(vector3dArray22)) {
                    return new ElementUniform<Vector3d>(vector3dArray22[0]);
                }
                object422 = new int[n2 * n4];
                n3 = 0;
                for (Object object322 : list) {
                    assert (object322 instanceof IPolygon);
                    IPolygon iPolygon = (IPolygon)object322;
                    for (Point3d point3d3 : PolyUtil.getAllVerts(iPolygon, false)) {
                        Pair pair2 = (Pair)linkedHashMap.get(point3d3);
                        object422[n3++] = (Integer)pair2.v1;
                    }
                }
                return new ElementMesh<Vector3d>(ElementMesh.Mapping.PER_PRIM_VERTEX, vector3dArray22, (int[])object422, n4);
            }
            vector3dArray22 = ElementBuilders.normal();
            for (Object object422 : list) {
                if (object422 instanceof IPolygon) {
                    IPolygon iPolygon = (IPolygon)object422;
                    object322 = PolyUtil.getAllVerts(iPolygon, false);
                    Vector3d[] vector3dArray = new Vector3d[((Point3d[])object322).length];
                    for (int i = 0; i < ((Point3d[])object322).length; ++i) {
                        vector3dArray[i] = (Vector3d)((Pair)linkedHashMap.get((Object)object322[i])).v2;
                    }
                    IElemSource<Vector3d> iElemSource2 = theUtil.isUniform(vector3dArray) ? new ElementUniform<Vector3d>(vector3dArray[0]) : new ElementPoly<Vector3d>(vector3dArray);
                    vector3dArray22.add(iElemSource2, 1);
                    continue;
                }
                vector3dArray22.add(NO_NORMAL, 1);
            }
            return vector3dArray22.finish();
        }
        Vector3d[] vector3dArray = new Vector3d[n2];
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < list.size(); ++i) {
            object = (IFace)list.get(i);
            n = -1;
            if (object instanceof IPolygon) {
                IPolygon iPolygon = (IPolygon)object;
                n = PolyUtil.getNumVerts(iPolygon);
                boolean bl3 = iElemSource.getPrimElement(i) == Orient.CCW;
                vector3dArray[n6] = iPolygon.getNormal(bl3);
            } else {
                vector3dArray[n6] = GeomConstants.VEC3D_ZPOS;
            }
            if (n5 == 0) {
                n5 = n;
            } else if (n5 != n) {
                n5 = -1;
            }
            ++n6;
        }
        Vector3d vector3d = vector3dArray[0];
        if (theUtil.isUniform(vector3dArray, Elements::normalsEqual)) {
            return new ElementUniform<Vector3d>(vector3d);
        }
        if (n5 > 0) {
            return new ElementMesh<Vector3d>(ElementMesh.Mapping.PER_PRIM, vector3dArray, n5);
        }
        object = ElementBuilders.normal();
        for (n = 0; n < n2; ++n) {
            ((ElementBuilder)object).add(new ElementUniform<Vector3d>(vector3dArray[n]), 1);
        }
        return ((ElementBuilder)object).finish();
    }

    public static IElemSource<Vector3d> generateNormals(Mesh mesh, IElemSource<Orient> iElemSource, boolean bl) {
        return Elements.generateNormals(mesh, iElemSource, bl ? Math.PI : 0.0);
    }

    public static IElemSource<Vector3d> generateNormals(Mesh mesh, IElemSource<Orient> iElemSource, double d) {
        Object object;
        boolean bl;
        if (!Elements.isFaceType(mesh.primtype)) {
            return NO_NORMAL;
        }
        int n = Mesh.getNumVertsPerElement(mesh.primtype);
        boolean bl2 = d == 0.0;
        boolean bl3 = bl = d >= Math.PI;
        if (bl2 || bl) {
            int n2 = bl2 ? mesh.indices.length / n : mesh.vertices.length;
            Vector3d[] vector3dArray = new Vector3d[n2];
            if (bl) {
                for (int i = 0; i < mesh.vertices.length; ++i) {
                    vector3dArray[i] = new Vector3d(0.0, 0.0, 0.0);
                }
            }
            Point3d[] point3dArray = new Point3d[n];
            List<Point3d> list = Arrays.asList(point3dArray);
            int n3 = 0;
            int n4 = 0;
            while (n3 < mesh.indices.length) {
                int n5;
                for (n5 = 0; n5 < n; ++n5) {
                    point3dArray[n5] = mesh.vertices[mesh.indices[n3 + n5]];
                }
                n5 = iElemSource.getPrimElement(n4) == Orient.CCW ? 1 : 0;
                Vector3d vector3d = Util3D.simplePolygonNormal(list, n5 != 0);
                if (vector3d == null) {
                    vector3d = GeomConstants.VEC3D_ZPOS;
                }
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        vector3dArray[mesh.indices[n3 + i]].add(vector3d);
                    }
                } else {
                    vector3dArray[n3 / n] = vector3d;
                }
                n3 += n;
                ++n4;
            }
            if (bl) {
                for (n3 = 0; n3 < mesh.vertices.length; ++n3) {
                    vector3dArray[n3].normalize();
                }
                return new ElementMesh<Vector3d>(ElementMesh.Mapping.PER_PRIM_VERTEX, vector3dArray, mesh.indices, n);
            }
            return new ElementMesh<Vector3d>(ElementMesh.Mapping.PER_PRIM, vector3dArray, ElementMesh.DIRECT, n);
        }
        Vector3d[] vector3dArray = new Vector3d[mesh.indices.length / n];
        Point3d[] point3dArray = new Point3d[n];
        List<Point3d> list = Arrays.asList(point3dArray);
        int n6 = 0;
        int n7 = 0;
        while (n6 < mesh.indices.length) {
            int n8;
            for (n8 = 0; n8 < n; ++n8) {
                int n9 = mesh.indices[n6 + n8];
                point3dArray[n8] = mesh.vertices[n9];
            }
            n8 = iElemSource.getPrimElement(n7) == Orient.CCW ? 1 : 0;
            object = Util3D.simplePolygonNormal(list, n8 != 0);
            if (object == null) {
                object = GeomConstants.VEC3D_ZPOS;
            }
            vector3dArray[n7] = object;
            n6 += n;
            ++n7;
        }
        double d2 = Math.cos(d);
        List[] listArray = new List[mesh.vertices.length];
        object = new NormalCount[mesh.indices.length];
        int n10 = 0;
        int n11 = 0;
        while (n10 < mesh.indices.length) {
            Vector3d vector3d = vector3dArray[n11];
            for (int i = 0; i < n; ++i) {
                NormalCount normalCount;
                int n12 = mesh.indices[n10 + i];
                List<NormalCount> list2 = listArray[n12];
                if (list2 == null) {
                    listArray[n12] = list2 = new ArrayList<NormalCount>(5);
                    normalCount = new NormalCount(vector3d);
                    list2.add(normalCount);
                    object[n10 + i] = normalCount;
                    continue;
                }
                normalCount = null;
                double d3 = d2;
                for (NormalCount normalCount2 : list2) {
                    double d4 = normalCount2.protoNormal.dot(vector3d);
                    if (!theUtil.ge(d4, d3, 1.0E-6)) continue;
                    normalCount2.normalSum.add(vector3d);
                    ++normalCount2.count;
                    normalCount = normalCount2;
                    d3 = d4;
                }
                if (normalCount == null) {
                    normalCount = new NormalCount(vector3d);
                    list2.add(normalCount);
                }
                object[n10 + i] = normalCount;
            }
            n10 += n;
            ++n11;
        }
        for (List list3 : listArray) {
            for (List<NormalCount> list2 : list3) {
                ((NormalCount)((Object)list2)).normalSum.normalize();
            }
        }
        Object[] objectArray = new Vector3d[mesh.indices.length];
        for (n11 = 0; n11 < mesh.indices.length; ++n11) {
            objectArray[n11] = object[n11].normalSum;
        }
        return new ElementMesh<Object>(ElementMesh.Mapping.PER_PRIM_VERTEX, objectArray, n);
    }

    private static boolean isFaceType(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static IElemSource<Orient> fixFaceOrients(Mesh mesh, IElemSource<Orient> iElemSource, IPropsSrc iPropsSrc) {
        if (!Elements.isFaceType(mesh.primtype)) {
            return iElemSource;
        }
        int n = mesh.getNumPrims(1);
        BitSet bitSet = new BitSet(n);
        ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
        Map<IxEdge, List<int[]>> map = Elements.getFaceAdjacency(mesh);
        int n5 = mesh.getNumVertsPerPrim();
        ElementMesh<Orient> elementMesh = iElemSource.generate(Orient.class, mesh.getPrimitives(), iElemSource, iPropsSrc, n5, false);
        Orient[] orientArray = (Orient[])theUtil.toArray(elementMesh.subList(0, n));
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        TriIntAndObjConsumer<int[]> triIntAndObjConsumer = (n2, n3, n4, nArray) -> {
            int n5 = mesh.indices[n3 + n4];
            int n6 = mesh.indices[n3 + (n4 + 1) % n5];
            Orient orient = orientArray[n2];
            if (orient != Orient.CCW) {
                int n7 = n5;
                n5 = n6;
                n6 = n7;
            }
            nArray[0] = n5;
            nArray[1] = n6;
        };
        while (bitSet.cardinality() != n) {
            int n6 = bitSet.nextClearBit(0);
            arrayDeque.push(n6);
            bitSet.set(n6);
            while (!arrayDeque.isEmpty()) {
                int n7 = (Integer)arrayDeque.pop();
                int n8 = n7 * n5;
                for (int i = 0; i < n5; ++i) {
                    triIntAndObjConsumer.accept(n7, n8, i, nArray2);
                    IxEdge ixEdge = new IxEdge(nArray2[0], nArray2[1]);
                    List<int[]> list = map.get(ixEdge);
                    assert (list != null);
                    if (list.size() > 2) continue;
                    for (int[] nArray4 : list) {
                        int n9 = nArray4[0];
                        if (n9 == n7 || bitSet.get(n9)) continue;
                        bitSet.set(n9);
                        int n10 = n9 * n5;
                        triIntAndObjConsumer.accept(n9, n10, nArray4[1], nArray3);
                        if (nArray2[0] == nArray3[0] && nArray2[1] == nArray3[1]) {
                            orientArray[n9] = orientArray[n9].flip();
                        }
                        arrayDeque.push(n9);
                    }
                }
            }
        }
        if (theUtil.isUniform(orientArray)) {
            return new ElementUniform<Orient>(orientArray[0]);
        }
        return new ElementMesh<Orient>(ElementMesh.Mapping.PER_PRIM, orientArray, n5);
    }

    private static Map<IxEdge, List<int[]>> getFaceAdjacency(Mesh mesh) {
        HashMap<IxEdge, List<int[]>> hashMap = new HashMap<IxEdge, List<int[]>>();
        Function<IxEdge, List> function = ixEdge -> new ArrayList();
        int n = mesh.getNumVertsPerPrim();
        int n2 = 0;
        int n3 = 0;
        while (n2 < mesh.indices.length) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = mesh.indices[n2 + n4];
                int n6 = mesh.indices[n2 + (n4 + 1) % n];
                IxEdge ixEdge2 = new IxEdge(n5, n6);
                List list = hashMap.computeIfAbsent(ixEdge2, function);
                list.add(new int[]{n3, n4++});
            }
            n2 += n;
            ++n3;
        }
        return hashMap;
    }

    public static IElemSource<Boolean> generateCreasesFromNormals(Mesh mesh, IPropsSrc iPropsSrc, IElemSource<Vector3d> iElemSource, IElemSource<Orient> iElemSource2) {
        ElementMesh<Vector3d> elementMesh = iElemSource.generate(Vector3d.class, mesh, iElemSource2, iPropsSrc);
        if (elementMesh == null) {
            return ALL_CREASE;
        }
        Map<IxEdge, List<int[]>> map = Elements.getFaceAdjacency(mesh);
        int n = mesh.getNumVertsPerPrim();
        Boolean[] booleanArray = new Boolean[mesh.indices.length];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < mesh.indices.length; i += n) {
            for (int j = 0; j < n; ++j) {
                int n4 = mesh.indices[i + j];
                int n5 = mesh.indices[i + (j + 1) % n];
                IxEdge ixEdge = new IxEdge(n4, n5);
                List<int[]> list = map.get(ixEdge);
                int[] nArray = list.get(0);
                if (nArray[1] != j || nArray[0] != i / n) {
                    booleanArray[i + j] = Boolean.FALSE;
                    continue;
                }
                Boolean bl = Boolean.FALSE;
                if (list.size() == 1) {
                    bl = Boolean.TRUE;
                } else if (elementMesh.mapping != ElementMesh.Mapping.ALL_SAME) {
                    Vector3d vector3d = elementMesh.getPrimVertElement(nArray[0], nArray[1]);
                    for (int k = 1; k < list.size(); ++k) {
                        Vector3d vector3d2;
                        int n6;
                        int[] nArray2 = list.get(k);
                        int n7 = nArray2[0] * n;
                        int n8 = mesh.indices[n7 + (n6 = nArray2[1])];
                        if (n8 != n4 && (n8 = mesh.indices[n7 + (n6 = (nArray2[1] + 1) % n)]) != n4) {
                            n6 = (nArray2[1] + n - 1) % n;
                            n8 = mesh.indices[n7 + n6];
                            assert (n8 == n4);
                        }
                        if (Elements.normalsEqual(vector3d, vector3d2 = elementMesh.getPrimVertElement(nArray2[0], n6))) continue;
                        bl = Boolean.TRUE;
                        break;
                    }
                }
                ++n2;
                if (bl.booleanValue()) {
                    ++n3;
                }
                booleanArray[i + j] = bl;
            }
        }
        if (n2 == n3) {
            return ALL_CREASE;
        }
        if (n3 == 0) {
            return NO_CREASE;
        }
        return new ElementMesh<Boolean>(ElementMesh.Mapping.PER_PRIM_VERTEX, booleanArray, ElementMesh.DIRECT, n);
    }

    private static int getAllFaceCount(IGeom iGeom) {
        int n = iGeom.getNumPrims(1);
        if (n == 0 || iGeom.getNumPrims(7) != n) {
            return 0;
        }
        return n;
    }

    public static <T extends IPrimitive> void processSimilarPolys(List<T> list, TriConsumer<List<T>, Integer, Integer> triConsumer) {
        Function<IPrimitive, Integer> function = iPrimitive -> {
            if (iPrimitive instanceof IPolygon) {
                return PolyUtil.getNumVerts((IPolygon)iPrimitive);
            }
            return 0;
        };
        theUtil.groupSequentialMatches(list, function, triConsumer);
    }

    public static <T extends IPrimitive> void processPolys(List<T> list, TriConsumer<List<T>, Integer, Boolean> triConsumer) {
        Function<IPrimitive, Boolean> function = iPrimitive -> iPrimitive instanceof IPolygon;
        theUtil.groupSequentialMatches(list, function, triConsumer);
    }

    public static IElemSource<Boolean> generateCreasesFromNormals(IGeom iGeom, IPropsSrc iPropsSrc, IElemSource<Vector3d> iElemSource, IElemSource<Orient> iElemSource2) {
        if (iElemSource == NO_NORMAL) {
            return (IElemSource)Elements.CREASE.defVal;
        }
        int n3 = Elements.getAllFaceCount(iGeom);
        if (n3 == 0) {
            return (IElemSource)Elements.CREASE.defVal;
        }
        List list2 = GeomUtil.explode(iGeom, IFace.class);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Function<PEdge, Map> function = pEdge -> new ListMap();
        Function<Point3d, List> function2 = point3d -> new ArrayList();
        Elements.processSimilarPolys(list2, (list, n, n2) -> {
            if (n2 == 0) {
                return;
            }
            int n3 = list.size();
            IPropsSrc iPropsSrc2 = iPropsSrc.subset((int)n, n3);
            IElemSource<Vector3d> iElemSource3 = iElemSource.subset((int)n, n3);
            IElemSource<Orient> iElemSource4 = iElemSource2.subset((int)n, n3);
            if (iElemSource3 == NO_NORMAL) {
                return;
            }
            ElementMesh<Vector3d> elementMesh = iElemSource3.generate(Vector3d.class, (List<IPolygon>)list, iElemSource4, iPropsSrc2, (int)n2, false);
            for (int i = 0; i < list.size(); ++i) {
                IFace iFace = (IFace)list.get(i);
                assert (iFace instanceof IPolygon);
                IPolygon iPolygon = (IPolygon)iFace;
                int n4 = 0;
                for (int j = 0; j < iPolygon.getNumLoops(); ++j) {
                    int n5 = iPolygon.getNumPoints(j);
                    for (int k = 0; k < n5; ++k) {
                        int n6 = k;
                        int n7 = (k + 1) % n5;
                        Point3d point3d = iPolygon.getPoint(j, n6);
                        Point3d point3d2 = iPolygon.getPoint(j, n7);
                        PEdge pEdge = new PEdge(point3d, point3d2);
                        Map map2 = (Map)linkedHashMap.computeIfAbsent(pEdge, function);
                        List list2 = (List)map2.computeIfAbsent(point3d, function2);
                        List list3 = (List)map2.computeIfAbsent(point3d2, function2);
                        list2.add(elementMesh.getPrimVertElement(i, n4 + n6));
                        list3.add(elementMesh.getPrimVertElement(i, n4 + n7));
                    }
                    n4 += n5;
                }
            }
        });
        BiPredicate<Vector3d, Vector3d> biPredicate = Elements::normalsEqual;
        ElementBuilder<Boolean> elementBuilder = ElementBuilders.crease();
        Elements.processSimilarPolys(list2, (list, n, n2) -> {
            if (n2 == 0) {
                elementBuilder.add(ALL_CREASE, list.size());
                return;
            }
            Boolean[] booleanArray = new Boolean[list.size() * n2];
            int n3 = 0;
            for (int i = 0; i < list.size(); ++i) {
                IFace iFace = (IFace)list.get(i);
                assert (iFace instanceof IPolygon);
                IPolygon iPolygon = (IPolygon)iFace;
                for (int j = 0; j < iPolygon.getNumLoops(); ++j) {
                    int n4 = iPolygon.getNumPoints(j);
                    for (int k = 0; k < n4; ++k) {
                        Boolean bl;
                        Point3d point3d;
                        Point3d point3d2 = iPolygon.getPoint(j, k);
                        PEdge pEdge = new PEdge(point3d2, point3d = iPolygon.getPoint(j, (k + 1) % n4));
                        Map map2 = (Map)linkedHashMap.get(pEdge);
                        if (map2 == null) {
                            bl = Boolean.TRUE;
                        } else {
                            List list2 = (List)map2.get(point3d2);
                            List list3 = (List)map2.get(point3d);
                            bl = list2.size() == 1 || !theUtil.isUniform(list2, biPredicate) || !theUtil.isUniform(list3, biPredicate);
                        }
                        booleanArray[n3++] = bl;
                    }
                }
            }
            IElemSource<Boolean> iElemSource = theUtil.isUniform(booleanArray) ? (booleanArray[0] == Boolean.TRUE ? ALL_CREASE : NO_CREASE) : new ElementMesh<Boolean>(ElementMesh.Mapping.PER_PRIM_VERTEX, (ElemT[])booleanArray, (int)n2);
            elementBuilder.add(iElemSource, list.size());
        });
        return elementBuilder.finish();
    }

    public static IElemSource<Boolean> generateCreasesFromFacets(IGeom iGeom, IPropsSrc iPropsSrc, IElemSource<Orient> iElemSource) {
        IElemSource<Vector3d> iElemSource2 = Elements.generateNormals(iGeom, iElemSource, false);
        IElemSource<Boolean> iElemSource3 = Elements.generateCreasesFromNormals(iGeom, iPropsSrc, iElemSource2, iElemSource);
        return iElemSource3;
    }

    public static <T> ElementMesh<T> combine(Class<T> clazz, Collection<Pair<ElementMesh<T>, Integer>> collection, int n, int n2) {
        if (collection.size() == 1) {
            return (ElementMesh)collection.iterator().next().v1;
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, n * n2);
        int n3 = 0;
        for (Pair<ElementMesh<T>, Integer> pair : collection) {
            ElementMesh elementMesh = (ElementMesh)pair.v1;
            int n4 = (Integer)pair.v2;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n2; ++j) {
                    objectArray[n3++] = elementMesh.getPrimVertElement(i, j);
                }
            }
        }
        return new ElementMesh<Object>(ElementMesh.Mapping.PER_PRIM_VERTEX, objectArray, n2);
    }

    public static <T> ElementMesh<T> toMesh(Class<T> clazz, List<T> list, int n, boolean bl) {
        if (list instanceof ElementMesh) {
            return (ElementMesh)list;
        }
        if (!bl) {
            return new ElementMesh<T>(ElementMesh.Mapping.PER_PRIM_VERTEX, theUtil.toArray(list, clazz), n);
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        Function<Object, Integer> function = object -> hashMap.size();
        int[] nArray = new int[list.size()];
        int n2 = 0;
        for (T t : list) {
            int n3 = hashMap.computeIfAbsent(t, function);
            nArray[n2++] = n3;
        }
        if (hashMap.size() == 1) {
            return new ElementMesh<T>(ElementMesh.Mapping.ALL_SAME, theUtil.toArray(list, clazz), n);
        }
        return new ElementMesh(ElementMesh.Mapping.PER_PRIM_VERTEX, theUtil.toArray(hashMap.keySet(), clazz), nArray, n);
    }

    public static boolean transformEq(IPropertySet iPropertySet, TransformInfo transformInfo) {
        IElemSource<Vector3d> iElemSource;
        if (iPropertySet == NONE || transformInfo.isIdentity()) {
            return false;
        }
        UnaryOperator unaryOperator = vector3d -> {
            Matrix4d matrix4d = transformInfo.getMatrix();
            Vector3d vector3d2 = Util3D.xform(matrix4d, vector3d);
            Util3D.safeNormalize(vector3d2, 0.0);
            return vector3d2;
        };
        boolean bl = false;
        IElemSource iElemSource2 = (IElemSource)((Object)iPropertySet.get(NORMAL));
        if (iElemSource2 != (iElemSource = iElemSource2.transform(Vector3d.class, unaryOperator))) {
            iPropertySet.set(NORMAL, iElemSource);
            bl = true;
        }
        if (transformInfo.hasNegativeScale()) {
            IElemSource<Orient> iElemSource3;
            UnaryOperator unaryOperator2 = orient -> orient.flip();
            IElemSource iElemSource4 = (IElemSource)((Object)iPropertySet.get(ORIENT));
            if (iElemSource4 != (iElemSource3 = iElemSource4.transform(Orient.class, unaryOperator2))) {
                iPropertySet.set(ORIENT, iElemSource3);
                bl = true;
            }
        }
        return bl;
    }

    public static IPropertySet transform(IPropertySet iPropertySet, TransformInfo transformInfo) {
        if (transformInfo.isIdentity()) {
            return iPropertySet;
        }
        IPropertySet iPropertySet2 = Elements.copyOf(iPropertySet);
        if (!Elements.transformEq(iPropertySet2, transformInfo)) {
            return iPropertySet;
        }
        return iPropertySet2;
    }

    public static IPropertySet getPrimElements(IPropertySet iPropertySet, int n) {
        IPropertySet iPropertySet2 = Elements.newElements();
        for (ElemProp<?> object : FIXED) {
            IElemSource iElemSource = ((IElemSource)iPropertySet.get(object)).getPrimSource(n);
            iPropertySet2.setIfNotDefault(object, iElemSource);
        }
        ListMap listMap = new ListMap();
        for (Map.Entry<String, IElemSource<Point2d>> entry : iPropertySet.get(UV).entrySet()) {
            listMap.put(entry.getKey(), entry.getValue().getPrimSource(n));
        }
        iPropertySet2.setIfNotDefault(UV, listMap);
        return Elements.finalizeElements(iPropertySet2);
    }

    public static <T> ElementFlattened<T> decompress(IElemSource<T> iElemSource, int n, int n2, boolean bl) {
        if (iElemSource instanceof ElementFlattened) {
            IElemSource<ElemT>[] iElemSourceArray = ((ElementFlattened)iElemSource).getArray();
            assert (iElemSourceArray.length == n2);
            return bl ? new ElementFlattened(Arrays.copyOf(iElemSourceArray, iElemSourceArray.length)) : (ElementFlattened)iElemSource;
        }
        Iterator<IElemSource<T>> iterator = iElemSource.getPrimIterator(n);
        IElemSource[] iElemSourceArray = new IElemSource[n2];
        for (int i = 0; i < n2; ++i) {
            iElemSourceArray[i] = iterator.next();
        }
        return new ElementFlattened(iElemSourceArray);
    }

    public static <T> IElemSource<T> compress(ElemProp<T> elemProp, IElemSource<T> ... iElemSourceArray) {
        ElementBuilder<T> elementBuilder = new ElementBuilder<T>((IElemSource)elemProp.defVal);
        for (IElemSource<T> iElemSource : iElemSourceArray) {
            elementBuilder.add(iElemSource, 1);
        }
        return elementBuilder.finish();
    }

    public static <T> IElemSource<T> compress(ElemProp<T> elemProp, IElemSource<T> iElemSource) {
        if (iElemSource instanceof ElementFlattened) {
            return Elements.compress(elemProp, ((ElementFlattened)iElemSource).getArray());
        }
        return iElemSource;
    }

    public static IPropertySet subset(IPropertySet iPropertySet, int n, int n2) {
        if (n2 == 0) {
            return NONE;
        }
        IPropertySet iPropertySet2 = Elements.newElements();
        for (ElemProp<?> object : FIXED) {
            iPropertySet2.setIfNotDefault(object, ((IElemSource)iPropertySet.get(object)).subset(n, n2));
        }
        ListMap listMap = new ListMap();
        for (Map.Entry<String, IElemSource<Point2d>> entry : iPropertySet.get(UV).entrySet()) {
            listMap.put(entry.getKey(), entry.getValue().subset(n, n2));
        }
        iPropertySet2.setIfNotDefault(UV, listMap);
        return Elements.finalizeElements(iPropertySet2);
    }

    public static <T> IElemSource<T> replaceElements(int n, IElemSource<T> iElemSource, IElemSource<T> iElemSource2, BiFunction<Integer, IElemSource<T>, IElemSource<T>> biFunction) {
        if (n > 0) {
            ElementBuilder<T> elementBuilder = null;
            IElemSource<T> iElemSource3 = iElemSource;
            Iterator<IElemSource<T>> iterator = iElemSource3.getPrimIterator(0);
            for (int i = 0; i < n; ++i) {
                IElemSource<T> iElemSource4;
                IElemSource<T> iElemSource5 = iterator.next();
                if (iElemSource5 == (iElemSource4 = biFunction.apply(i, iElemSource5)) && elementBuilder == null) continue;
                if (elementBuilder == null) {
                    elementBuilder = new ElementBuilder<T>(iElemSource2);
                    elementBuilder.add(iElemSource3.subset(0, i), i);
                }
                elementBuilder.add(iElemSource4, 1);
            }
            if (elementBuilder != null) {
                iElemSource = elementBuilder.finish();
            }
        }
        return iElemSource;
    }

    static {
        ALL.addAll(FIXED);
        ALL.add(UV);
        CREASE_FROM_NORMAL_DOT_TOL = Math.cos(Math.toRadians(1.0));
    }

    private static class EmptyElem<ElemT>
    extends ElementUniform<ElemT>
    implements Serializable {
        static final long serialVersionUID = 1L;

        public EmptyElem(ElemT ElemT) {
            super(ElemT);
        }

        @Override
        public EmptyElem<ElemT> transform(Class<ElemT> clazz, UnaryOperator<ElemT> unaryOperator) {
            return this;
        }

        @Override
        public IElemSource<ElemT> subset(int n, int n2) {
            return this;
        }

        @Override
        public IElemSource<ElemT> getPrimSource(int n) {
            return this;
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.element instanceof Point2d) {
                return NO_UV;
            }
            if (this.element instanceof Vector3d) {
                return NO_NORMAL;
            }
            return this;
        }
    }

    @Deprecated
    private static class EmptyDefault<ElemT>
    implements Serializable {
        static final long serialVersionUID = 1L;
        private Class<ElemT> d_type;

        private EmptyDefault() {
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.d_type.equals(Point2d.class)) {
                return NO_UV;
            }
            if (this.d_type.equals(Vector3d.class)) {
                return NO_NORMAL;
            }
            assert (false);
            return this;
        }
    }

    private static class UniformDefault<ElemT>
    extends ElementUniform<ElemT> {
        static final long serialVersionUID = 1L;

        private UniformDefault(ElemT ElemT) {
            super(ElemT);
        }

        private Object readResolve() throws ObjectStreamException {
            return UniformDefault.optimize(this);
        }

        @Override
        public ElementUniform<ElemT> transform(Class<ElemT> clazz, UnaryOperator<ElemT> unaryOperator) {
            IElemSource iElemSource = super.transform((Class)clazz, (UnaryOperator)unaryOperator);
            return UniformDefault.optimize(iElemSource);
        }

        private static <ElemT> ElementUniform<ElemT> optimize(ElementUniform<ElemT> elementUniform) {
            if (elementUniform.element == Boolean.FALSE) {
                return (ElementUniform)NO_CREASE;
            }
            if (elementUniform.element == Boolean.TRUE) {
                return (ElementUniform)ALL_CREASE;
            }
            if (elementUniform.element == Orient.CCW) {
                return (ElementUniform)CCW;
            }
            if (elementUniform.element == Orient.CW) {
                return (ElementUniform)CW;
            }
            return elementUniform;
        }
    }

    private static class PEdge {
        public final Point3d i1;
        public final Point3d i2;

        public PEdge(Point3d point3d, Point3d point3d2) {
            this.i1 = point3d;
            this.i2 = point3d2;
        }

        public int hashCode() {
            return this.i1.hashCode() + this.i2.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PEdge)) {
                return false;
            }
            PEdge pEdge = (PEdge)object;
            return this.i1.equals(pEdge.i1) && this.i2.equals(pEdge.i2) || this.i1.equals(pEdge.i2) && this.i2.equals(pEdge.i1);
        }
    }

    private static class IxEdge {
        public final int i1;
        public final int i2;

        public IxEdge(int n, int n2) {
            this.i1 = n;
            this.i2 = n2;
        }

        public int hashCode() {
            return this.i1 + this.i2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof IxEdge)) {
                return false;
            }
            IxEdge ixEdge = (IxEdge)object;
            return this.i1 == ixEdge.i1 && this.i2 == ixEdge.i2 || this.i1 == ixEdge.i2 && this.i2 == ixEdge.i1;
        }
    }

    private static interface TriIntAndObjConsumer<T> {
        public void accept(int var1, int var2, int var3, T var4);
    }

    private static class NormalCount {
        public final Vector3d protoNormal;
        public final Vector3d normalSum;
        public int count;

        public NormalCount(Vector3d vector3d) {
            this.protoNormal = vector3d;
            this.normalSum = new Vector3d(vector3d);
            this.count = 1;
        }
    }

    public static class ElemProp<ElemT>
    extends IPropertySet.Prop<IElemSource<ElemT>> {
        public final Class<ElemT> type;

        public ElemProp(Object object, Class<ElemT> clazz, IElemSource<ElemT> iElemSource) {
            super(object, iElemSource);
            this.type = clazz;
        }
    }

    private static class DefElements
    extends PropertySet {
        static final long serialVersionUID = 1L;

        private DefElements() {
        }

        private Object readResolve() throws ObjectStreamException {
            return NONE;
        }

        @Override
        public <T> void set(IPropertySet.Prop<T> prop, T t) {
        }

        @Override
        public <T> void remove(IPropertySet.Prop<T> prop) {
        }
    }

    public static enum Orient {
        CCW,
        CW;


        public Orient flip() {
            switch (this) {
                case CCW: {
                    return CW;
                }
            }
            return CCW;
        }

        public boolean isCCW() {
            return this == CCW;
        }
    }
}

