/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.theUtil;

public class ElementUniform<ElemT>
implements IElemSource<ElemT>,
Serializable {
    static final long serialVersionUID = 1L;
    public final ElemT element;

    public ElementUniform(ElemT ElemT) {
        this.element = ElemT;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof ElementUniform && Objects.equals(((ElementUniform)object).element, this.element);
    }

    @Override
    public IElemSource<ElemT> subset(int n, int n2) {
        return this;
    }

    @Override
    public IElemSource<ElemT> getPrimSource(int n) {
        return this;
    }

    @Override
    public ElemT getPrimVertElement(int n, int n2) {
        return this.element;
    }

    @Override
    public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> iElemSource) {
        if (this.equals(iElemSource)) {
            return this;
        }
        return null;
    }

    @Override
    public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> iElemSource) {
        return this.postConcatenate(iElemSource);
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public int getNumPrims() {
        return -1;
    }

    @Override
    public ElementUniform<ElemT> transform(Class<ElemT> clazz, UnaryOperator<ElemT> unaryOperator) {
        Object r = unaryOperator.apply(this.element);
        if (r == this.element) {
            return this;
        }
        return new ElementUniform(r);
    }

    @Override
    public ElementMesh<ElemT> generate(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc, int n, boolean bl) {
        return this.generate(clazz, n);
    }

    @Override
    public ElementMesh<ElemT> generate(Class<ElemT> clazz, IPrimitive iPrimitive, Elements.Orient orient, Mesh mesh, IPrimProps iPrimProps) {
        return this.generate(clazz, mesh.getNumVertsPerPrim());
    }

    private ElementMesh<ElemT> generate(Class<ElemT> clazz, int n) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, 1);
        objectArray[0] = this.element;
        return new ElementMesh<Object>(ElementMesh.Mapping.ALL_SAME, objectArray, n);
    }

    @Override
    public List<ElemT> generate(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc) {
        return new UniformList(list);
    }

    private class UniformList
    extends AbstractList<ElemT> {
        private final List<? extends IPrimitive> d_prims;
        private Integer d_size = null;

        public UniformList(List<? extends IPrimitive> list) {
            this.d_prims = list;
        }

        @Override
        public ElemT get(int n) {
            return ElementUniform.this.element;
        }

        @Override
        public synchronized int size() {
            if (this.d_size == null) {
                int n = 0;
                for (IPolygon iPolygon : theUtil.filter(this.d_prims, IPolygon.class)) {
                    n += iPolygon.getNumVerts();
                }
                this.d_size = n;
            }
            return this.d_size;
        }
    }
}

