/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.FlattenedList;

public class ElementSubList<ElemT>
implements IElemSource<ElemT>,
Serializable {
    static final long serialVersionUID = 1L;
    private final IElemSource<ElemT> d_baseList;
    private final int d_offset;
    private final int d_length;

    public ElementSubList(IElemSource<ElemT> iElemSource, int n, int n2) {
        this.d_baseList = iElemSource;
        this.d_offset = n;
        this.d_length = n2;
    }

    public IElemSource<ElemT> getBaseSource() {
        return this.d_baseList;
    }

    public int getOffset() {
        return this.d_offset;
    }

    public int getEnd() {
        return this.d_offset + this.d_length;
    }

    @Override
    public int getNumPrims() {
        return this.d_length;
    }

    @Override
    public ElemT getPrimVertElement(int n, int n2) {
        return this.d_baseList.getPrimVertElement(this.d_offset + n, n2);
    }

    @Override
    public IElemSource<ElemT> getPrimSource(int n) {
        return this.d_baseList.getPrimSource(n + this.d_offset);
    }

    @Override
    public IElemSource<ElemT> subset(int n, int n2) {
        if (n == 0 && n2 == this.d_length) {
            return this;
        }
        return this.d_baseList.subset(n + this.d_offset, n2);
    }

    @Override
    public List<ElemT> generate(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc) {
        assert (list.size() == this.d_length);
        return new FlattenedList(new EList(clazz, list, iElemSource, iPropsSrc));
    }

    @Override
    public IElemSource<ElemT> transform(Class<ElemT> clazz, UnaryOperator<ElemT> unaryOperator) {
        IElemSource<ElemT> iElemSource = this.d_baseList.transform(clazz, unaryOperator);
        return iElemSource == this.d_baseList ? this : new ElementSubList<ElemT>(iElemSource, this.d_offset, this.d_length);
    }

    @Override
    public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> iElemSource) {
        if (iElemSource instanceof ElementSubList && ((ElementSubList)iElemSource).d_baseList == this.d_baseList && ((ElementSubList)iElemSource).d_offset == this.d_offset + this.d_length) {
            return this.d_baseList.subset(this.d_offset, this.d_length + ((ElementSubList)iElemSource).d_length);
        }
        return null;
    }

    @Override
    public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> iElemSource) {
        if (iElemSource instanceof ElementSubList && ((ElementSubList)iElemSource).d_baseList == this.d_baseList && this.d_offset == ((ElementSubList)iElemSource).getEnd()) {
            return this.d_baseList.subset(((ElementSubList)iElemSource).d_offset, ((ElementSubList)iElemSource).d_length + this.d_length);
        }
        return null;
    }

    @Override
    public boolean isComposite() {
        return this.d_baseList.isComposite();
    }

    @Override
    public Iterator<IElemSource<ElemT>> getPrimIterator(int n) {
        return new PrimIt(n);
    }

    private class EList
    extends AbstractList<List<ElemT>> {
        private final Class<ElemT> type;
        private final List<? extends IPolygon> prims;
        private final IElemSource<Elements.Orient> primOrients;
        private final IPropsSrc props;

        public EList(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc) {
            this.type = clazz;
            this.prims = list;
            this.primOrients = iElemSource;
            this.props = iPropsSrc;
        }

        @Override
        public int size() {
            return ElementSubList.this.d_length;
        }

        @Override
        public List<ElemT> get(int n) {
            return ElementSubList.this.d_baseList.getPrimSource(ElementSubList.this.d_offset + n).generate(this.type, this.prims.subList(n, n + 1), this.primOrients.getPrimSource(n), (IPropsSrc)new UniformProps(this.props.get(n)));
        }

        @Override
        public Iterator<List<ElemT>> iterator() {
            return new It();
        }

        private class It
        implements Iterator<List<ElemT>> {
            private final Iterator<IElemSource<ElemT>> elemit;
            private final Iterator<? extends IPolygon> polyit;
            private final Iterator<IPrimProps> propit;
            private final Iterator<IElemSource<Elements.Orient>> orientit;

            private It() {
                this.elemit = ElementSubList.this.d_baseList.getPrimIterator(ElementSubList.this.d_offset);
                this.polyit = EList.this.prims.iterator();
                this.propit = EList.this.props.iterator();
                this.orientit = EList.this.primOrients.getPrimIterator();
            }

            @Override
            public boolean hasNext() {
                return this.polyit.hasNext();
            }

            @Override
            public List<ElemT> next() {
                return this.elemit.next().generate(EList.this.type, Collections.singletonList(this.polyit.next()), this.orientit.next(), (IPropsSrc)new UniformProps(this.propit.next()));
            }
        }
    }

    private class PrimIt
    implements Iterator<IElemSource<ElemT>> {
        private final Iterator<IElemSource<ElemT>> elemit;
        private int ix;

        private PrimIt(int n) {
            this.ix = n;
            this.elemit = ElementSubList.this.d_baseList.getPrimIterator(ElementSubList.this.d_offset + this.ix);
        }

        @Override
        public boolean hasNext() {
            return this.ix < ElementSubList.this.d_length;
        }

        @Override
        public IElemSource<ElemT> next() {
            IElemSource iElemSource = this.elemit.next();
            ++this.ix;
            return iElemSource;
        }
    }
}

