/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.RepeatedList;
import thunderheadeng.util.theUtil;

public class ElementPoly<ElemT>
implements IElemSource<ElemT>,
Serializable {
    static final long serialVersionUID = 1L;
    public final ElemT[] elements;

    public ElementPoly(ElemT ... ElemTArray) {
        assert (ElemTArray.length > 0);
        this.elements = ElemTArray;
    }

    @Override
    public int getNumPrims() {
        return -1;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> iElemSource) {
        return null;
    }

    @Override
    public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> iElemSource) {
        return null;
    }

    @Override
    public IElemSource<ElemT> subset(int n, int n2) {
        return this;
    }

    @Override
    public IElemSource<ElemT> getPrimSource(int n) {
        return this;
    }

    @Override
    public ElemT getPrimVertElement(int n, int n2) {
        return this.elements[n2];
    }

    @Override
    public ElementMesh<ElemT> generate(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc, int n, boolean bl) {
        assert (!list.isEmpty() && n == this.elements.length);
        if (list.size() == 1) {
            return new ElementMesh<ElemT>(ElementMesh.Mapping.PER_PRIM_VERTEX, this.elements, n);
        }
        int[] nArray = new int[n * list.size()];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = 0;
            while (n3 < n) {
                nArray[n2++] = n3++;
            }
        }
        return new ElementMesh<ElemT>(ElementMesh.Mapping.PER_PRIM_VERTEX, this.elements, nArray, n);
    }

    @Override
    public List<ElemT> generate(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        assert (list.stream().allMatch(iPolygon -> iPolygon instanceof IPolygon && this.elements.length == iPolygon.getNumVerts()));
        List<ElemT> list2 = Arrays.asList(this.elements);
        if (list.size() == 1) {
            return list2;
        }
        return new RepeatedList<ElemT>(list2, list.size());
    }

    @Override
    public ElementPoly<ElemT> transform(Class<ElemT> clazz, UnaryOperator<ElemT> unaryOperator) {
        ElemT[] ElemTArray = theUtil.lazyTransform(this.elements, clazz, unaryOperator);
        return ElemTArray == this.elements ? this : new ElementPoly<ElemT>(ElemTArray);
    }
}

