/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.geometry.objs.elem;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.elem.ElementSubList;
import thunderheadeng.geometry.objs.elem.ElementUniform;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.RepeatedList;
import thunderheadeng.util.theUtil;

public class ElementMesh<ElemT>
extends AbstractList<ElemT>
implements IElemSource<ElemT>,
Serializable {
    static final long serialVersionUID = 1L;
    public static final int[] DIRECT = new int[0];
    public final Mapping mapping;
    public final ElemT[] elements;
    public final int[] indices;
    public final int vertsPerPrim;

    public ElementMesh(Mapping mapping, ElemT[] ElemTArray, int n) {
        this(mapping, ElemTArray, DIRECT, n);
    }

    public ElementMesh(Mapping mapping, ElemT[] ElemTArray, int[] nArray, int n) {
        this.mapping = mapping;
        this.elements = ElemTArray;
        this.indices = nArray.length == 0 ? DIRECT : nArray;
        this.vertsPerPrim = n;
        assert (this.dataConsistent());
    }

    private boolean dataConsistent() {
        int n;
        if (this.mapping != Mapping.PER_PRIM_VERTEX) {
            return true;
        }
        switch (this.indices.length) {
            case 0: {
                n = this.elements.length;
                break;
            }
            default: {
                n = this.indices.length;
            }
        }
        return n % this.vertsPerPrim == 0;
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public IElemSource<ElemT> optimize(Class<ElemT> clazz) {
        int n;
        if (this.mapping == Mapping.ALL_SAME) {
            ElemT ElemT = this.getPrimVertElement(0, 0);
            return new ElementUniform<ElemT>(ElemT);
        }
        switch (this.indices.length) {
            case 0: {
                n = theUtil.getUniformCount(this.elements, 0, this.elements.length, Objects::equals);
                break;
            }
            default: {
                n = ElementMesh.getUniformCount(this.indices, 0, this.indices.length);
            }
        }
        int n2 = this.getNumPrims();
        if (n == n2 * this.vertsPerPrim) {
            ElemT ElemT = this.getPrimVertElement(0, 0);
            return new ElementUniform<ElemT>(ElemT);
        }
        Mapping mapping = this.mapping;
        Object[] objectArray = this.elements;
        int[] nArray = this.indices;
        if (mapping == Mapping.PER_PRIM_VERTEX) {
            int n3;
            boolean bl = true;
            for (n3 = 0; n3 < n2; n3 += n) {
                switch (nArray.length) {
                    case 0: {
                        n = theUtil.getUniformCount(objectArray, n3, n2 - n3, Objects::equals);
                        break;
                    }
                    default: {
                        n = ElementMesh.getUniformCount(nArray, n3, n2 - n3);
                    }
                }
                if (n == this.vertsPerPrim) continue;
                bl = false;
                break;
            }
            if (bl) {
                switch (nArray.length) {
                    case 0: {
                        objectArray = (Object[])Array.newInstance(clazz, n2);
                        for (n3 = 0; n3 < n2; ++n3) {
                            objectArray[n3] = this.getPrimVertElement(n3, 0);
                        }
                        break;
                    }
                    default: {
                        int[] nArray2 = new int[n2];
                        for (int i = 0; i < n2; ++i) {
                            nArray2[i] = nArray[i * this.vertsPerPrim];
                        }
                        nArray = nArray2;
                    }
                }
                mapping = Mapping.PER_PRIM;
            }
        }
        if (nArray.length > 0 && theUtil.isSequential(nArray, 0, nArray.length)) {
            nArray = DIRECT;
        }
        if (objectArray == this.elements && nArray == this.indices && mapping == this.mapping) {
            return this;
        }
        return new ElementMesh<ElemT>(mapping, objectArray, nArray, this.vertsPerPrim);
    }

    private static <T> int getUniformCount(int[] nArray, int n, int n2) {
        if (n2 <= 1) {
            return n2;
        }
        int n3 = nArray[0];
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            if (n3 == nArray[i]) continue;
            return i - n;
        }
        return n2;
    }

    @Override
    public ElemT getPrimVertElement(int n, int n2) {
        int n3;
        switch (this.mapping) {
            case ALL_SAME: {
                n3 = 0;
                break;
            }
            case PER_PRIM: {
                n3 = n;
                break;
            }
            case PER_PRIM_VERTEX: {
                n3 = n * this.vertsPerPrim + n2;
                break;
            }
            default: {
                return null;
            }
        }
        return this.getElement(n3);
    }

    @Override
    public ElemT get(int n) {
        int n2;
        switch (this.mapping) {
            case ALL_SAME: {
                n2 = 0;
                break;
            }
            case PER_PRIM: {
                n2 = n / this.vertsPerPrim;
                break;
            }
            case PER_PRIM_VERTEX: {
                n2 = n;
                break;
            }
            default: {
                return null;
            }
        }
        return this.getElement(n2);
    }

    private ElemT getElement(int n, int n2) {
        int n3;
        switch (this.mapping) {
            case ALL_SAME: {
                n3 = 0;
                break;
            }
            case PER_PRIM: {
                n3 = n;
                break;
            }
            case PER_PRIM_VERTEX: {
                n3 = n2;
                break;
            }
            default: {
                return null;
            }
        }
        return this.getElement(n3);
    }

    private ElemT getElement(int n) {
        switch (this.indices.length) {
            case 0: {
                return this.elements[n];
            }
        }
        return this.elements[this.indices[n]];
    }

    @Override
    public IElemSource<ElemT> getPrimSource(int n) {
        if (this.mapping == Mapping.ALL_SAME) {
            return this;
        }
        return new Prim(this, n);
    }

    @Override
    public Iterator<IElemSource<ElemT>> getPrimIterator(int n) {
        return new PrimIt(n);
    }

    @Override
    public IElemSource<ElemT> subset(int n, int n2) {
        if (this.mapping == Mapping.ALL_SAME || n == 0 && n2 == this.getNumPrims()) {
            return this;
        }
        if (n2 == 1) {
            return this.getPrimSource(n);
        }
        return new ElementSubList(this, n, n2);
    }

    @Override
    public ElementMesh<ElemT> transform(Class<ElemT> clazz, UnaryOperator<ElemT> unaryOperator) {
        ElemT[] ElemTArray = theUtil.lazyTransform(this.elements, clazz, unaryOperator);
        return ElemTArray == this.elements ? this : new ElementMesh<ElemT>(this.mapping, ElemTArray, this.indices, this.vertsPerPrim);
    }

    @Override
    public int getNumPrims() {
        switch (this.mapping) {
            case ALL_SAME: {
                return -1;
            }
            case PER_PRIM: {
                switch (this.indices.length) {
                    case 0: {
                        return this.elements.length;
                    }
                }
                return this.indices.length;
            }
        }
        switch (this.indices.length) {
            case 0: {
                return this.elements.length / this.vertsPerPrim;
            }
        }
        return this.indices.length / this.vertsPerPrim;
    }

    public int getNumVerts() {
        switch (this.mapping) {
            case ALL_SAME: {
                return -1;
            }
            case PER_PRIM: {
                switch (this.indices.length) {
                    case 0: {
                        return this.elements.length * this.vertsPerPrim;
                    }
                }
                return this.indices.length * this.vertsPerPrim;
            }
        }
        switch (this.indices.length) {
            case 0: {
                return this.elements.length;
            }
        }
        return this.indices.length;
    }

    @Override
    public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> iElemSource) {
        return null;
    }

    @Override
    public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> iElemSource) {
        return null;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public ElementMesh<ElemT> generate(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc, int n, boolean bl) {
        assert (this.canGenerate(list, n));
        return this;
    }

    @Override
    public List<ElemT> generate(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc) {
        assert (list.stream().allMatch(iPolygon -> iPolygon.getNumVerts() == this.vertsPerPrim));
        assert (this.canGenerate(list, this.vertsPerPrim));
        return this;
    }

    private boolean canGenerate(List<? extends IPrimitive> list, int n) {
        switch (this.mapping) {
            case ALL_SAME: {
                return true;
            }
            case PER_PRIM: {
                return list.size() == this.getNumPrims();
            }
            case PER_PRIM_VERTEX: {
                return n == this.vertsPerPrim && list.size() == this.getNumPrims();
            }
        }
        return false;
    }

    @Override
    public int size() {
        int n = this.getNumVerts();
        return n == -1 ? Integer.MAX_VALUE : n;
    }

    @Override
    public Iterator<ElemT> iterator() {
        return new ElemIt();
    }

    private class PrimIt
    implements Iterator<IElemSource<ElemT>> {
        private int pix;
        private int vix;
        private final int numPrims;

        public PrimIt(int n) {
            this.pix = n;
            this.vix = n * ElementMesh.this.vertsPerPrim;
            this.numPrims = ElementMesh.this.getNumPrims();
        }

        @Override
        public boolean hasNext() {
            return this.pix < this.numPrims;
        }

        @Override
        public Prim next() {
            Prim prim = new Prim(ElementMesh.this, this.pix, this.vix);
            ++this.pix;
            this.vix += ElementMesh.this.vertsPerPrim;
            return prim;
        }
    }

    private static class PrimElemIt<ElemT>
    implements Iterator<ElemT> {
        private final ElementMesh<ElemT> mesh;
        private final int prim;
        private int vix;
        private final int vend;

        public PrimElemIt(ElementMesh<ElemT> elementMesh, int n, int n2) {
            this.mesh = elementMesh;
            this.prim = n;
            this.vix = n2;
            this.vend = n2 + elementMesh.vertsPerPrim;
        }

        @Override
        public boolean hasNext() {
            return this.vix < this.vend;
        }

        @Override
        public ElemT next() {
            Object ElemT;
            int n;
            switch (this.mesh.mapping) {
                case ALL_SAME: {
                    n = 0;
                    break;
                }
                case PER_PRIM: {
                    n = this.prim;
                    break;
                }
                case PER_PRIM_VERTEX: {
                    n = this.vix;
                    break;
                }
                default: {
                    return null;
                }
            }
            switch (this.mesh.indices.length) {
                case 0: {
                    ElemT = this.mesh.elements[n];
                    break;
                }
                default: {
                    ElemT = this.mesh.elements[this.mesh.indices[n]];
                }
            }
            ++this.vix;
            return ElemT;
        }
    }

    public static class Prim<ElemT>
    extends AbstractList<ElemT>
    implements IElemSource<ElemT>,
    Serializable {
        static final long serialVersionUID = 1L;
        public final ElementMesh<ElemT> mesh;
        public final int prim;
        public final int vbegin;

        public Prim(ElementMesh<ElemT> elementMesh, int n) {
            this(elementMesh, n, n * elementMesh.vertsPerPrim);
        }

        public Prim(ElementMesh<ElemT> elementMesh, int n, int n2) {
            this.mesh = elementMesh;
            this.prim = n;
            this.vbegin = n2;
        }

        @Override
        public boolean equals(Object object) {
            return object == this;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public IElemSource<ElemT> subset(int n, int n2) {
            return this;
        }

        @Override
        public IElemSource<ElemT> getPrimSource(int n) {
            return this;
        }

        @Override
        public ElemT getPrimVertElement(int n, int n2) {
            return this.mesh.getPrimVertElement(this.prim, n2);
        }

        @Override
        public int getNumPrims() {
            return -1;
        }

        @Override
        public IElemSource<ElemT> transform(Class<ElemT> clazz, UnaryOperator<ElemT> unaryOperator) {
            assert (false);
            IElemSource iElemSource = this.mesh.transform((Class)clazz, (UnaryOperator)unaryOperator);
            if (iElemSource == this.mesh) {
                return this;
            }
            return new Prim<ElemT>(iElemSource, this.prim, this.vbegin);
        }

        @Override
        public ElementMesh<ElemT> generate(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc, int n, boolean bl) {
            assert (n == this.mesh.vertsPerPrim);
            return this.generate(this.prim, this.vbegin, list.size());
        }

        @Override
        public List<ElemT> generate(Class<ElemT> clazz, List<? extends IPolygon> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc) {
            assert (!list.isEmpty());
            assert (list.stream().allMatch(iPolygon -> iPolygon.getNumVerts() == this.mesh.vertsPerPrim));
            if (list.size() == 1) {
                return this;
            }
            return new RepeatedList(this, list.size());
        }

        private ElementMesh<ElemT> generate(int n, int n2, int n3) {
            switch (this.mesh.mapping) {
                case ALL_SAME: {
                    return this.mesh;
                }
                case PER_PRIM: {
                    int n4 = this.mesh.indices.length > 0 ? this.mesh.indices[n] : n;
                    int[] nArray = new int[n3];
                    Arrays.fill(nArray, n4);
                    return new ElementMesh(Mapping.ALL_SAME, this.mesh.elements, nArray, this.mesh.vertsPerPrim);
                }
                case PER_PRIM_VERTEX: {
                    int n5 = n2;
                    int[] nArray = new int[this.mesh.vertsPerPrim * n3];
                    int n6 = 0;
                    while (n6 < nArray.length) {
                        for (int i = 0; i < this.mesh.vertsPerPrim; ++i) {
                            int n7 = n5 + i;
                            nArray[n6++] = this.mesh.indices.length > 0 ? this.mesh.indices[n7] : n7;
                        }
                    }
                    return new ElementMesh(Mapping.PER_PRIM_VERTEX, this.mesh.elements, nArray, this.mesh.vertsPerPrim);
                }
            }
            assert (false);
            return null;
        }

        @Override
        public Iterator<ElemT> iterator() {
            return new PrimElemIt<ElemT>(this.mesh, this.prim, this.vbegin);
        }

        @Override
        public ElemT get(int n) {
            int n2;
            switch (this.mesh.mapping) {
                case ALL_SAME: {
                    n2 = 0;
                    break;
                }
                case PER_PRIM: {
                    n2 = this.prim;
                    break;
                }
                case PER_PRIM_VERTEX: {
                    n2 = this.vbegin + n;
                    break;
                }
                default: {
                    return null;
                }
            }
            switch (this.mesh.indices.length) {
                case 0: {
                    return this.mesh.elements[n2];
                }
            }
            return this.mesh.elements[this.mesh.indices[n2]];
        }

        @Override
        public int size() {
            return this.mesh.vertsPerPrim;
        }

        @Override
        public IElemSource<ElemT> postConcatenate(IElemSource<ElemT> iElemSource) {
            if (iElemSource instanceof Prim && ((Prim)iElemSource).mesh == this.mesh && ((Prim)iElemSource).prim == this.prim + 1) {
                return this.mesh.subset(this.prim, 2);
            }
            if (iElemSource instanceof ElementSubList && ((ElementSubList)iElemSource).getBaseSource() == this.mesh && ((ElementSubList)iElemSource).getOffset() == this.prim + 1) {
                return this.mesh.subset(this.prim, ((ElementSubList)iElemSource).getNumPrims() + 1);
            }
            return null;
        }

        @Override
        public IElemSource<ElemT> preConcatenate(IElemSource<ElemT> iElemSource) {
            if (iElemSource instanceof Prim && ((Prim)iElemSource).mesh == this.mesh && ((Prim)iElemSource).prim == this.prim - 1) {
                return this.mesh.subset(this.prim - 1, 2);
            }
            if (iElemSource instanceof ElementSubList && ((ElementSubList)iElemSource).getBaseSource() == this.mesh && ((ElementSubList)iElemSource).getEnd() == this.prim) {
                return this.mesh.subset(((ElementSubList)iElemSource).getOffset(), ((ElementSubList)iElemSource).getNumPrims() + 1);
            }
            return null;
        }

        @Override
        public boolean isComposite() {
            return false;
        }
    }

    private class ElemIt
    implements Iterator<ElemT> {
        private int primix = 0;
        private int vix = 0;
        private int nextVEnd;
        private final int vend;

        public ElemIt() {
            this.nextVEnd = ElementMesh.this.vertsPerPrim;
            int n = ElementMesh.this.getNumVerts();
            this.vend = n == -1 ? Integer.MAX_VALUE : n;
        }

        @Override
        public boolean hasNext() {
            return this.vix < this.vend;
        }

        @Override
        public ElemT next() {
            Object object = ElementMesh.this.getElement(this.primix, this.vix);
            ++this.vix;
            if (this.vix >= this.nextVEnd) {
                ++this.primix;
                this.nextVEnd = this.vix + ElementMesh.this.vertsPerPrim;
            }
            return object;
        }
    }

    public static enum Mapping {
        PER_PRIM_VERTEX,
        PER_PRIM,
        ALL_SAME;

    }
}

